/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.grpc.server;

import org.apache.ratis.client.impl.ClientProtoUtils;
import org.apache.ratis.grpc.GrpcUtil;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.proto.grpc.AdminProtocolServiceGrpc;
import org.apache.ratis.protocol.AdminAsynchronousProtocol;
import org.apache.ratis.protocol.GroupInfoRequest;
import org.apache.ratis.protocol.GroupListRequest;
import org.apache.ratis.protocol.GroupManagementRequest;
import org.apache.ratis.thirdparty.io.grpc.stub.StreamObserver;

public class GrpcAdminProtocolService
extends AdminProtocolServiceGrpc.AdminProtocolServiceImplBase {
    private final AdminAsynchronousProtocol protocol;

    public GrpcAdminProtocolService(AdminAsynchronousProtocol protocol) {
        this.protocol = protocol;
    }

    @Override
    public void groupManagement(RaftProtos.GroupManagementRequestProto proto, StreamObserver<RaftProtos.RaftClientReplyProto> responseObserver) {
        GroupManagementRequest request = ClientProtoUtils.toGroupManagementRequest(proto);
        GrpcUtil.asyncCall(responseObserver, () -> this.protocol.groupManagementAsync(request), ClientProtoUtils::toRaftClientReplyProto);
    }

    @Override
    public void groupList(RaftProtos.GroupListRequestProto proto, StreamObserver<RaftProtos.GroupListReplyProto> responseObserver) {
        GroupListRequest request = ClientProtoUtils.toGroupListRequest(proto);
        GrpcUtil.asyncCall(responseObserver, () -> this.protocol.getGroupListAsync(request), ClientProtoUtils::toGroupListReplyProto);
    }

    @Override
    public void groupInfo(RaftProtos.GroupInfoRequestProto proto, StreamObserver<RaftProtos.GroupInfoReplyProto> responseObserver) {
        GroupInfoRequest request = ClientProtoUtils.toGroupInfoRequest(proto);
        GrpcUtil.asyncCall(responseObserver, () -> this.protocol.getGroupInfoAsync(request), ClientProtoUtils::toGroupInfoReplyProto);
    }
}

