/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.grpc.metrics;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Timer;
import java.util.Optional;
import org.apache.ratis.metrics.MetricRegistries;
import org.apache.ratis.metrics.MetricRegistryInfo;
import org.apache.ratis.metrics.RatisMetricRegistry;
import org.apache.ratis.thirdparty.com.google.common.annotations.VisibleForTesting;

public class GrpcServerMetrics {
    private final RatisMetricRegistry registry;
    private static final String RATIS_GRPC_METRICS_APP_NAME = "ratis_grpc";
    private static final String RATIS_GRPC_METRICS_COMP_NAME = "log_appender";
    private static final String RATIS_GRPC_METRICS_DESC = "Metrics for Ratis Grpc Log Appender";
    public static final String RATIS_GRPC_METRICS_LOG_APPENDER_LATENCY = "%s_latency";
    public static final String RATIS_GRPC_METRICS_LOG_APPENDER_SUCCESS = "%s_success_reply_count";
    public static final String RATIS_GRPC_METRICS_LOG_APPENDER_NOT_LEADER = "%s_not_leader_reply_count";
    public static final String RATIS_GRPC_METRICS_LOG_APPENDER_INCONSISTENCY = "%s_inconsistency_reply_count";
    public static final String RATIS_GRPC_METRICS_LOG_APPENDER_TIMEOUT = "%s_append_entry_timeout_count";
    public static final String RATIS_GRPC_METRICS_LOG_APPENDER_PENDING_COUNT = "%s_pending_log_requests_count";
    public static final String RATIS_GRPC_METRICS_REQUEST_RETRY_COUNT = "num_retries";
    public static final String RATIS_GRPC_METRICS_REQUESTS_TOTAL = "num_requests";
    public static final String RATIS_GRPC_INSTALL_SNAPSHOT_COUNT = "num_install_snapshot";

    public GrpcServerMetrics(String serverId) {
        MetricRegistryInfo info = new MetricRegistryInfo(serverId, RATIS_GRPC_METRICS_APP_NAME, RATIS_GRPC_METRICS_COMP_NAME, RATIS_GRPC_METRICS_DESC);
        Optional<RatisMetricRegistry> metricRegistry = MetricRegistries.global().get(info);
        this.registry = metricRegistry.orElseGet(() -> MetricRegistries.global().create(info));
    }

    public Timer getGrpcLogAppenderLatencyTimer(String follower) {
        return this.registry.timer(String.format(RATIS_GRPC_METRICS_LOG_APPENDER_LATENCY, follower));
    }

    public void onRequestRetry() {
        this.registry.counter(RATIS_GRPC_METRICS_REQUEST_RETRY_COUNT).inc();
    }

    public void onRequestCreate() {
        this.registry.counter(RATIS_GRPC_METRICS_REQUESTS_TOTAL).inc();
    }

    public void onRequestSuccess(String follower) {
        this.registry.counter(String.format(RATIS_GRPC_METRICS_LOG_APPENDER_SUCCESS, follower)).inc();
    }

    public void onRequestNotLeader(String follower) {
        this.registry.counter(String.format(RATIS_GRPC_METRICS_LOG_APPENDER_NOT_LEADER, follower)).inc();
    }

    public void onRequestInconsistency(String follower) {
        this.registry.counter(String.format(RATIS_GRPC_METRICS_LOG_APPENDER_INCONSISTENCY, follower)).inc();
    }

    public void onRequestTimeout(String follower) {
        this.registry.counter(String.format(RATIS_GRPC_METRICS_LOG_APPENDER_TIMEOUT, follower)).inc();
    }

    public void addPendingRequestsCount(String follower, Gauge pendinglogQueueSize) {
        this.registry.gauge(String.format(RATIS_GRPC_METRICS_LOG_APPENDER_PENDING_COUNT, follower), () -> pendinglogQueueSize);
    }

    public void onInstallSnapshot() {
        this.registry.counter(RATIS_GRPC_INSTALL_SNAPSHOT_COUNT).inc();
    }

    @VisibleForTesting
    public RatisMetricRegistry getRegistry() {
        return this.registry;
    }
}

