/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.examples.filestore.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.examples.filestore.FileStoreClient;
import org.apache.ratis.examples.filestore.cli.Client;

@Parameters(commandDescription="Load Generator for FileStore")
public class LoadGen
extends Client {
    private static final String UTF8_CSN = StandardCharsets.UTF_8.name();
    @Parameter(names={"--size"}, description="Size of each file", required=true)
    private String size;
    @Parameter(names={"--numFiles"}, description="Number of files", required=true)
    private String numFiles;

    private static byte[] string2Bytes(String str) {
        try {
            return str.getBytes(UTF8_CSN);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("UTF8 decoding is not supported", e);
        }
    }

    @Override
    protected void operation(RaftClient client) throws IOException {
        int length = Integer.parseInt(this.size);
        int num = Integer.parseInt(this.numFiles);
        AtomicLong totalBytes = new AtomicLong(0L);
        String entropy = RandomStringUtils.randomAlphanumeric(10);
        byte[] fileValue = LoadGen.string2Bytes(RandomStringUtils.randomAscii(length));
        FileStoreClient fileStoreClient = new FileStoreClient(client);
        System.out.println("Starting load now ");
        long startTime = System.currentTimeMillis();
        ArrayList<CompletableFuture<Long>> futures = new ArrayList<CompletableFuture<Long>>();
        for (int i = 0; i < num; ++i) {
            String string = "file-" + entropy + "-" + i;
            ByteBuffer b = ByteBuffer.wrap(fileValue);
            futures.add(fileStoreClient.writeAsync(string, 0L, true, b));
        }
        for (CompletableFuture completableFuture : futures) {
            Long writtenLen = (Long)completableFuture.join();
            totalBytes.addAndGet(writtenLen);
            if (writtenLen == (long)length) continue;
            System.out.println("File length written is wrong: " + writtenLen + length);
        }
        long endTime = System.currentTimeMillis();
        System.out.println("Total files written: " + futures.size());
        System.out.println("Each files size: " + length);
        System.out.println("Total data written: " + totalBytes + " bytes");
        System.out.println("Total time taken: " + (endTime - startTime) + " millis");
        client.close();
        System.exit(0);
    }
}

