/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.examples.filestore;

import java.io.File;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import org.apache.ratis.conf.ConfUtils;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.examples.filestore.FileStore;
import org.apache.ratis.examples.filestore.FileStoreCommon;
import org.apache.ratis.proto.ExamplesProtos;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.storage.RaftStorage;
import org.apache.ratis.statemachine.StateMachineStorage;
import org.apache.ratis.statemachine.TransactionContext;
import org.apache.ratis.statemachine.impl.BaseStateMachine;
import org.apache.ratis.statemachine.impl.SimpleStateMachineStorage;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.ratis.util.FileUtils;

public class FileStoreStateMachine
extends BaseStateMachine {
    private final SimpleStateMachineStorage storage = new SimpleStateMachineStorage();
    private final FileStore files;

    public FileStoreStateMachine(RaftProperties properties) {
        File dir = ConfUtils.getFile(properties::getFile, "example.filestore.statemachine.dir", null, LOG::info, new BiConsumer[0]);
        Objects.requireNonNull(dir, "example.filestore.statemachine.dir is not set.");
        this.files = new FileStore(this::getId, dir.toPath());
    }

    @Override
    public void initialize(RaftServer server, RaftGroupId groupId, RaftStorage raftStorage) throws IOException {
        super.initialize(server, groupId, raftStorage);
        this.storage.init(raftStorage);
        FileUtils.createDirectories(this.files.getRoot());
    }

    @Override
    public StateMachineStorage getStateMachineStorage() {
        return this.storage;
    }

    @Override
    public void close() {
        this.files.close();
        this.setLastAppliedTermIndex(null);
    }

    @Override
    public CompletableFuture<Message> query(Message request) {
        ExamplesProtos.ReadRequestProto proto;
        try {
            proto = ExamplesProtos.ReadRequestProto.parseFrom(request.getContent());
        }
        catch (InvalidProtocolBufferException e) {
            return FileStoreCommon.completeExceptionally("Failed to parse " + request, e);
        }
        String path = proto.getPath().toStringUtf8();
        return this.files.read(path, proto.getOffset(), proto.getLength()).thenApply(reply -> Message.valueOf(reply.toByteString()));
    }

    @Override
    public TransactionContext startTransaction(RaftClientRequest request) throws IOException {
        ByteString content = request.getMessage().getContent();
        ExamplesProtos.FileStoreRequestProto proto = ExamplesProtos.FileStoreRequestProto.parseFrom(content);
        TransactionContext.Builder b = TransactionContext.newBuilder().setStateMachine(this).setClientRequest(request);
        if (proto.getRequestCase() == ExamplesProtos.FileStoreRequestProto.RequestCase.WRITE) {
            ExamplesProtos.WriteRequestProto write = proto.getWrite();
            ExamplesProtos.FileStoreRequestProto newProto = ExamplesProtos.FileStoreRequestProto.newBuilder().setWriteHeader(write.getHeader()).build();
            b.setLogData(newProto.toByteString()).setStateMachineData(write.getData());
        } else {
            b.setLogData(content);
        }
        return b.build();
    }

    public CompletableFuture<Integer> writeStateMachineData(RaftProtos.LogEntryProto entry) {
        ExamplesProtos.FileStoreRequestProto proto;
        RaftProtos.StateMachineLogEntryProto smLog = entry.getStateMachineLogEntry();
        ByteString data = smLog.getLogData();
        try {
            proto = ExamplesProtos.FileStoreRequestProto.parseFrom(data);
        }
        catch (InvalidProtocolBufferException e) {
            return FileStoreCommon.completeExceptionally(entry.getIndex(), "Failed to parse data, entry=" + entry, e);
        }
        if (proto.getRequestCase() != ExamplesProtos.FileStoreRequestProto.RequestCase.WRITEHEADER) {
            return null;
        }
        ExamplesProtos.WriteRequestHeaderProto h = proto.getWriteHeader();
        CompletableFuture<Integer> f = this.files.write(entry.getIndex(), h.getPath().toStringUtf8(), h.getClose(), h.getOffset(), smLog.getStateMachineEntry().getStateMachineData());
        return h.getClose() ? f : null;
    }

    @Override
    public CompletableFuture<ByteString> readStateMachineData(RaftProtos.LogEntryProto entry) {
        ExamplesProtos.FileStoreRequestProto proto;
        RaftProtos.StateMachineLogEntryProto smLog = entry.getStateMachineLogEntry();
        ByteString data = smLog.getLogData();
        try {
            proto = ExamplesProtos.FileStoreRequestProto.parseFrom(data);
        }
        catch (InvalidProtocolBufferException e) {
            return FileStoreCommon.completeExceptionally(entry.getIndex(), "Failed to parse data, entry=" + entry, e);
        }
        if (proto.getRequestCase() != ExamplesProtos.FileStoreRequestProto.RequestCase.WRITEHEADER) {
            return null;
        }
        ExamplesProtos.WriteRequestHeaderProto h = proto.getWriteHeader();
        CompletableFuture<ExamplesProtos.ReadReplyProto> reply = this.files.read(h.getPath().toStringUtf8(), h.getOffset(), h.getLength());
        return reply.thenApply(ExamplesProtos.ReadReplyProto::getData);
    }

    @Override
    public CompletableFuture<Message> applyTransaction(TransactionContext trx) {
        ExamplesProtos.FileStoreRequestProto request;
        RaftProtos.LogEntryProto entry = trx.getLogEntry();
        long index = entry.getIndex();
        this.updateLastAppliedTermIndex(entry.getTerm(), index);
        RaftProtos.StateMachineLogEntryProto smLog = entry.getStateMachineLogEntry();
        try {
            request = ExamplesProtos.FileStoreRequestProto.parseFrom(smLog.getLogData());
        }
        catch (InvalidProtocolBufferException e) {
            return FileStoreCommon.completeExceptionally(index, "Failed to parse logData in" + smLog, e);
        }
        switch (request.getRequestCase()) {
            case DELETE: {
                return this.delete(index, request.getDelete());
            }
            case WRITEHEADER: {
                return this.writeCommit(index, request.getWriteHeader(), smLog.getStateMachineEntry().getStateMachineData().size());
            }
        }
        LOG.error(this.getId() + ": Unexpected request case " + request.getRequestCase());
        return FileStoreCommon.completeExceptionally(index, "Unexpected request case " + request.getRequestCase());
    }

    private CompletableFuture<Message> writeCommit(long index, ExamplesProtos.WriteRequestHeaderProto header, int size) {
        String path = header.getPath().toStringUtf8();
        return this.files.submitCommit(index, path, header.getClose(), header.getOffset(), size).thenApply(reply -> Message.valueOf(reply.toByteString()));
    }

    private CompletableFuture<Message> delete(long index, ExamplesProtos.DeleteRequestProto request) {
        String path = request.getPath().toStringUtf8();
        return this.files.delete(index, path).thenApply(resolved -> Message.valueOf(ExamplesProtos.DeleteReplyProto.newBuilder().setResolvedPath(FileStoreCommon.toByteString(resolved)).build().toByteString(), () -> "Message:" + resolved));
    }
}

