/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.examples.filestore;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Function;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.examples.filestore.FileStoreCommon;
import org.apache.ratis.proto.ExamplesProtos;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.StateMachineException;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.ProtoUtils;
import org.apache.ratis.util.function.CheckedFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileStoreClient
implements Closeable {
    public static final Logger LOG = LoggerFactory.getLogger(FileStoreClient.class);
    private final RaftClient client;

    public FileStoreClient(RaftGroup group, RaftProperties properties) throws IOException {
        this.client = RaftClient.newBuilder().setProperties(properties).setRaftGroup(group).build();
    }

    public FileStoreClient(RaftClient client) {
        this.client = client;
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }

    static ByteString send(ByteString request, CheckedFunction<Message, RaftClientReply, IOException> sendFunction) throws IOException {
        RaftClientReply reply = sendFunction.apply(Message.valueOf(request));
        StateMachineException sme = reply.getStateMachineException();
        if (sme != null) {
            throw new IOException("Failed to send request " + request, sme);
        }
        Preconditions.assertTrue(reply.isSuccess(), () -> "Failed " + request + ", reply=" + reply);
        return reply.getMessage().getContent();
    }

    static CompletableFuture<ByteString> sendAsync(ByteString request, Function<Message, CompletableFuture<RaftClientReply>> sendFunction) {
        return sendFunction.apply(() -> request).thenApply(reply -> {
            StateMachineException sme = reply.getStateMachineException();
            if (sme != null) {
                throw new CompletionException("Failed to send request " + request, sme);
            }
            Preconditions.assertTrue(reply.isSuccess(), () -> "Failed " + request + ", reply=" + reply);
            return reply.getMessage().getContent();
        });
    }

    private ByteString send(ByteString request) throws IOException {
        return FileStoreClient.send(request, this.client::send);
    }

    private ByteString sendReadOnly(ByteString request) throws IOException {
        return FileStoreClient.send(request, this.client::sendReadOnly);
    }

    private CompletableFuture<ByteString> sendAsync(ByteString request) {
        return FileStoreClient.sendAsync(request, this.client::sendAsync);
    }

    private CompletableFuture<ByteString> sendReadOnlyAsync(ByteString request) {
        return FileStoreClient.sendAsync(request, this.client::sendReadOnlyAsync);
    }

    public ByteString read(String path, long offset, long length) throws IOException {
        ByteString reply = FileStoreClient.readImpl(this::sendReadOnly, path, offset, length);
        return ExamplesProtos.ReadReplyProto.parseFrom(reply).getData();
    }

    public CompletableFuture<ByteString> readAsync(String path, long offset, long length) {
        return FileStoreClient.readImpl(this::sendReadOnlyAsync, path, offset, length).thenApply(reply -> JavaUtils.supplyAndWrapAsCompletionException(() -> ExamplesProtos.ReadReplyProto.parseFrom(reply).getData()));
    }

    private static <OUTPUT, THROWABLE extends Throwable> OUTPUT readImpl(CheckedFunction<ByteString, OUTPUT, THROWABLE> sendReadOnlyFunction, String path, long offset, long length) throws THROWABLE {
        ExamplesProtos.ReadRequestProto read = ExamplesProtos.ReadRequestProto.newBuilder().setPath(ProtoUtils.toByteString(path)).setOffset(offset).setLength(length).build();
        return sendReadOnlyFunction.apply(read.toByteString());
    }

    public long write(String path, long offset, boolean close, ByteBuffer buffer) throws IOException {
        int chunkSize = FileStoreCommon.getChunkSize(buffer.remaining());
        buffer.limit(chunkSize);
        ByteString reply = FileStoreClient.writeImpl(this::send, path, offset, close, buffer);
        return ExamplesProtos.WriteReplyProto.parseFrom(reply).getLength();
    }

    public CompletableFuture<Long> writeAsync(String path, long offset, boolean close, ByteBuffer buffer) {
        return FileStoreClient.writeImpl(this::sendAsync, path, offset, close, buffer).thenApply(reply -> JavaUtils.supplyAndWrapAsCompletionException(() -> ExamplesProtos.WriteReplyProto.parseFrom(reply).getLength()));
    }

    private static <OUTPUT, THROWABLE extends Throwable> OUTPUT writeImpl(CheckedFunction<ByteString, OUTPUT, THROWABLE> sendFunction, String path, long offset, boolean close, ByteBuffer data) throws THROWABLE {
        ExamplesProtos.WriteRequestHeaderProto.Builder header = ExamplesProtos.WriteRequestHeaderProto.newBuilder().setPath(ProtoUtils.toByteString(path)).setOffset(offset).setLength(data.position()).setClose(close);
        ExamplesProtos.WriteRequestProto.Builder write = ExamplesProtos.WriteRequestProto.newBuilder().setHeader(header).setData(ByteString.copyFrom(data));
        ExamplesProtos.FileStoreRequestProto request = ExamplesProtos.FileStoreRequestProto.newBuilder().setWrite(write).build();
        return sendFunction.apply(request.toByteString());
    }

    private static <OUTPUT, THROWABLE extends Throwable> OUTPUT deleteImpl(CheckedFunction<ByteString, OUTPUT, THROWABLE> sendFunction, String path) throws THROWABLE {
        ExamplesProtos.DeleteRequestProto.Builder delete = ExamplesProtos.DeleteRequestProto.newBuilder().setPath(ProtoUtils.toByteString(path));
        ExamplesProtos.FileStoreRequestProto request = ExamplesProtos.FileStoreRequestProto.newBuilder().setDelete(delete).build();
        return sendFunction.apply(request.toByteString());
    }

    public String delete(String path) throws IOException {
        ByteString reply = FileStoreClient.deleteImpl(this::send, path);
        return ExamplesProtos.DeleteReplyProto.parseFrom(reply).getResolvedPath().toStringUtf8();
    }

    public CompletableFuture<String> deleteAsync(String path) {
        return FileStoreClient.deleteImpl(this::sendAsync, path).thenApply(reply -> JavaUtils.supplyAndWrapAsCompletionException(() -> ExamplesProtos.DeleteReplyProto.parseFrom(reply).getResolvedPath().toStringUtf8()));
    }
}

