/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.examples.common;

import com.beust.jcommander.Parameter;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;

public abstract class SubCommandBase {
    @Parameter(names={"--raftGroup", "-g"}, description="Raft group identifier")
    private String raftGroupId = "demoRaftGroup123";
    @Parameter(names={"--peers", "-r"}, description="Raft peers (format: name:host:port,name:host:port)", required=true)
    private String peers;

    public static RaftPeer[] parsePeers(String peers) {
        return (RaftPeer[])Stream.of(peers.split(",")).map(address -> {
            String[] addressParts = address.split(":");
            return new RaftPeer(RaftPeerId.valueOf(addressParts[0]), addressParts[1] + ":" + addressParts[2]);
        }).toArray(RaftPeer[]::new);
    }

    public RaftPeer[] getPeers() {
        return SubCommandBase.parsePeers(this.peers);
    }

    public abstract void run() throws Exception;

    public String getRaftGroupId() {
        return this.raftGroupId;
    }

    public RaftPeer getPeer(RaftPeerId raftPeerId) {
        Objects.requireNonNull(raftPeerId, "raftPeerId == null");
        for (RaftPeer p : this.getPeers()) {
            if (!raftPeerId.equals(p.getId())) continue;
            return p;
        }
        throw new IllegalArgumentException("Raft peer id " + raftPeerId + " is not part of the raft group definitions " + this.peers);
    }
}

