/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.examples.arithmetic.expression;

import java.util.Map;
import java.util.regex.Pattern;
import org.apache.ratis.examples.arithmetic.AssignmentMessage;
import org.apache.ratis.examples.arithmetic.expression.DoubleValue;
import org.apache.ratis.examples.arithmetic.expression.Expression;
import org.apache.ratis.util.Preconditions;

public class Variable
implements Expression {
    static final int LENGTH_LIMIT = 32;
    static final String REGEX = "[a-zA-Z]\\w*";
    static final Pattern PATTERN = Pattern.compile("[a-zA-Z]\\w*");
    private final String name;
    private final byte[] encoded;

    static byte[] string2bytes(String s) {
        byte[] stringBytes = s.getBytes(AssignmentMessage.UTF8);
        byte[] bytes = new byte[stringBytes.length + 2];
        bytes[0] = Expression.Type.VARIABLE.byteValue();
        bytes[1] = (byte)stringBytes.length;
        System.arraycopy(stringBytes, 0, bytes, 2, stringBytes.length);
        return bytes;
    }

    static String extractString(byte[] buf, int offset) {
        Preconditions.assertTrue(buf[offset] == Expression.Type.VARIABLE.byteValue());
        byte length = buf[offset + 1];
        byte[] stringBytes = new byte[length];
        System.arraycopy(buf, offset + 2, stringBytes, 0, length);
        return new String(stringBytes, AssignmentMessage.UTF8);
    }

    static byte[] copyBytes(byte[] buf, int offset) {
        Preconditions.assertTrue(buf[offset] == Expression.Type.VARIABLE.byteValue());
        byte length = buf[offset + 1];
        byte[] copy = new byte[length + 2];
        System.arraycopy(buf, offset, copy, 0, copy.length);
        return copy;
    }

    private Variable(String name, byte[] encoded) {
        this.name = name;
        this.encoded = encoded;
        if (!PATTERN.matcher(name).matches()) {
            throw new IllegalArgumentException("The variable name \"" + name + "\" does not match the pattern \"" + PATTERN + "\"");
        }
        if (encoded.length - 2 > 32) {
            throw new IllegalArgumentException("The variable name \"" + name + "\" is longer than the limit = " + 32);
        }
    }

    public Variable(byte[] buf, int offset) {
        this(Variable.extractString(buf, offset), Variable.copyBytes(buf, offset));
    }

    public Variable(String name) {
        this(name, Variable.string2bytes(name));
    }

    public String getName() {
        return this.name;
    }

    public AssignmentMessage assign(double value) {
        return this.assign(new DoubleValue(value));
    }

    public AssignmentMessage assign(Expression e) {
        return new AssignmentMessage(this, e);
    }

    @Override
    public int toBytes(byte[] buf, int offset) {
        System.arraycopy(this.encoded, 0, buf, offset, this.encoded.length);
        return this.encoded.length;
    }

    @Override
    public int length() {
        return this.encoded.length;
    }

    @Override
    public Double evaluate(Map<String, Double> variableMap) {
        Double value = variableMap.get(this.name);
        if (value == null) {
            throw new IllegalStateException("Undefined variable \"" + this.name + "\"");
        }
        return value;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof Variable)) {
            return false;
        }
        Variable that = (Variable)obj;
        return this.getName().equals(that.getName());
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }
}

