/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.examples.arithmetic.expression;

import org.apache.ratis.examples.arithmetic.Evaluable;
import org.apache.ratis.examples.arithmetic.expression.BinaryExpression;
import org.apache.ratis.examples.arithmetic.expression.DoubleValue;
import org.apache.ratis.examples.arithmetic.expression.NullValue;
import org.apache.ratis.examples.arithmetic.expression.UnaryExpression;
import org.apache.ratis.examples.arithmetic.expression.Variable;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.ProtoUtils;

public interface Expression
extends Evaluable {
    public int toBytes(byte[] var1, int var2);

    public int length();

    public static class Utils {
        private Utils() {
        }

        public static Message toMessage(Expression e) {
            byte[] buf = new byte[e.length()];
            int length = e.toBytes(buf, 0);
            Preconditions.assertTrue(length == buf.length);
            return Message.valueOf(ProtoUtils.toByteString(buf), () -> "Message:" + e);
        }

        public static Expression double2Expression(Double d) {
            return d == null ? NullValue.getInstance() : new DoubleValue(d);
        }

        public static Expression bytes2Expression(byte[] buf, int offset) {
            Type type = Type.valueOf(buf[offset]);
            switch (type) {
                case NULL: {
                    return NullValue.getInstance();
                }
                case DOUBLE: {
                    return new DoubleValue(buf, offset);
                }
                case VARIABLE: {
                    return new Variable(buf, offset);
                }
                case BINARY: {
                    return new BinaryExpression(buf, offset);
                }
                case UNARY: {
                    return new UnaryExpression(buf, offset);
                }
            }
            throw new AssertionError((Object)("Unknown expression type " + (Object)((Object)type)));
        }

        public static int int2bytes(int v, byte[] buf, int offset) {
            buf[offset] = (byte)(v >>> 24);
            buf[offset + 1] = (byte)(v >>> 16);
            buf[offset + 2] = (byte)(v >>> 8);
            buf[offset + 3] = (byte)v;
            return 4;
        }

        public static int long2bytes(long v, byte[] buf, int offset) {
            Utils.int2bytes((int)(v >>> 32), buf, offset);
            Utils.int2bytes((int)v, buf, offset + 4);
            return 8;
        }

        public static int double2bytes(double d, byte[] buf, int offset) {
            long v = Double.doubleToRawLongBits(d);
            return Utils.long2bytes(v, buf, offset);
        }

        public static int bytes2int(byte[] buf, int offset) {
            return (buf[offset] << 24) + ((0xFF & buf[offset + 1]) << 16) + ((0xFF & buf[offset + 2]) << 8) + (0xFF & buf[offset + 3]);
        }

        public static long bytes2long(byte[] buf, int offset) {
            return ((long)Utils.bytes2int(buf, offset) << 32) + (0xFFFFFFFFL & (long)Utils.bytes2int(buf, offset + 4));
        }

        public static double bytes2double(byte[] buf, int offset) {
            long v = Utils.bytes2long(buf, offset);
            return Double.longBitsToDouble(v);
        }
    }

    public static enum Type {
        NULL,
        VARIABLE,
        DOUBLE,
        BINARY,
        UNARY;

        private static final Type[] VALUES;

        byte byteValue() {
            return (byte)this.ordinal();
        }

        static Type valueOf(byte b) {
            Preconditions.assertTrue(b >= 0);
            Preconditions.assertTrue(b < VALUES.length);
            return VALUES[b];
        }

        static {
            VALUES = Type.values();
        }
    }
}

