/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.examples.arithmetic.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.File;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.examples.arithmetic.ArithmeticStateMachine;
import org.apache.ratis.examples.common.SubCommandBase;
import org.apache.ratis.grpc.GrpcConfigKeys;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.util.LifeCycle;
import org.apache.ratis.util.NetUtils;

@Parameters(commandDescription="Start an arithmetic server")
public class Server
extends SubCommandBase {
    @Parameter(names={"--id", "-i"}, description="Raft id of this server", required=true)
    private String id;
    @Parameter(names={"--storage", "-s"}, description="Storage dir", required=true)
    private File storageDir;

    @Override
    public void run() throws Exception {
        RaftPeerId peerId = RaftPeerId.valueOf(this.id);
        RaftProperties properties = new RaftProperties();
        int port = NetUtils.createSocketAddr(this.getPeer(peerId).getAddress()).getPort();
        GrpcConfigKeys.Server.setPort(properties, port);
        properties.setInt("raft.grpc.outputstream.retry.times", Integer.MAX_VALUE);
        RaftServerConfigKeys.setStorageDirs(properties, Collections.singletonList(this.storageDir));
        ArithmeticStateMachine stateMachine = new ArithmeticStateMachine();
        RaftGroup raftGroup = RaftGroup.valueOf(RaftGroupId.valueOf(ByteString.copyFromUtf8(this.getRaftGroupId())), this.getPeers());
        RaftServer raftServer = RaftServer.newBuilder().setServerId(RaftPeerId.valueOf(this.id)).setStateMachine(stateMachine).setProperties(properties).setGroup(raftGroup).build();
        raftServer.start();
        while (raftServer.getLifeCycleState() != LifeCycle.State.CLOSED) {
            TimeUnit.SECONDS.sleep(1L);
        }
    }
}

