/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.raftlog.segmented;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.ratis.server.raftlog.segmented.BufferedChannelBase;

public class BufferedWriteChannel
extends BufferedChannelBase {
    private final ByteBuffer writeBuffer;
    private volatile long position;
    private boolean flushed = true;

    public BufferedWriteChannel(FileChannel fc, ByteBuffer byteBuffer) throws IOException {
        super(fc);
        this.position = fc.position();
        this.writeBuffer = byteBuffer;
    }

    public void write(int b) throws IOException {
        this.writeBuffer.put((byte)b);
        if (this.writeBuffer.remaining() == 0) {
            this.flushInternal();
        }
        this.flushed = false;
        ++this.position;
    }

    public void write(byte[] b) throws IOException {
        int toPut;
        for (int offset = 0; offset < b.length; offset += toPut) {
            toPut = Math.min(b.length - offset, this.writeBuffer.remaining());
            this.writeBuffer.put(b, offset, toPut);
            if (this.writeBuffer.remaining() != 0) continue;
            this.flushInternal();
        }
        this.flushed = false;
        this.position += (long)b.length;
    }

    public long position() {
        return this.position;
    }

    void flush() throws IOException {
        if (this.flushed) {
            return;
        }
        this.flushInternal();
        this.fileChannel.force(false);
        this.flushed = true;
    }

    private void flushInternal() throws IOException {
        if (this.writeBuffer.position() == 0) {
            return;
        }
        this.writeBuffer.flip();
        do {
            this.fileChannel.write(this.writeBuffer);
        } while (this.writeBuffer.hasRemaining());
        this.writeBuffer.clear();
    }

    @Override
    public void close() throws IOException {
        this.fileChannel.close();
        this.writeBuffer.clear();
    }
}

