/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import com.codahale.metrics.Timer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.management.ObjectName;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.GroupInfoReply;
import org.apache.ratis.protocol.GroupInfoRequest;
import org.apache.ratis.protocol.GroupMismatchException;
import org.apache.ratis.protocol.LeaderNotReadyException;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.NotLeaderException;
import org.apache.ratis.protocol.RaftClientAsynchronousProtocol;
import org.apache.ratis.protocol.RaftClientProtocol;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftException;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.ReconfigurationInProgressException;
import org.apache.ratis.protocol.ServerNotReadyException;
import org.apache.ratis.protocol.SetConfigurationRequest;
import org.apache.ratis.protocol.StaleReadException;
import org.apache.ratis.protocol.StateMachineException;
import org.apache.ratis.protocol.exceptions.ResourceUnavailableException;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.RaftServerMXBean;
import org.apache.ratis.server.RaftServerRpc;
import org.apache.ratis.server.impl.CommitInfoCache;
import org.apache.ratis.server.impl.FollowerInfo;
import org.apache.ratis.server.impl.FollowerState;
import org.apache.ratis.server.impl.LeaderState;
import org.apache.ratis.server.impl.LogAppender;
import org.apache.ratis.server.impl.PendingRequest;
import org.apache.ratis.server.impl.PendingRequests;
import org.apache.ratis.server.impl.RaftConfiguration;
import org.apache.ratis.server.impl.RaftServerMetrics;
import org.apache.ratis.server.impl.RaftServerProxy;
import org.apache.ratis.server.impl.RetryCache;
import org.apache.ratis.server.impl.RoleInfo;
import org.apache.ratis.server.impl.ServerProtoUtils;
import org.apache.ratis.server.impl.ServerState;
import org.apache.ratis.server.metrics.LeaderElectionMetrics;
import org.apache.ratis.server.protocol.RaftServerAsynchronousProtocol;
import org.apache.ratis.server.protocol.RaftServerProtocol;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.server.raftlog.RaftLog;
import org.apache.ratis.server.storage.FileInfo;
import org.apache.ratis.server.storage.RaftStorageDirectory;
import org.apache.ratis.statemachine.SnapshotInfo;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.statemachine.TransactionContext;
import org.apache.ratis.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.util.CodeInjectionForTesting;
import org.apache.ratis.util.FileUtils;
import org.apache.ratis.util.IOUtils;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.JmxRegister;
import org.apache.ratis.util.LifeCycle;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.ProtoUtils;
import org.apache.ratis.util.TimeDuration;
import org.apache.ratis.util.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RaftServerImpl
implements RaftServerProtocol,
RaftServerAsynchronousProtocol,
RaftClientProtocol,
RaftClientAsynchronousProtocol {
    public static final Logger LOG = LoggerFactory.getLogger(RaftServerImpl.class);
    private static final String CLASS_NAME = RaftServerImpl.class.getSimpleName();
    static final String REQUEST_VOTE = CLASS_NAME + ".requestVote";
    static final String APPEND_ENTRIES = CLASS_NAME + ".appendEntries";
    static final String INSTALL_SNAPSHOT = CLASS_NAME + ".installSnapshot";
    private final RaftServerProxy proxy;
    private final StateMachine stateMachine;
    private final int minTimeoutMs;
    private final int maxTimeoutMs;
    private final int rpcSlownessTimeoutMs;
    private final int sleepDeviationThresholdMs;
    private final boolean installSnapshotEnabled;
    private final LifeCycle lifeCycle;
    private final ServerState state;
    private final Supplier<RaftPeer> peerSupplier = JavaUtils.memoize(() -> new RaftPeer(this.getId(), this.getServerRpc().getInetSocketAddress()));
    private final RoleInfo role;
    private final RetryCache retryCache;
    private final CommitInfoCache commitInfoCache = new CommitInfoCache();
    private final RaftServerJmxAdapter jmxAdapter;
    private final LeaderElectionMetrics leaderElectionMetrics;
    private final RaftServerMetrics raftServerMetrics;
    private AtomicReference<TermIndex> inProgressInstallSnapshotRequest;

    RaftServerImpl(RaftGroup group, StateMachine stateMachine, RaftServerProxy proxy) throws IOException {
        RaftPeerId id = proxy.getId();
        LOG.info("{}: new RaftServerImpl for {} with {}", new Object[]{id, group, stateMachine});
        this.lifeCycle = new LifeCycle((Object)id);
        this.stateMachine = stateMachine;
        this.role = new RoleInfo(id);
        RaftProperties properties = proxy.getProperties();
        this.minTimeoutMs = RaftServerConfigKeys.Rpc.timeoutMin(properties).toIntExact(TimeUnit.MILLISECONDS);
        this.maxTimeoutMs = RaftServerConfigKeys.Rpc.timeoutMax(properties).toIntExact(TimeUnit.MILLISECONDS);
        this.rpcSlownessTimeoutMs = RaftServerConfigKeys.Rpc.slownessTimeout(properties).toIntExact(TimeUnit.MILLISECONDS);
        this.sleepDeviationThresholdMs = RaftServerConfigKeys.sleepDeviationThreshold(properties);
        this.installSnapshotEnabled = RaftServerConfigKeys.Log.Appender.installSnapshotEnabled(properties);
        Preconditions.assertTrue((this.maxTimeoutMs > this.minTimeoutMs ? 1 : 0) != 0, (String)"max timeout: %s, min timeout: %s", (Object[])new Object[]{this.maxTimeoutMs, this.minTimeoutMs});
        this.proxy = proxy;
        this.state = new ServerState(id, group, properties, this, stateMachine);
        this.retryCache = this.initRetryCache(properties);
        this.inProgressInstallSnapshotRequest = new AtomicReference<Object>(null);
        this.jmxAdapter = new RaftServerJmxAdapter();
        this.leaderElectionMetrics = LeaderElectionMetrics.getLeaderElectionMetrics(this);
        this.raftServerMetrics = RaftServerMetrics.getRaftServerMetrics(this);
    }

    private RetryCache initRetryCache(RaftProperties prop) {
        TimeDuration expireTime = RaftServerConfigKeys.RetryCache.expiryTime(prop);
        return new RetryCache(expireTime);
    }

    LogAppender newLogAppender(LeaderState state, RaftPeer peer, Timestamp lastRpcTime, long nextIndex, boolean attendVote) {
        FollowerInfo f = new FollowerInfo(this.getMemberId(), peer, lastRpcTime, nextIndex, attendVote, this.rpcSlownessTimeoutMs);
        return this.getProxy().getFactory().newLogAppender(this, state, f);
    }

    RaftPeer getPeer() {
        return this.peerSupplier.get();
    }

    int getMinTimeoutMs() {
        return this.minTimeoutMs;
    }

    int getMaxTimeoutMs() {
        return this.maxTimeoutMs;
    }

    int getRandomTimeoutMs() {
        return this.minTimeoutMs + ThreadLocalRandom.current().nextInt(this.maxTimeoutMs - this.minTimeoutMs + 1);
    }

    int getSleepDeviationThresholdMs() {
        return this.sleepDeviationThresholdMs;
    }

    public StateMachine getStateMachine() {
        return this.stateMachine;
    }

    @VisibleForTesting
    public RetryCache getRetryCache() {
        return this.retryCache;
    }

    public RaftServerProxy getProxy() {
        return this.proxy;
    }

    public RaftServerRpc getServerRpc() {
        return this.proxy.getServerRpc();
    }

    private void setRole(RaftProtos.RaftPeerRole newRole, Object reason) {
        LOG.info("{}: changes role from {} to {} at term {} for {}", new Object[]{this.getMemberId(), this.role, newRole, this.state.getCurrentTerm(), reason});
        this.role.transitionRole(newRole);
    }

    boolean start() {
        if (!this.lifeCycle.compareAndTransition(LifeCycle.State.NEW, LifeCycle.State.STARTING)) {
            return false;
        }
        RaftConfiguration conf = this.getRaftConf();
        if (conf != null && conf.contains(this.getId())) {
            LOG.info("{}: start as a follower, conf={}", (Object)this.getMemberId(), (Object)conf);
            this.startAsFollower();
        } else {
            LOG.info("{}: start with initializing state, conf={}", (Object)this.getMemberId(), (Object)conf);
            this.startInitializing();
        }
        RaftServerImpl.registerMBean(this.getId(), this.getMemberId().getGroupId(), this.jmxAdapter, this.jmxAdapter);
        this.state.start();
        return true;
    }

    static boolean registerMBean(RaftPeerId id, RaftGroupId groupdId, RaftServerMXBean mBean, JmxRegister jmx) {
        String prefix = "Ratis:service=RaftServer,group=" + groupdId + ",id=";
        String registered = jmx.register((Object)mBean, Arrays.asList(() -> prefix + id, () -> prefix + ObjectName.quote(id.toString())));
        return registered != null;
    }

    private void startAsFollower() {
        this.setRole(RaftProtos.RaftPeerRole.FOLLOWER, "startAsFollower");
        this.role.startFollowerState(this);
        this.lifeCycle.transition(LifeCycle.State.RUNNING);
    }

    private void startInitializing() {
        this.setRole(RaftProtos.RaftPeerRole.FOLLOWER, "startInitializing");
    }

    public ServerState getState() {
        return this.state;
    }

    public RaftGroupMemberId getMemberId() {
        return this.getState().getMemberId();
    }

    public RaftPeerId getId() {
        return this.getMemberId().getPeerId();
    }

    RoleInfo getRole() {
        return this.role;
    }

    RaftConfiguration getRaftConf() {
        return this.getState().getRaftConf();
    }

    RaftGroup getGroup() {
        return RaftGroup.valueOf((RaftGroupId)this.getMemberId().getGroupId(), this.getRaftConf().getPeers());
    }

    public void shutdown(boolean deleteDirectory) {
        this.lifeCycle.checkStateAndClose(() -> {
            LOG.info("{}: shutdown", (Object)this.getMemberId());
            try {
                this.jmxAdapter.unregister();
            }
            catch (Exception ignored) {
                LOG.warn("{}: Failed to un-register RaftServer JMX bean", (Object)this.getMemberId(), (Object)ignored);
            }
            try {
                this.role.shutdownFollowerState();
            }
            catch (Exception ignored) {
                LOG.warn("{}: Failed to shutdown FollowerState", (Object)this.getMemberId(), (Object)ignored);
            }
            try {
                this.role.shutdownLeaderElection();
            }
            catch (Exception ignored) {
                LOG.warn("{}: Failed to shutdown LeaderElection", (Object)this.getMemberId(), (Object)ignored);
            }
            try {
                this.role.shutdownLeaderState(true);
            }
            catch (Exception ignored) {
                LOG.warn("{}: Failed to shutdown LeaderState monitor", (Object)this.getMemberId(), (Object)ignored);
            }
            try {
                this.state.close();
            }
            catch (Exception ignored) {
                LOG.warn("{}: Failed to close state", (Object)this.getMemberId(), (Object)ignored);
            }
            this.leaderElectionMetrics.unregister();
            this.raftServerMetrics.unregister();
            if (deleteDirectory) {
                RaftStorageDirectory dir = this.state.getStorage().getStorageDir();
                try {
                    FileUtils.deleteFully((File)dir.getRoot());
                }
                catch (Exception ignored) {
                    LOG.warn("{}: Failed to remove RaftStorageDirectory {}", new Object[]{this.getMemberId(), dir, ignored});
                }
            }
        });
    }

    public boolean isAlive() {
        return !this.lifeCycle.getCurrentState().isClosingOrClosed();
    }

    public boolean isFollower() {
        return this.role.isFollower();
    }

    public boolean isCandidate() {
        return this.role.isCandidate();
    }

    public boolean isLeader() {
        return this.role.isLeader();
    }

    public CommitInfoCache getCommitInfoCache() {
        return this.commitInfoCache;
    }

    private synchronized boolean changeToFollower(long newTerm, boolean force, Object reason) {
        RaftProtos.RaftPeerRole old = this.role.getCurrentRole();
        boolean metadataUpdated = this.state.updateCurrentTerm(newTerm);
        if (old != RaftProtos.RaftPeerRole.FOLLOWER || force) {
            this.setRole(RaftProtos.RaftPeerRole.FOLLOWER, reason);
            if (old == RaftProtos.RaftPeerRole.LEADER) {
                this.role.shutdownLeaderState(false);
            } else if (old == RaftProtos.RaftPeerRole.CANDIDATE) {
                this.role.shutdownLeaderElection();
            } else if (old == RaftProtos.RaftPeerRole.FOLLOWER) {
                this.role.shutdownFollowerState();
            }
            this.role.startFollowerState(this);
        }
        return metadataUpdated;
    }

    synchronized void changeToFollowerAndPersistMetadata(long newTerm, Object reason) throws IOException {
        if (this.changeToFollower(newTerm, false, reason)) {
            this.state.persistMetadata();
        }
    }

    synchronized void changeToLeader() {
        Preconditions.assertTrue((boolean)this.isCandidate());
        this.role.shutdownLeaderElection();
        this.setRole(RaftProtos.RaftPeerRole.LEADER, "changeToLeader");
        this.state.becomeLeader();
        RaftProtos.LogEntryProto e = this.role.startLeaderState(this, this.getProxy().getProperties());
        this.getState().setRaftConf(e);
    }

    Collection<RaftProtos.CommitInfoProto> getCommitInfos() {
        ArrayList<RaftProtos.CommitInfoProto> infos = new ArrayList<RaftProtos.CommitInfoProto>();
        infos.add(this.commitInfoCache.update(this.getPeer(), this.state.getLog().getLastCommittedIndex()));
        if (this.isLeader()) {
            this.role.getLeaderState().ifPresent(leader -> leader.updateFollowerCommitInfos(this.commitInfoCache, infos));
        } else {
            this.getRaftConf().getPeers().stream().map(RaftPeer::getId).filter(id -> !id.equals((Object)this.getId())).map(this.commitInfoCache::get).filter(Objects::nonNull).forEach(infos::add);
        }
        return infos;
    }

    GroupInfoReply getGroupInfo(GroupInfoRequest request) {
        return new GroupInfoReply((RaftClientRequest)request, this.getRoleInfoProto(), this.state.getStorage().getStorageDir().hasMetaFile(), this.getCommitInfos(), this.getGroup());
    }

    public RaftProtos.RoleInfoProto getRoleInfoProto() {
        RaftProtos.RaftPeerRole currentRole = this.role.getCurrentRole();
        RaftProtos.RoleInfoProto.Builder roleInfo = RaftProtos.RoleInfoProto.newBuilder().setSelf(this.getPeer().getRaftPeerProto()).setRole(currentRole).setRoleElapsedTimeMs(this.role.getRoleElapsedTimeMs());
        switch (currentRole) {
            case CANDIDATE: {
                RaftProtos.CandidateInfoProto.Builder candidate = RaftProtos.CandidateInfoProto.newBuilder().setLastLeaderElapsedTimeMs(this.state.getLastLeaderElapsedTimeMs());
                roleInfo.setCandidateInfo(candidate);
                break;
            }
            case FOLLOWER: {
                this.role.getFollowerState().ifPresent(fs -> {
                    RaftProtos.ServerRpcProto leaderInfo = ServerProtoUtils.toServerRpcProto(this.getRaftConf().getPeer(this.state.getLeaderId()), fs.getLastRpcTime().elapsedTimeMs());
                    roleInfo.setFollowerInfo(RaftProtos.FollowerInfoProto.newBuilder().setLeaderInfo(leaderInfo).setOutstandingOp(fs.getOutstandingOp()));
                });
                break;
            }
            case LEADER: {
                this.role.getLeaderState().ifPresent(ls -> {
                    RaftProtos.LeaderInfoProto.Builder leader = RaftProtos.LeaderInfoProto.newBuilder();
                    ls.getLogAppenders().map(LogAppender::getFollower).forEach(f -> leader.addFollowerInfo(ServerProtoUtils.toServerRpcProto(f.getPeer(), f.getLastRpcResponseTime().elapsedTimeMs())));
                    roleInfo.setLeaderInfo(leader);
                });
                break;
            }
            default: {
                throw new IllegalStateException("incorrect role of server " + currentRole);
            }
        }
        return roleInfo.build();
    }

    synchronized void changeToCandidate() {
        Preconditions.assertTrue((boolean)this.isFollower());
        this.role.shutdownFollowerState();
        this.setRole(RaftProtos.RaftPeerRole.CANDIDATE, "changeToCandidate");
        if (this.state.shouldNotifyExtendedNoLeader()) {
            this.stateMachine.notifyExtendedNoLeader(this.getRoleInfoProto());
        }
        this.role.startLeaderElection(this);
        this.leaderElectionMetrics.onNewLeaderElection();
    }

    public String toString() {
        return this.role + " " + this.state + " " + this.lifeCycle.getCurrentState();
    }

    private CompletableFuture<RaftClientReply> checkLeaderState(RaftClientRequest request, RetryCache.CacheEntry entry) {
        try {
            this.assertGroup(request.getRequestorId(), request.getRaftGroupId());
        }
        catch (GroupMismatchException e) {
            return RetryCache.failWithException(e, entry);
        }
        if (!this.isLeader()) {
            NotLeaderException exception = this.generateNotLeaderException();
            RaftClientReply reply = new RaftClientReply(request, (RaftException)exception, this.getCommitInfos());
            return RetryCache.failWithReply(reply, entry);
        }
        LeaderState leaderState = this.role.getLeaderState().orElse(null);
        if (leaderState == null || !leaderState.isReady()) {
            RetryCache.CacheEntry cacheEntry = this.retryCache.get(request.getClientId(), request.getCallId());
            if (cacheEntry != null && cacheEntry.isCompletedNormally()) {
                return cacheEntry.getReplyFuture();
            }
            LeaderNotReadyException lnre = new LeaderNotReadyException(this.getMemberId());
            RaftClientReply reply = new RaftClientReply(request, (RaftException)lnre, this.getCommitInfos());
            return RetryCache.failWithReply(reply, entry);
        }
        return null;
    }

    NotLeaderException generateNotLeaderException() {
        if (this.lifeCycle.getCurrentState() != LifeCycle.State.RUNNING) {
            return new NotLeaderException(this.getMemberId(), null, null);
        }
        RaftPeerId leaderId = this.state.getLeaderId();
        if (leaderId == null || leaderId.equals((Object)this.getId())) {
            leaderId = null;
        }
        RaftConfiguration conf = this.getRaftConf();
        Collection<RaftPeer> peers = conf.getPeers();
        return new NotLeaderException(this.getMemberId(), conf.getPeer(leaderId), peers);
    }

    private LifeCycle.State assertLifeCycleState(Set<LifeCycle.State> expected) throws ServerNotReadyException {
        return this.lifeCycle.assertCurrentState((n, c) -> new ServerNotReadyException(this.getMemberId() + " is not in " + expected + ": current state is " + c), expected);
    }

    void assertGroup(Object requestorId, RaftGroupId requestorGroupId) throws GroupMismatchException {
        RaftGroupId groupId = this.getMemberId().getGroupId();
        if (!groupId.equals((Object)requestorGroupId)) {
            throw new GroupMismatchException(this.getMemberId() + ": The group (" + requestorGroupId + ") of " + requestorId + " does not match the group (" + groupId + ") of the server " + this.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<RaftClientReply> appendTransaction(RaftClientRequest request, TransactionContext context, RetryCache.CacheEntry cacheEntry) throws IOException {
        PendingRequest pending;
        this.assertLifeCycleState(LifeCycle.States.RUNNING);
        RaftServerImpl raftServerImpl = this;
        synchronized (raftServerImpl) {
            CompletableFuture<RaftClientReply> reply = this.checkLeaderState(request, cacheEntry);
            if (reply != null) {
                return reply;
            }
            LeaderState leaderState = this.role.getLeaderStateNonNull();
            PendingRequests.Permit permit = leaderState.tryAcquirePendingRequest(request.getMessage());
            if (permit == null) {
                cacheEntry.failWithException((Throwable)new ResourceUnavailableException(this.getMemberId() + ": Failed to acquire a pending write request for " + request));
                return cacheEntry.getReplyFuture();
            }
            try {
                this.state.appendLog(context);
            }
            catch (StateMachineException e) {
                RaftClientReply exceptionReply = new RaftClientReply(request, (RaftException)e, this.getCommitInfos());
                cacheEntry.failWithReply(exceptionReply);
                if (this.isLeader()) {
                    leaderState.submitStepDownEvent();
                }
                return CompletableFuture.completedFuture(exceptionReply);
            }
            pending = leaderState.addPendingRequest(permit, request, context);
            if (pending == null) {
                cacheEntry.failWithException((Throwable)new ResourceUnavailableException(this.getMemberId() + ": Failed to add a pending write request for " + request));
                return cacheEntry.getReplyFuture();
            }
            leaderState.notifySenders();
        }
        return pending.getFuture();
    }

    public CompletableFuture<RaftClientReply> submitClientRequestAsync(RaftClientRequest request) throws IOException {
        CompletableFuture<RaftClientReply> replyFuture;
        Timer.Context timerContext;
        this.assertLifeCycleState(LifeCycle.States.RUNNING);
        LOG.debug("{}: receive client request({})", (Object)this.getMemberId(), (Object)request);
        Timer timer = this.raftServerMetrics.getClientRequestTimer(request);
        Timer.Context context = timerContext = timer != null ? timer.time() : null;
        if (request.is(RaftProtos.RaftClientRequestProto.TypeCase.STALEREAD)) {
            replyFuture = this.staleReadAsync(request);
        } else {
            CompletableFuture<RaftClientReply> reply = this.checkLeaderState(request, null);
            if (reply != null) {
                return reply;
            }
            StateMachine stateMachine = this.getStateMachine();
            if (request.is(RaftProtos.RaftClientRequestProto.TypeCase.READ)) {
                replyFuture = this.processQueryFuture(stateMachine.query(request.getMessage()), request);
            } else if (request.is(RaftProtos.RaftClientRequestProto.TypeCase.WATCH)) {
                replyFuture = this.watchAsync(request);
            } else {
                RetryCache.CacheQueryResult previousResult = this.retryCache.queryCache(request.getClientId(), request.getCallId());
                if (previousResult.isRetry()) {
                    this.raftServerMetrics.onRetryRequestCacheHit();
                    replyFuture = previousResult.getEntry().getReplyFuture();
                } else {
                    RetryCache.CacheEntry cacheEntry = previousResult.getEntry();
                    TransactionContext context2 = stateMachine.startTransaction(request);
                    if (context2.getException() != null) {
                        RaftClientReply exceptionReply = new RaftClientReply(request, (RaftException)new StateMachineException(this.getMemberId(), (Throwable)context2.getException()), this.getCommitInfos());
                        cacheEntry.failWithReply(exceptionReply);
                        replyFuture = CompletableFuture.completedFuture(exceptionReply);
                    } else {
                        replyFuture = this.appendTransaction(request, context2, cacheEntry);
                    }
                }
            }
        }
        replyFuture.whenComplete((clientReply, exception) -> {
            if (clientReply.isSuccess() && timerContext != null) {
                timerContext.stop();
            }
        });
        return replyFuture;
    }

    private CompletableFuture<RaftClientReply> watchAsync(RaftClientRequest request) {
        return this.role.getLeaderState().map(ls -> ls.addWatchReqeust(request)).orElseGet(() -> CompletableFuture.completedFuture(new RaftClientReply(request, (RaftException)this.generateNotLeaderException(), this.getCommitInfos())));
    }

    private CompletableFuture<RaftClientReply> staleReadAsync(RaftClientRequest request) {
        long minIndex = request.getType().getStaleRead().getMinIndex();
        long commitIndex = this.state.getLog().getLastCommittedIndex();
        LOG.debug("{}: minIndex={}, commitIndex={}", new Object[]{this.getMemberId(), minIndex, commitIndex});
        if (commitIndex < minIndex) {
            StaleReadException e = new StaleReadException("Unable to serve stale-read due to server commit index = " + commitIndex + " < min = " + minIndex);
            return CompletableFuture.completedFuture(new RaftClientReply(request, (RaftException)new StateMachineException(this.getMemberId(), (Throwable)e), this.getCommitInfos()));
        }
        return this.processQueryFuture(this.getStateMachine().queryStale(request.getMessage(), minIndex), request);
    }

    CompletableFuture<RaftClientReply> processQueryFuture(CompletableFuture<Message> queryFuture, RaftClientRequest request) {
        return ((CompletableFuture)queryFuture.thenApply(r -> new RaftClientReply(request, r, this.getCommitInfos()))).exceptionally(e -> {
            if ((e = JavaUtils.unwrapCompletionException((Throwable)e)) instanceof StateMachineException) {
                return new RaftClientReply(request, (RaftException)((StateMachineException)((Object)e)), this.getCommitInfos());
            }
            throw new CompletionException((Throwable)e);
        });
    }

    public RaftClientReply submitClientRequest(RaftClientRequest request) throws IOException {
        return this.waitForReply(request, this.submitClientRequestAsync(request));
    }

    RaftClientReply waitForReply(RaftClientRequest request, CompletableFuture<RaftClientReply> future) throws IOException {
        return RaftServerImpl.waitForReply(this.getMemberId(), request, future, e -> new RaftClientReply(request, e, this.getCommitInfos()));
    }

    static <REPLY extends RaftClientReply> REPLY waitForReply(Object id, RaftClientRequest request, CompletableFuture<REPLY> future, Function<RaftException, REPLY> exceptionReply) throws IOException {
        try {
            return (REPLY)((RaftClientReply)future.get());
        }
        catch (InterruptedException e) {
            String s = id + ": Interrupted when waiting for reply, request=" + request;
            LOG.info(s, (Throwable)e);
            throw IOUtils.toInterruptedIOException((String)s, (InterruptedException)e);
        }
        catch (ExecutionException e) {
            RaftClientReply reply;
            Throwable cause = e.getCause();
            if (cause == null) {
                throw new IOException(e);
            }
            if ((cause instanceof NotLeaderException || cause instanceof StateMachineException) && (reply = (RaftClientReply)exceptionReply.apply((RaftException)cause)) != null) {
                return (REPLY)reply;
            }
            throw IOUtils.asIOException((Throwable)cause);
        }
    }

    public RaftClientReply setConfiguration(SetConfigurationRequest request) throws IOException {
        return this.waitForReply((RaftClientRequest)request, this.setConfigurationAsync(request));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<RaftClientReply> setConfigurationAsync(SetConfigurationRequest request) throws IOException {
        PendingRequest pending;
        LOG.info("{}: receive setConfiguration {}", (Object)this.getMemberId(), (Object)request);
        this.assertLifeCycleState(LifeCycle.States.RUNNING);
        this.assertGroup(request.getRequestorId(), request.getRaftGroupId());
        CompletableFuture<RaftClientReply> reply = this.checkLeaderState((RaftClientRequest)request, null);
        if (reply != null) {
            return reply;
        }
        List peersInNewConf = request.getPeersInNewConf();
        RaftServerImpl raftServerImpl = this;
        synchronized (raftServerImpl) {
            reply = this.checkLeaderState((RaftClientRequest)request, null);
            if (reply != null) {
                return reply;
            }
            RaftConfiguration current = this.getRaftConf();
            LeaderState leaderState = this.role.getLeaderStateNonNull();
            if (!current.isStable() || leaderState.inStagingState() || !this.state.isConfCommitted()) {
                throw new ReconfigurationInProgressException("Reconfiguration is already in progress: " + current);
            }
            if (current.hasNoChange(peersInNewConf)) {
                PendingRequest pending2 = new PendingRequest(request);
                pending2.setReply(new RaftClientReply((RaftClientRequest)request, this.getCommitInfos()));
                return pending2.getFuture();
            }
            this.getServerRpc().addPeers(peersInNewConf);
            pending = leaderState.startSetConfiguration(request);
        }
        return pending.getFuture();
    }

    private boolean shouldWithholdVotes(long candidateTerm) {
        if (this.state.getCurrentTerm() < candidateTerm) {
            return false;
        }
        if (this.isLeader()) {
            return true;
        }
        return this.isFollower() && this.state.hasLeader() && this.role.getFollowerState().map(FollowerState::shouldWithholdVotes).orElse(false) != false;
    }

    private boolean shouldSendShutdown(RaftPeerId candidateId, TermIndex candidateLastEntry) {
        return this.isLeader() && this.getRaftConf().isStable() && this.getState().isConfCommitted() && !this.getRaftConf().containsInConf(candidateId) && candidateLastEntry.getIndex() < this.getRaftConf().getLogEntryIndex() && this.role.getLeaderState().map(ls -> !ls.isBootStrappingPeer(candidateId)).orElse(false) != false;
    }

    @Override
    public RaftProtos.RequestVoteReplyProto requestVote(RaftProtos.RequestVoteRequestProto r) throws IOException {
        RaftProtos.RaftRpcRequestProto request = r.getServerRequest();
        return this.requestVote(RaftPeerId.valueOf((ByteString)request.getRequestorId()), ProtoUtils.toRaftGroupId((RaftProtos.RaftGroupIdProto)request.getRaftGroupId()), r.getCandidateTerm(), ServerProtoUtils.toTermIndex(r.getCandidateLastEntry()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RaftProtos.RequestVoteReplyProto requestVote(RaftPeerId candidateId, RaftGroupId candidateGroupId, long candidateTerm, TermIndex candidateLastEntry) throws IOException {
        RaftProtos.RequestVoteReplyProto reply;
        CodeInjectionForTesting.execute((String)REQUEST_VOTE, (Object)this.getId(), (Object)candidateId, (Object[])new Object[]{candidateTerm, candidateLastEntry});
        LOG.debug("{}: receive requestVote({}, {}, {}, {})", new Object[]{this.getMemberId(), candidateId, candidateGroupId, candidateTerm, candidateLastEntry});
        this.assertLifeCycleState(LifeCycle.States.RUNNING);
        this.assertGroup(candidateId, candidateGroupId);
        boolean voteGranted = false;
        boolean shouldShutdown = false;
        RaftServerImpl raftServerImpl = this;
        synchronized (raftServerImpl) {
            FollowerState fs = this.role.getFollowerState().orElse(null);
            if (this.shouldWithholdVotes(candidateTerm)) {
                LOG.info("{}-{}: Withhold vote from candidate {} with term {}. State: leader={}, term={}, lastRpcElapsed={}", new Object[]{this.getMemberId(), this.role, candidateId, candidateTerm, this.state.getLeaderId(), this.state.getCurrentTerm(), fs != null ? fs.getLastRpcTime().elapsedTimeMs() + "ms" : null});
            } else if (this.state.recognizeCandidate(candidateId, candidateTerm)) {
                boolean termUpdated = this.changeToFollower(candidateTerm, true, "recognizeCandidate:" + candidateId);
                if (this.state.isLogUpToDate(candidateLastEntry) && fs != null) {
                    fs.updateLastRpcTime(FollowerState.UpdateType.REQUEST_VOTE);
                    this.state.grantVote(candidateId);
                    voteGranted = true;
                }
                if (termUpdated || voteGranted) {
                    this.state.persistMetadata();
                }
            }
            if (!voteGranted && this.shouldSendShutdown(candidateId, candidateLastEntry)) {
                shouldShutdown = true;
            }
            reply = ServerProtoUtils.toRequestVoteReplyProto(candidateId, this.getMemberId(), voteGranted, this.state.getCurrentTerm(), shouldShutdown);
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} replies to vote request: {}. Peer's state: {}", new Object[]{this.getMemberId(), ServerProtoUtils.toString(reply), this.state});
            }
        }
        return reply;
    }

    private void validateEntries(long expectedTerm, TermIndex previous, RaftProtos.LogEntryProto ... entries) {
        if (entries != null && entries.length > 0) {
            long index0 = entries[0].getIndex();
            if (previous == null || previous.getTerm() == 0L) {
                Preconditions.assertTrue((index0 == 0L ? 1 : 0) != 0, (String)"Unexpected Index: previous is null but entries[%s].getIndex()=%s", (Object[])new Object[]{0, index0});
            } else {
                Preconditions.assertTrue((previous.getIndex() == index0 - 1L ? 1 : 0) != 0, (String)"Unexpected Index: previous is %s but entries[%s].getIndex()=%s", (Object[])new Object[]{previous, 0, index0});
            }
            for (int i = 0; i < entries.length; ++i) {
                long t = entries[i].getTerm();
                Preconditions.assertTrue((expectedTerm >= t ? 1 : 0) != 0, (String)"Unexpected Term: entries[%s].getTerm()=%s but expectedTerm=%s", (Object[])new Object[]{i, t, expectedTerm});
                long indexi = entries[i].getIndex();
                Preconditions.assertTrue((indexi == index0 + (long)i ? 1 : 0) != 0, (String)"Unexpected Index: entries[%s].getIndex()=%s but entries[0].getIndex()=%s", (Object[])new Object[]{i, indexi, index0});
            }
        }
    }

    @Override
    public RaftProtos.AppendEntriesReplyProto appendEntries(RaftProtos.AppendEntriesRequestProto r) throws IOException {
        try {
            return this.appendEntriesAsync(r).join();
        }
        catch (CompletionException e) {
            throw IOUtils.asIOException((Throwable)JavaUtils.unwrapCompletionException((Throwable)e));
        }
    }

    @Override
    public CompletableFuture<RaftProtos.AppendEntriesReplyProto> appendEntriesAsync(RaftProtos.AppendEntriesRequestProto r) throws IOException {
        RaftProtos.RaftRpcRequestProto request = r.getServerRequest();
        RaftProtos.LogEntryProto[] entries = r.getEntriesList().toArray(new RaftProtos.LogEntryProto[r.getEntriesCount()]);
        TermIndex previous = r.hasPreviousLog() ? ServerProtoUtils.toTermIndex(r.getPreviousLog()) : null;
        RaftPeerId requestorId = RaftPeerId.valueOf((ByteString)request.getRequestorId());
        this.preAppendEntriesAsync(requestorId, ProtoUtils.toRaftGroupId((RaftProtos.RaftGroupIdProto)request.getRaftGroupId()), r.getLeaderTerm(), previous, r.getLeaderCommit(), r.getInitializing(), entries);
        try {
            return this.appendEntriesAsync(requestorId, r.getLeaderTerm(), previous, r.getLeaderCommit(), request.getCallId(), r.getInitializing(), r.getCommitInfosList(), entries);
        }
        catch (Throwable t) {
            LOG.error("{}: Failed appendEntriesAsync {}", new Object[]{this.getMemberId(), r, t});
            throw t;
        }
    }

    static void logAppendEntries(boolean isHeartbeat, Supplier<String> message) {
        if (isHeartbeat) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("HEARTBEAT: " + message.get());
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug(message.get());
        }
    }

    private Optional<FollowerState> updateLastRpcTime(FollowerState.UpdateType updateType) {
        Optional<FollowerState> fs = this.role.getFollowerState();
        if (fs.isPresent() && this.lifeCycle.getCurrentState() == LifeCycle.State.RUNNING) {
            fs.get().updateLastRpcTime(updateType);
            return fs;
        }
        return Optional.empty();
    }

    private void preAppendEntriesAsync(RaftPeerId leaderId, RaftGroupId leaderGroupId, long leaderTerm, TermIndex previous, long leaderCommit, boolean initializing, RaftProtos.LogEntryProto ... entries) throws IOException {
        CodeInjectionForTesting.execute((String)APPEND_ENTRIES, (Object)this.getId(), (Object)leaderId, (Object[])new Object[]{leaderTerm, previous, leaderCommit, initializing, entries});
        LifeCycle.State currentState = this.assertLifeCycleState(LifeCycle.States.STARTING_OR_RUNNING);
        if (currentState == LifeCycle.State.STARTING && this.role.getCurrentRole() == null) {
            throw new ServerNotReadyException(this.getMemberId() + ": The server role is not yet initialized.");
        }
        this.assertGroup(leaderId, leaderGroupId);
        try {
            this.validateEntries(leaderTerm, previous, entries);
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<RaftProtos.AppendEntriesReplyProto> appendEntriesAsync(RaftPeerId leaderId, long leaderTerm, TermIndex previous, long leaderCommit, long callId, boolean initializing, List<RaftProtos.CommitInfoProto> commitInfos, RaftProtos.LogEntryProto ... entries) {
        Optional<FollowerState> followerState;
        long currentTerm;
        boolean isHeartbeat = entries.length == 0;
        RaftServerImpl.logAppendEntries(isHeartbeat, () -> this.getMemberId() + ": receive appendEntries(" + leaderId + ", " + leaderTerm + ", " + previous + ", " + leaderCommit + ", " + initializing + ", commits" + ProtoUtils.toString((Collection)commitInfos) + ", entries: " + ServerProtoUtils.toString(entries));
        long followerCommit = this.state.getLog().getLastCommittedIndex();
        Timer.Context timer = this.raftServerMetrics.getFollowerAppendEntryTimer().time();
        RaftServerImpl raftServerImpl = this;
        synchronized (raftServerImpl) {
            boolean recognized = this.state.recognizeLeader(leaderId, leaderTerm);
            currentTerm = this.state.getCurrentTerm();
            if (!recognized) {
                RaftProtos.AppendEntriesReplyProto reply = ServerProtoUtils.toAppendEntriesReplyProto(leaderId, this.getMemberId(), currentTerm, followerCommit, this.state.getNextIndex(), RaftProtos.AppendEntriesReplyProto.AppendResult.NOT_LEADER, callId, -1L, isHeartbeat);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{}: Not recognize {} (term={}) as leader, state: {} reply: {}", new Object[]{this.getMemberId(), leaderId, leaderTerm, this.state, ServerProtoUtils.toString(reply)});
                }
                return CompletableFuture.completedFuture(reply);
            }
            try {
                this.changeToFollowerAndPersistMetadata(leaderTerm, "appendEntries");
            }
            catch (IOException e) {
                return JavaUtils.completeExceptionally((Throwable)e);
            }
            this.state.setLeader(leaderId, "appendEntries");
            if (!initializing && this.lifeCycle.compareAndTransition(LifeCycle.State.STARTING, LifeCycle.State.RUNNING)) {
                this.role.startFollowerState(this);
            }
            followerState = this.updateLastRpcTime(FollowerState.UpdateType.APPEND_START);
            RaftProtos.AppendEntriesReplyProto inconsistencyReply = this.checkInconsistentAppendEntries(leaderId, currentTerm, followerCommit, previous, callId, isHeartbeat, entries);
            if (inconsistencyReply != null) {
                followerState.ifPresent(fs -> fs.updateLastRpcTime(FollowerState.UpdateType.APPEND_COMPLETE));
                return CompletableFuture.completedFuture(inconsistencyReply);
            }
            this.state.updateConfiguration(entries);
        }
        List futures = entries.length == 0 ? Collections.emptyList() : this.state.getLog().append(entries);
        commitInfos.forEach(this.commitInfoCache::update);
        if (!isHeartbeat) {
            CodeInjectionForTesting.execute((String)RaftLog.LOG_SYNC, (Object)this.getId(), null, (Object[])new Object[0]);
        }
        return ((CompletableFuture)JavaUtils.allOf(futures).whenCompleteAsync((r, t) -> followerState.ifPresent(fs -> fs.updateLastRpcTime(FollowerState.UpdateType.APPEND_COMPLETE)))).thenApply(v -> {
            RaftProtos.AppendEntriesReplyProto reply;
            RaftServerImpl raftServerImpl = this;
            synchronized (raftServerImpl) {
                this.state.updateStatemachine(leaderCommit, currentTerm);
                long n = isHeartbeat ? this.state.getLog().getNextIndex() : entries[entries.length - 1].getIndex() + 1L;
                long matchIndex = entries.length != 0 ? entries[entries.length - 1].getIndex() : -1L;
                reply = ServerProtoUtils.toAppendEntriesReplyProto(leaderId, this.getMemberId(), currentTerm, this.state.getLog().getLastCommittedIndex(), n, RaftProtos.AppendEntriesReplyProto.AppendResult.SUCCESS, callId, matchIndex, isHeartbeat);
            }
            RaftServerImpl.logAppendEntries(isHeartbeat, () -> this.getMemberId() + ": succeeded to handle AppendEntries. Reply: " + ServerProtoUtils.toString(reply));
            timer.stop();
            return reply;
        });
    }

    private RaftProtos.AppendEntriesReplyProto checkInconsistentAppendEntries(RaftPeerId leaderId, long currentTerm, long followerCommit, TermIndex previous, long callId, boolean isHeartbeat, RaftProtos.LogEntryProto ... entries) {
        long replyNextIndex = this.checkInconsistentAppendEntries(previous, entries);
        if (replyNextIndex == -1L) {
            return null;
        }
        RaftProtos.AppendEntriesReplyProto reply = ServerProtoUtils.toAppendEntriesReplyProto(leaderId, this.getMemberId(), currentTerm, followerCommit, replyNextIndex, RaftProtos.AppendEntriesReplyProto.AppendResult.INCONSISTENCY, callId, -1L, isHeartbeat);
        LOG.info("{}: inconsistency entries. Reply:{}", (Object)this.getMemberId(), (Object)ServerProtoUtils.toString(reply));
        return reply;
    }

    private long checkInconsistentAppendEntries(TermIndex previous, RaftProtos.LogEntryProto ... entries) {
        TermIndex installSnapshot = this.inProgressInstallSnapshotRequest.get();
        if (installSnapshot != null) {
            LOG.info("{}: Failed appendEntries as snapshot ({}) installation is in progress", (Object)this.getMemberId(), (Object)installSnapshot);
            return installSnapshot.getIndex();
        }
        if (entries != null && entries.length > 0) {
            long firstEntryIndex = entries[0].getIndex();
            long snapshotIndex = this.state.getSnapshotIndex();
            if (snapshotIndex > 0L && snapshotIndex >= firstEntryIndex) {
                LOG.info("{}: Failed appendEntries as latest snapshot ({}) already has the append entries (first index: {})", new Object[]{this.getMemberId(), snapshotIndex, firstEntryIndex});
                return snapshotIndex + 1L;
            }
        }
        if (previous != null && !this.state.containsTermIndex(previous)) {
            long replyNextIndex = Math.min(this.state.getNextIndex(), previous.getIndex());
            LOG.info("{}: Failed appendEntries as previous log entry ({}) is not found", (Object)this.getMemberId(), (Object)previous);
            return replyNextIndex;
        }
        return -1L;
    }

    @Override
    public RaftProtos.InstallSnapshotReplyProto installSnapshot(RaftProtos.InstallSnapshotRequestProto request) throws IOException {
        RaftProtos.InstallSnapshotReplyProto reply;
        if (LOG.isInfoEnabled()) {
            LOG.info("{}: receive installSnapshot: {}", (Object)this.getMemberId(), (Object)ServerProtoUtils.toString(request));
        }
        try {
            reply = this.installSnapshotImpl(request);
        }
        catch (Throwable t) {
            LOG.error("{}: installSnapshot failed", (Object)this.getMemberId(), (Object)t);
            throw t;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("{}: reply installSnapshot: {}", (Object)this.getMemberId(), (Object)ServerProtoUtils.toString(reply));
        }
        return reply;
    }

    private RaftProtos.InstallSnapshotReplyProto installSnapshotImpl(RaftProtos.InstallSnapshotRequestProto request) throws IOException {
        RaftProtos.RaftRpcRequestProto r = request.getServerRequest();
        RaftPeerId leaderId = RaftPeerId.valueOf((ByteString)r.getRequestorId());
        RaftGroupId leaderGroupId = ProtoUtils.toRaftGroupId((RaftProtos.RaftGroupIdProto)r.getRaftGroupId());
        CodeInjectionForTesting.execute((String)INSTALL_SNAPSHOT, (Object)this.getId(), (Object)leaderId, (Object[])new Object[]{request});
        this.assertLifeCycleState(LifeCycle.States.STARTING_OR_RUNNING);
        this.assertGroup(leaderId, leaderGroupId);
        if (this.installSnapshotEnabled) {
            if (request.hasSnapshotChunk()) {
                return this.checkAndInstallSnapshot(request, leaderId);
            }
        } else if (request.hasNotification()) {
            return this.notifyStateMachineToInstallSnapshot(request, leaderId);
        }
        RaftProtos.InstallSnapshotReplyProto reply = ServerProtoUtils.toInstallSnapshotReplyProto(leaderId, this.getMemberId(), RaftProtos.InstallSnapshotResult.CONF_MISMATCH);
        LOG.error("{}: Configuration Mismatch ({}): Leader {} has it set to {} but follower {} has it set to {}", new Object[]{this.getMemberId(), "raft.server.log.appender.install.snapshot.enabled", leaderId, request.hasSnapshotChunk(), this.getId(), this.installSnapshotEnabled});
        return reply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RaftProtos.InstallSnapshotReplyProto checkAndInstallSnapshot(RaftProtos.InstallSnapshotRequestProto request, RaftPeerId leaderId) throws IOException {
        long currentTerm;
        long leaderTerm = request.getLeaderTerm();
        RaftProtos.InstallSnapshotRequestProto.SnapshotChunkProto snapshotChunkRequest = request.getSnapshotChunk();
        TermIndex lastTermIndex = ServerProtoUtils.toTermIndex(snapshotChunkRequest.getTermIndex());
        long lastIncludedIndex = lastTermIndex.getIndex();
        RaftServerImpl raftServerImpl = this;
        synchronized (raftServerImpl) {
            boolean recognized = this.state.recognizeLeader(leaderId, leaderTerm);
            currentTerm = this.state.getCurrentTerm();
            if (!recognized) {
                RaftProtos.InstallSnapshotReplyProto reply = ServerProtoUtils.toInstallSnapshotReplyProto(leaderId, this.getMemberId(), currentTerm, snapshotChunkRequest.getRequestIndex(), RaftProtos.InstallSnapshotResult.NOT_LEADER);
                LOG.warn("{}: Failed to recognize leader for installSnapshot chunk.", (Object)this.getMemberId());
                return reply;
            }
            this.changeToFollowerAndPersistMetadata(leaderTerm, "installSnapshot");
            this.state.setLeader(leaderId, "installSnapshot");
            this.updateLastRpcTime(FollowerState.UpdateType.INSTALL_SNAPSHOT_START);
            try {
                Preconditions.assertTrue((this.state.getLog().getNextIndex() <= lastIncludedIndex ? 1 : 0) != 0, (String)"%s log's next id is %s, last included index in snapshot is %s", (Object[])new Object[]{this.getMemberId(), this.state.getLog().getNextIndex(), lastIncludedIndex});
                this.state.installSnapshot(request);
                if (snapshotChunkRequest.getDone()) {
                    this.state.reloadStateMachine(lastIncludedIndex, leaderTerm);
                }
            }
            finally {
                this.updateLastRpcTime(FollowerState.UpdateType.INSTALL_SNAPSHOT_COMPLETE);
            }
        }
        if (snapshotChunkRequest.getDone()) {
            LOG.info("{}: successfully install the entire snapshot-{}", (Object)this.getMemberId(), (Object)lastIncludedIndex);
        }
        return ServerProtoUtils.toInstallSnapshotReplyProto(leaderId, this.getMemberId(), currentTerm, snapshotChunkRequest.getRequestIndex(), RaftProtos.InstallSnapshotResult.SUCCESS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RaftProtos.InstallSnapshotReplyProto notifyStateMachineToInstallSnapshot(RaftProtos.InstallSnapshotRequestProto request, RaftPeerId leaderId) throws IOException {
        long leaderTerm = request.getLeaderTerm();
        TermIndex firstAvailableLogTermIndex = ServerProtoUtils.toTermIndex(request.getNotification().getFirstAvailableTermIndex());
        long firstAvailableLogIndex = firstAvailableLogTermIndex.getIndex();
        RaftServerImpl raftServerImpl = this;
        synchronized (raftServerImpl) {
            boolean recognized = this.state.recognizeLeader(leaderId, leaderTerm);
            long currentTerm = this.state.getCurrentTerm();
            if (!recognized) {
                RaftProtos.InstallSnapshotReplyProto reply2 = ServerProtoUtils.toInstallSnapshotReplyProto(leaderId, this.getMemberId(), currentTerm, RaftProtos.InstallSnapshotResult.NOT_LEADER, -1L);
                LOG.warn("{}: Failed to recognize leader for installSnapshot notification.", (Object)this.getMemberId());
                return reply2;
            }
            this.changeToFollowerAndPersistMetadata(leaderTerm, "installSnapshot");
            this.state.setLeader(leaderId, "installSnapshot");
            this.updateLastRpcTime(FollowerState.UpdateType.INSTALL_SNAPSHOT_NOTIFICATION);
            if (this.inProgressInstallSnapshotRequest.compareAndSet(null, firstAvailableLogTermIndex)) {
                long snapshotIndex = this.state.getSnapshotIndex();
                if (snapshotIndex + 1L >= firstAvailableLogIndex) {
                    this.inProgressInstallSnapshotRequest.compareAndSet(firstAvailableLogTermIndex, null);
                    RaftProtos.InstallSnapshotReplyProto reply3 = ServerProtoUtils.toInstallSnapshotReplyProto(leaderId, this.getMemberId(), currentTerm, RaftProtos.InstallSnapshotResult.ALREADY_INSTALLED, snapshotIndex);
                    LOG.info("{}: StateMachine snapshotIndex is {}", (Object)this.getMemberId(), (Object)snapshotIndex);
                    return reply3;
                }
                LOG.info("{}: notifyInstallSnapshot: nextIndex is {} but the leader's first available index is {}.", new Object[]{this.getMemberId(), this.state.getLog().getNextIndex(), firstAvailableLogIndex});
                this.stateMachine.notifyInstallSnapshotFromLeader(this.getRoleInfoProto(), firstAvailableLogTermIndex).whenComplete((reply, exception) -> {
                    if (exception != null) {
                        LOG.error("{}: State Machine failed to install snapshot", (Object)this.getMemberId(), exception);
                        this.inProgressInstallSnapshotRequest.compareAndSet(firstAvailableLogTermIndex, null);
                        return;
                    }
                    if (reply != null) {
                        this.stateMachine.pause();
                        this.state.reloadStateMachine(reply.getIndex(), leaderTerm);
                        this.state.updateInstalledSnapshotIndex((TermIndex)reply);
                    }
                    this.inProgressInstallSnapshotRequest.compareAndSet(firstAvailableLogTermIndex, null);
                });
                return ServerProtoUtils.toInstallSnapshotReplyProto(leaderId, this.getMemberId(), currentTerm, RaftProtos.InstallSnapshotResult.SUCCESS, -1L);
            }
            LOG.info("{}: StateMachine installSnapshot is in progress: {}", (Object)this.getMemberId(), (Object)this.inProgressInstallSnapshotRequest.get());
            return ServerProtoUtils.toInstallSnapshotReplyProto(leaderId, this.getMemberId(), currentTerm, RaftProtos.InstallSnapshotResult.IN_PROGRESS, -1L);
        }
    }

    synchronized RaftProtos.InstallSnapshotRequestProto createInstallSnapshotRequest(RaftPeerId targetId, String requestId, int requestIndex, SnapshotInfo snapshot, List<RaftProtos.FileChunkProto> chunks, boolean done) {
        OptionalLong totalSize = snapshot.getFiles().stream().mapToLong(FileInfo::getFileSize).reduce(Long::sum);
        assert (totalSize.isPresent());
        return ServerProtoUtils.toInstallSnapshotRequestProto(this.getMemberId(), targetId, requestId, requestIndex, this.state.getCurrentTerm(), snapshot.getTermIndex(), chunks, totalSize.getAsLong(), done);
    }

    synchronized RaftProtos.InstallSnapshotRequestProto createInstallSnapshotRequest(RaftPeerId targetId, TermIndex firstAvailableLogTermIndex) {
        assert (firstAvailableLogTermIndex.getIndex() > 0L);
        return ServerProtoUtils.toInstallSnapshotRequestProto(this.getMemberId(), targetId, this.state.getCurrentTerm(), firstAvailableLogTermIndex);
    }

    synchronized RaftProtos.RequestVoteRequestProto createRequestVoteRequest(RaftPeerId targetId, long term, TermIndex lastEntry) {
        return ServerProtoUtils.toRequestVoteRequestProto(this.getMemberId(), targetId, term, lastEntry);
    }

    public void submitUpdateCommitEvent() {
        this.role.getLeaderState().ifPresent(LeaderState::submitUpdateCommitEvent);
    }

    private CompletableFuture<Message> replyPendingRequest(RaftProtos.LogEntryProto logEntry, CompletableFuture<Message> stateMachineFuture) {
        Preconditions.assertTrue((boolean)logEntry.hasStateMachineLogEntry());
        RaftProtos.StateMachineLogEntryProto smLog = logEntry.getStateMachineLogEntry();
        ClientId clientId = ClientId.valueOf((ByteString)smLog.getClientId());
        long callId = smLog.getCallId();
        RetryCache.CacheEntry cacheEntry = this.retryCache.getOrCreateEntry(clientId, callId);
        if (this.isLeader()) {
            Preconditions.assertTrue((cacheEntry != null && !cacheEntry.isCompletedNormally() ? 1 : 0) != 0, (String)"retry cache entry should be pending: %s", (Object[])new Object[]{cacheEntry});
        }
        if (cacheEntry.isFailed()) {
            this.retryCache.refreshEntry(new RetryCache.CacheEntry(cacheEntry.getKey()));
        }
        long logIndex = logEntry.getIndex();
        return stateMachineFuture.whenComplete((reply, exception) -> {
            RaftClientReply r;
            if (exception == null) {
                r = new RaftClientReply(clientId, this.getMemberId(), callId, true, reply, null, logIndex, this.getCommitInfos());
            } else {
                StateMachineException e = new StateMachineException(this.getMemberId(), exception);
                r = new RaftClientReply(clientId, this.getMemberId(), callId, false, null, (RaftException)e, logIndex, this.getCommitInfos());
            }
            RaftServerImpl raftServerImpl = this;
            synchronized (raftServerImpl) {
                LeaderState leaderState = this.role.getLeaderState().orElse(null);
                if (this.isLeader() && leaderState != null) {
                    leaderState.replyPendingRequest(logIndex, r);
                }
            }
            cacheEntry.updateResult(r);
        });
    }

    public long[] getFollowerNextIndices() {
        if (!this.isLeader()) {
            return null;
        }
        return this.role.getLeaderState().map(LeaderState::getFollowerNextIndices).orElse(null);
    }

    CompletableFuture<Message> applyLogToStateMachine(RaftProtos.LogEntryProto next) {
        StateMachine stateMachine = this.getStateMachine();
        if (!next.hasStateMachineLogEntry()) {
            stateMachine.notifyIndexUpdate(next.getTerm(), next.getIndex());
        }
        if (next.hasConfigurationEntry()) {
            this.state.writeRaftConfiguration(next);
        } else if (next.hasStateMachineLogEntry()) {
            TransactionContext trx = this.role.getLeaderState().map(leader -> leader.getTransactionContext(next.getIndex())).orElseGet(() -> TransactionContext.newBuilder().setServerRole(this.role.getCurrentRole()).setStateMachine(stateMachine).setLogEntry(next).build());
            trx = stateMachine.applyTransactionSerial(trx);
            try {
                CompletableFuture<Message> stateMachineFuture = stateMachine.applyTransaction(trx);
                return this.replyPendingRequest(next, stateMachineFuture);
            }
            catch (Throwable e) {
                LOG.error("{}: applyTransaction failed for index:{} proto:{}", new Object[]{this.getMemberId(), next.getIndex(), ServerProtoUtils.toString(next), e});
                throw e;
            }
        }
        return null;
    }

    public void notifyTruncatedLogEntry(RaftProtos.LogEntryProto logEntry) {
        if (logEntry.hasStateMachineLogEntry()) {
            RaftProtos.StateMachineLogEntryProto smLog = logEntry.getStateMachineLogEntry();
            ClientId clientId = ClientId.valueOf((ByteString)smLog.getClientId());
            long callId = smLog.getCallId();
            RetryCache.CacheEntry cacheEntry = this.getRetryCache().get(clientId, callId);
            if (cacheEntry != null) {
                RaftClientReply reply = new RaftClientReply(clientId, this.getMemberId(), callId, false, null, (RaftException)this.generateNotLeaderException(), logEntry.getIndex(), this.getCommitInfos());
                cacheEntry.failWithReply(reply);
            }
        }
    }

    public LeaderElectionMetrics getLeaderElectionMetrics() {
        return this.leaderElectionMetrics;
    }

    public RaftServerMetrics getRaftServerMetrics() {
        return this.raftServerMetrics;
    }

    private class RaftServerJmxAdapter
    extends JmxRegister
    implements RaftServerMXBean {
        private RaftServerJmxAdapter() {
        }

        @Override
        public String getId() {
            return RaftServerImpl.this.getMemberId().getPeerId().toString();
        }

        @Override
        public String getLeaderId() {
            return RaftServerImpl.this.getState().getLeaderId().toString();
        }

        @Override
        public long getCurrentTerm() {
            return RaftServerImpl.this.getState().getCurrentTerm();
        }

        @Override
        public String getGroupId() {
            return RaftServerImpl.this.getMemberId().getGroupId().toString();
        }

        @Override
        public String getRole() {
            return RaftServerImpl.this.role.toString();
        }

        @Override
        public List<String> getFollowers() {
            return RaftServerImpl.this.role.getLeaderState().map(LeaderState::getFollowers).orElse(Collections.emptyList()).stream().map(RaftPeer::toString).collect(Collectors.toList());
        }
    }
}

