/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.NotLeaderException;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftException;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.protocol.SetConfigurationRequest;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.impl.PendingRequest;
import org.apache.ratis.server.impl.RaftServerMetrics;
import org.apache.ratis.statemachine.TransactionContext;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.ResourceSemaphore;
import org.apache.ratis.util.SizeInBytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PendingRequests {
    public static final Logger LOG = LoggerFactory.getLogger(PendingRequests.class);
    private PendingRequest pendingSetConf;
    private final String name;
    private final RequestMap pendingRequests;

    PendingRequests(RaftGroupMemberId id, RaftProperties properties, RaftServerMetrics raftServerMetrics) {
        this.name = id + "-" + this.getClass().getSimpleName();
        this.pendingRequests = new RequestMap(id, RaftServerConfigKeys.Write.elementLimit(properties), RaftServerConfigKeys.Write.byteLimit(properties), raftServerMetrics);
    }

    Permit tryAcquire(Message message) {
        return this.pendingRequests.tryAcquire(message);
    }

    PendingRequest add(Permit permit, RaftClientRequest request, TransactionContext entry) {
        Preconditions.assertTrue((boolean)request.is(RaftProtos.RaftClientRequestProto.TypeCase.WRITE));
        long index = entry.getLogEntry().getIndex();
        LOG.debug("{}: addPendingRequest at index={}, request={}", new Object[]{this.name, index, request});
        PendingRequest pending = new PendingRequest(index, request, entry);
        return this.pendingRequests.put(permit, index, pending);
    }

    PendingRequest addConfRequest(SetConfigurationRequest request) {
        Preconditions.assertTrue((this.pendingSetConf == null ? 1 : 0) != 0);
        this.pendingSetConf = new PendingRequest(request);
        return this.pendingSetConf;
    }

    void replySetConfiguration(Supplier<Collection<RaftProtos.CommitInfoProto>> getCommitInfos) {
        if (this.pendingSetConf != null) {
            RaftClientRequest request = this.pendingSetConf.getRequest();
            LOG.debug("{}: sends success for {}", (Object)this.name, (Object)request);
            this.pendingSetConf.setReply(new RaftClientReply(request, getCommitInfos.get()));
            this.pendingSetConf = null;
        }
    }

    void failSetConfiguration(RaftException e) {
        Preconditions.assertTrue((this.pendingSetConf != null ? 1 : 0) != 0);
        this.pendingSetConf.setException((Throwable)e);
        this.pendingSetConf = null;
    }

    TransactionContext getTransactionContext(long index) {
        PendingRequest pendingRequest = this.pendingRequests.get(index);
        return pendingRequest != null ? pendingRequest.getEntry() : null;
    }

    void replyPendingRequest(long index, RaftClientReply reply) {
        PendingRequest pending = this.pendingRequests.remove(index);
        if (pending != null) {
            Preconditions.assertTrue((pending.getIndex() == index ? 1 : 0) != 0);
            pending.setReply(reply);
        }
    }

    Collection<TransactionContext> sendNotLeaderResponses(NotLeaderException nle, Collection<RaftProtos.CommitInfoProto> commitInfos) {
        LOG.info("{}: sendNotLeaderResponses", (Object)this.name);
        Collection<TransactionContext> transactions = this.pendingRequests.setNotLeaderException(nle, commitInfos);
        if (this.pendingSetConf != null) {
            this.pendingSetConf.setNotLeaderException(nle, commitInfos);
        }
        return transactions;
    }

    private static class RequestMap {
        private final Object name;
        private final ConcurrentMap<Long, PendingRequest> map = new ConcurrentHashMap<Long, PendingRequest>();
        private final RaftServerMetrics raftServerMetrics;
        private final Map<Permit, Permit> permits = new HashMap<Permit, Permit>();
        private final RequestLimits resource;

        RequestMap(Object name, int elementLimit, SizeInBytes byteLimit, RaftServerMetrics raftServerMetrics) {
            this.name = name;
            this.resource = new RequestLimits(elementLimit, byteLimit);
            this.raftServerMetrics = raftServerMetrics;
            raftServerMetrics.addNumPendingRequestsGauge(this.resource::getElementCount);
        }

        Permit tryAcquire(Message message) {
            boolean acquired = this.resource.tryAcquire(message);
            LOG.trace("tryAcquire? {}", (Object)acquired);
            if (!acquired) {
                this.raftServerMetrics.onRequestQueueLimitHit();
                return null;
            }
            return this.putPermit();
        }

        private synchronized Permit putPermit() {
            if (this.resource.isClosed()) {
                return null;
            }
            Permit permit = new Permit();
            this.permits.put(permit, permit);
            return permit;
        }

        synchronized PendingRequest put(Permit permit, long index, PendingRequest p) {
            LOG.debug("{}: PendingRequests.put {} -> {}", new Object[]{this.name, index, p});
            Permit removed = this.permits.remove(permit);
            if (removed == null) {
                return null;
            }
            Preconditions.assertTrue((removed == permit ? 1 : 0) != 0);
            PendingRequest previous = this.map.put(index, p);
            Preconditions.assertTrue((previous == null ? 1 : 0) != 0);
            return p;
        }

        PendingRequest get(long index) {
            PendingRequest r = (PendingRequest)this.map.get(index);
            LOG.debug("{}: PendingRequests.get {} returns {}", new Object[]{this.name, index, r});
            return r;
        }

        PendingRequest remove(long index) {
            PendingRequest r = (PendingRequest)this.map.remove(index);
            LOG.debug("{}: PendingRequests.remove {} returns {}", new Object[]{this.name, index, r});
            if (r == null) {
                return null;
            }
            this.resource.release(r.getRequest().getMessage());
            LOG.trace("release");
            return r;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Collection<TransactionContext> setNotLeaderException(NotLeaderException nle, Collection<RaftProtos.CommitInfoProto> commitInfos) {
            RequestMap requestMap = this;
            synchronized (requestMap) {
                this.resource.close();
                this.permits.clear();
            }
            LOG.debug("{}: PendingRequests.setNotLeaderException", this.name);
            ArrayList<TransactionContext> transactions = new ArrayList<TransactionContext>(this.map.size());
            Iterator i;
            while ((i = this.map.keySet().iterator()).hasNext()) {
                PendingRequest pending = (PendingRequest)this.map.remove(i.next());
                if (pending == null) continue;
                transactions.add(pending.setNotLeaderException(nle, commitInfos));
            }
            return transactions;
        }
    }

    static class RequestLimits
    extends ResourceSemaphore.Group {
        RequestLimits(int elementLimit, SizeInBytes byteLimit) {
            super(new int[]{elementLimit, byteLimit.getSizeInt()});
        }

        int getElementCount() {
            return this.get(0).used();
        }

        int getByteSize() {
            return this.get(1).used();
        }

        boolean tryAcquire(Message message) {
            return this.tryAcquire(new int[]{1, Message.getSize((Message)message)});
        }

        void release(Message message) {
            this.release(new int[]{1, Message.getSize((Message)message)});
        }
    }

    static class Permit {
        Permit() {
        }
    }
}

