/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NativeCodeLoader {
    private static final Logger LOG;
    private static boolean nativeCodeLoaded;

    private NativeCodeLoader() {
    }

    public static boolean isNativeCodeLoaded() {
        return nativeCodeLoaded;
    }

    public static native String getLibraryName();

    static {
        block3: {
            LOG = LoggerFactory.getLogger(NativeCodeLoader.class);
            nativeCodeLoaded = false;
            LOG.debug("Trying to load the custom-built native-ratis library...");
            try {
                System.loadLibrary("ratis");
                LOG.debug("Loaded the native-ratis library");
                nativeCodeLoaded = true;
            }
            catch (Throwable t) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug("Failed to load native-ratis with error: " + t);
                LOG.debug("java.library.path=" + System.getProperty("java.library.path"));
            }
        }
        if (!nativeCodeLoaded) {
            LOG.warn("Unable to load native-ratis library for your platform... using builtin-java classes where applicable");
        }
    }
}

