/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.client.retry;

import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.ratis.client.ClientRetryEvent;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.retry.RetryPolicies;
import org.apache.ratis.retry.RetryPolicy;
import org.apache.ratis.util.Preconditions;

public final class RequestTypeDependentRetryPolicy
implements RetryPolicy {
    private final Map<RaftProtos.RaftClientRequestProto.TypeCase, RetryPolicy> map;
    private final Supplier<String> myString;

    public static Builder newBuilder() {
        return new Builder();
    }

    private RequestTypeDependentRetryPolicy(EnumMap<RaftProtos.RaftClientRequestProto.TypeCase, RetryPolicy> map) {
        this.map = Collections.unmodifiableMap(map);
        this.myString = () -> {
            StringBuilder b = new StringBuilder(this.getClass().getSimpleName()).append("{");
            map.forEach((key, value) -> b.append(key).append("->").append(value).append(", "));
            b.setLength(b.length() - 2);
            return b.append("}").toString();
        };
    }

    public RetryPolicy.Action handleAttemptFailure(RetryPolicy.Event event) {
        if (!(event instanceof ClientRetryEvent)) {
            return RetryPolicies.retryForeverNoSleep().handleAttemptFailure(event);
        }
        ClientRetryEvent clientEvent = (ClientRetryEvent)event;
        return Optional.ofNullable(this.map.get(clientEvent.getRequest().getType().getTypeCase())).orElse(RetryPolicies.retryForeverNoSleep()).handleAttemptFailure(event);
    }

    public String toString() {
        return this.myString.get();
    }

    public static class Builder {
        private final EnumMap<RaftProtos.RaftClientRequestProto.TypeCase, RetryPolicy> map = new EnumMap(RaftProtos.RaftClientRequestProto.TypeCase.class);

        public Builder set(RaftProtos.RaftClientRequestProto.TypeCase type, RetryPolicy policy) {
            RetryPolicy previous = this.map.put(type, policy);
            Preconditions.assertNull((Object)previous, () -> "The type " + type + " is already set to " + previous);
            return this;
        }

        public RequestTypeDependentRetryPolicy build() {
            return new RequestTypeDependentRetryPolicy(this.map);
        }
    }
}

