/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.client.impl;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.AlreadyClosedException;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.GroupInfoReply;
import org.apache.ratis.protocol.GroupInfoRequest;
import org.apache.ratis.protocol.GroupListReply;
import org.apache.ratis.protocol.GroupListRequest;
import org.apache.ratis.protocol.GroupManagementRequest;
import org.apache.ratis.protocol.LeaderNotReadyException;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.NotLeaderException;
import org.apache.ratis.protocol.NotReplicatedException;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftException;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.SetConfigurationRequest;
import org.apache.ratis.protocol.StateMachineException;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.util.ProtoUtils;
import org.apache.ratis.util.ReflectionUtils;

public interface ClientProtoUtils {
    public static RaftProtos.RaftRpcReplyProto.Builder toRaftRpcReplyProtoBuilder(ByteString requestorId, ByteString replyId, RaftGroupId groupId, long callId, boolean success) {
        return RaftProtos.RaftRpcReplyProto.newBuilder().setRequestorId(requestorId).setReplyId(replyId).setRaftGroupId(ProtoUtils.toRaftGroupIdProtoBuilder((RaftGroupId)groupId)).setCallId(callId).setSuccess(success);
    }

    public static RaftProtos.RaftRpcRequestProto.Builder toRaftRpcRequestProtoBuilder(ByteString requesterId, ByteString replyId, RaftGroupId groupId, long callId, RaftProtos.SlidingWindowEntry slidingWindowEntry) {
        if (slidingWindowEntry == null) {
            slidingWindowEntry = RaftProtos.SlidingWindowEntry.getDefaultInstance();
        }
        return RaftProtos.RaftRpcRequestProto.newBuilder().setRequestorId(requesterId).setReplyId(replyId).setRaftGroupId(ProtoUtils.toRaftGroupIdProtoBuilder((RaftGroupId)groupId)).setCallId(callId).setSlidingWindowEntry(slidingWindowEntry);
    }

    public static RaftProtos.RaftRpcRequestProto.Builder toRaftRpcRequestProtoBuilder(ClientId requesterId, RaftPeerId replyId, RaftGroupId groupId, long callId, RaftProtos.SlidingWindowEntry slidingWindowEntry) {
        return ClientProtoUtils.toRaftRpcRequestProtoBuilder(requesterId.toByteString(), replyId.toByteString(), groupId, callId, slidingWindowEntry);
    }

    public static RaftProtos.RaftRpcRequestProto.Builder toRaftRpcRequestProtoBuilder(RaftClientRequest request) {
        return ClientProtoUtils.toRaftRpcRequestProtoBuilder(request.getClientId(), request.getServerId(), request.getRaftGroupId(), request.getCallId(), request.getSlidingWindowEntry());
    }

    public static RaftClientRequest.Type toRaftClientRequestType(RaftProtos.RaftClientRequestProto p) {
        switch (p.getTypeCase()) {
            case WRITE: {
                return RaftClientRequest.Type.valueOf((RaftProtos.WriteRequestTypeProto)p.getWrite());
            }
            case READ: {
                return RaftClientRequest.Type.valueOf((RaftProtos.ReadRequestTypeProto)p.getRead());
            }
            case STALEREAD: {
                return RaftClientRequest.Type.valueOf((RaftProtos.StaleReadRequestTypeProto)p.getStaleRead());
            }
            case WATCH: {
                return RaftClientRequest.Type.valueOf((RaftProtos.WatchRequestTypeProto)p.getWatch());
            }
        }
        throw new IllegalArgumentException("Unexpected request type: " + p.getTypeCase() + " in request proto " + p);
    }

    public static RaftClientRequest toRaftClientRequest(RaftProtos.RaftClientRequestProto p) {
        RaftClientRequest.Type type = ClientProtoUtils.toRaftClientRequestType(p);
        RaftProtos.RaftRpcRequestProto request = p.getRpcRequest();
        return new RaftClientRequest(ClientId.valueOf((ByteString)request.getRequestorId()), RaftPeerId.valueOf((ByteString)request.getReplyId()), ProtoUtils.toRaftGroupId((RaftProtos.RaftGroupIdProto)request.getRaftGroupId()), request.getCallId(), ClientProtoUtils.toMessage(p.getMessage()), type, request.getSlidingWindowEntry());
    }

    public static RaftProtos.RaftClientRequestProto toRaftClientRequestProto(RaftClientRequest request) {
        RaftProtos.RaftClientRequestProto.Builder b = RaftProtos.RaftClientRequestProto.newBuilder().setRpcRequest(ClientProtoUtils.toRaftRpcRequestProtoBuilder(request));
        if (request.getMessage() != null) {
            b.setMessage(ClientProtoUtils.toClientMessageEntryProtoBuilder(request.getMessage()));
        }
        RaftClientRequest.Type type = request.getType();
        switch (type.getTypeCase()) {
            case WRITE: {
                b.setWrite(type.getWrite());
                break;
            }
            case READ: {
                b.setRead(type.getRead());
                break;
            }
            case STALEREAD: {
                b.setStaleRead(type.getStaleRead());
                break;
            }
            case WATCH: {
                b.setWatch(type.getWatch());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected request type: " + request.getType() + " in request " + request);
            }
        }
        return b.build();
    }

    public static RaftProtos.RaftClientRequestProto toRaftClientRequestProto(ClientId clientId, RaftPeerId serverId, RaftGroupId groupId, long callId, long seqNum, ByteString content) {
        return RaftProtos.RaftClientRequestProto.newBuilder().setRpcRequest(ClientProtoUtils.toRaftRpcRequestProtoBuilder(clientId, serverId, groupId, callId, ProtoUtils.toSlidingWindowEntry((long)seqNum, (boolean)false))).setWrite(RaftProtos.WriteRequestTypeProto.getDefaultInstance()).setMessage(ClientProtoUtils.toClientMessageEntryProtoBuilder(content)).build();
    }

    public static RaftProtos.RaftClientReplyProto toRaftClientReplyProto(RaftClientReply reply) {
        RaftProtos.RaftClientReplyProto.Builder b = RaftProtos.RaftClientReplyProto.newBuilder();
        if (reply != null) {
            AlreadyClosedException ace;
            LeaderNotReadyException lnre;
            b.setRpcReply(ClientProtoUtils.toRaftRpcReplyProtoBuilder(reply.getClientId().toByteString(), reply.getServerId().toByteString(), reply.getRaftGroupId(), reply.getCallId(), reply.isSuccess()));
            b.setLogIndex(reply.getLogIndex());
            if (reply.getMessage() != null) {
                b.setMessage(ClientProtoUtils.toClientMessageEntryProtoBuilder(reply.getMessage()));
            }
            ProtoUtils.addCommitInfos((Collection)reply.getCommitInfos(), arg_0 -> ((RaftProtos.RaftClientReplyProto.Builder)b).addCommitInfos(arg_0));
            NotLeaderException nle = reply.getNotLeaderException();
            if (nle != null) {
                RaftProtos.NotLeaderExceptionProto.Builder nleBuilder = RaftProtos.NotLeaderExceptionProto.newBuilder();
                RaftPeer suggestedLeader = nle.getSuggestedLeader();
                if (suggestedLeader != null) {
                    nleBuilder.setSuggestedLeader(suggestedLeader.getRaftPeerProto());
                }
                nleBuilder.addAllPeersInConf(ProtoUtils.toRaftPeerProtos((Collection)nle.getPeers()));
                b.setNotLeaderException(nleBuilder.build());
            } else {
                StateMachineException sme = reply.getStateMachineException();
                if (sme != null) {
                    RaftProtos.StateMachineExceptionProto.Builder smeBuilder = RaftProtos.StateMachineExceptionProto.newBuilder();
                    Throwable t = sme.getCause() != null ? sme.getCause() : sme;
                    smeBuilder.setExceptionClassName(t.getClass().getName()).setErrorMsg(t.getMessage()).setStacktrace(ProtoUtils.writeObject2ByteString((Object)t.getStackTrace()));
                    b.setStateMachineException(smeBuilder.build());
                }
            }
            NotReplicatedException nre = reply.getNotReplicatedException();
            if (nre != null) {
                RaftProtos.NotReplicatedExceptionProto.Builder nreBuilder = RaftProtos.NotReplicatedExceptionProto.newBuilder().setCallId(nre.getCallId()).setReplication(nre.getRequiredReplication()).setLogIndex(nre.getLogIndex());
                b.setNotReplicatedException(nreBuilder);
            }
            if ((lnre = reply.getLeaderNotReadyException()) != null) {
                RaftProtos.LeaderNotReadyExceptionProto.Builder lnreBuilder = RaftProtos.LeaderNotReadyExceptionProto.newBuilder().setServerId(ProtoUtils.toRaftGroupMemberIdProtoBuilder((RaftGroupMemberId)lnre.getServerId()));
                b.setLeaderNotReadyException(lnreBuilder);
            }
            if ((ace = reply.getAlreadyClosedException()) != null) {
                Throwable t = ace.getCause() != null ? ace.getCause() : ace;
                RaftProtos.AlreadyClosedExceptionProto.Builder aceBuilder = RaftProtos.AlreadyClosedExceptionProto.newBuilder().setExceptionClassName(t.getClass().getName()).setErrorMsg(ace.getMessage()).setStacktrace(ProtoUtils.writeObject2ByteString((Object)ace.getStackTrace()));
                b.setAlreadyClosedException(aceBuilder);
            }
            RaftProtos.RaftClientReplyProto serialized = b.build();
            RaftException e = reply.getException();
            if (e != null) {
                RaftClientReply deserialized = ClientProtoUtils.toRaftClientReply(serialized);
                if (!Optional.ofNullable(deserialized.getException()).map(Object::getClass).filter(e.getClass()::equals).isPresent()) {
                    throw new AssertionError("Corruption while serializing reply= " + reply + " but serialized=" + serialized + " and deserialized=" + deserialized, (Throwable)e);
                }
            }
            return serialized;
        }
        return b.build();
    }

    public static RaftProtos.GroupListReplyProto toGroupListReplyProto(GroupListReply reply) {
        RaftProtos.GroupListReplyProto.Builder b = RaftProtos.GroupListReplyProto.newBuilder();
        if (reply != null) {
            b.setRpcReply(ClientProtoUtils.toRaftRpcReplyProtoBuilder(reply.getClientId().toByteString(), reply.getServerId().toByteString(), reply.getRaftGroupId(), reply.getCallId(), reply.isSuccess()));
            if (reply.getGroupIds() != null) {
                reply.getGroupIds().forEach(groupId -> b.addGroupId(ProtoUtils.toRaftGroupIdProtoBuilder((RaftGroupId)groupId)));
            }
        }
        return b.build();
    }

    public static RaftProtos.GroupInfoReplyProto toGroupInfoReplyProto(GroupInfoReply reply) {
        RaftProtos.GroupInfoReplyProto.Builder b = RaftProtos.GroupInfoReplyProto.newBuilder();
        if (reply != null) {
            b.setRpcReply(ClientProtoUtils.toRaftRpcReplyProtoBuilder(reply.getClientId().toByteString(), reply.getServerId().toByteString(), reply.getRaftGroupId(), reply.getCallId(), reply.isSuccess()));
            if (reply.getRaftGroupId() != null) {
                b.setGroup(ProtoUtils.toRaftGroupProtoBuilder((RaftGroup)reply.getGroup()));
                b.setIsRaftStorageHealthy(reply.isRaftStorageHealthy());
                b.setRole(reply.getRoleInfoProto());
                ProtoUtils.addCommitInfos((Collection)reply.getCommitInfos(), arg_0 -> ((RaftProtos.GroupInfoReplyProto.Builder)b).addCommitInfos(arg_0));
            }
        }
        return b.build();
    }

    public static RaftClientReply toRaftClientReply(RaftProtos.RaftClientReplyProto replyProto) {
        NotReplicatedException e;
        RaftProtos.RaftRpcReplyProto rp = replyProto.getRpcReply();
        RaftGroupMemberId serverMemberId = ProtoUtils.toRaftGroupMemberId((ByteString)rp.getReplyId(), (RaftProtos.RaftGroupIdProto)rp.getRaftGroupId());
        if (replyProto.getExceptionDetailsCase().equals((Object)RaftProtos.RaftClientReplyProto.ExceptionDetailsCase.NOTLEADEREXCEPTION)) {
            RaftProtos.NotLeaderExceptionProto nleProto = replyProto.getNotLeaderException();
            RaftPeer suggestedLeader = nleProto.hasSuggestedLeader() ? ProtoUtils.toRaftPeer((RaftProtos.RaftPeerProto)nleProto.getSuggestedLeader()) : null;
            List peers = ProtoUtils.toRaftPeers((List)nleProto.getPeersInConfList());
            e = new NotLeaderException(serverMemberId, suggestedLeader, (Collection)peers);
        } else if (replyProto.getExceptionDetailsCase() == RaftProtos.RaftClientReplyProto.ExceptionDetailsCase.NOTREPLICATEDEXCEPTION) {
            RaftProtos.NotReplicatedExceptionProto nre = replyProto.getNotReplicatedException();
            e = new NotReplicatedException(nre.getCallId(), nre.getReplication(), nre.getLogIndex());
        } else if (replyProto.getExceptionDetailsCase().equals((Object)RaftProtos.RaftClientReplyProto.ExceptionDetailsCase.STATEMACHINEEXCEPTION)) {
            RaftProtos.StateMachineExceptionProto smeProto = replyProto.getStateMachineException();
            e = ClientProtoUtils.wrapStateMachineException(serverMemberId, smeProto.getExceptionClassName(), smeProto.getErrorMsg(), smeProto.getStacktrace());
        } else if (replyProto.getExceptionDetailsCase().equals((Object)RaftProtos.RaftClientReplyProto.ExceptionDetailsCase.LEADERNOTREADYEXCEPTION)) {
            RaftProtos.LeaderNotReadyExceptionProto lnreProto = replyProto.getLeaderNotReadyException();
            e = new LeaderNotReadyException(ProtoUtils.toRaftGroupMemberId((RaftProtos.RaftGroupMemberIdProto)lnreProto.getServerId()));
        } else if (replyProto.getExceptionDetailsCase().equals((Object)RaftProtos.RaftClientReplyProto.ExceptionDetailsCase.ALREADYCLOSEDEXCEPTION)) {
            RaftProtos.AlreadyClosedExceptionProto aceProto = replyProto.getAlreadyClosedException();
            e = ClientProtoUtils.wrapAlreadyClosedException(aceProto.getExceptionClassName(), aceProto.getErrorMsg(), aceProto.getStacktrace());
        } else {
            e = null;
        }
        ClientId clientId = ClientId.valueOf((ByteString)rp.getRequestorId());
        return new RaftClientReply(clientId, serverMemberId, rp.getCallId(), rp.getSuccess(), ClientProtoUtils.toMessage(replyProto.getMessage()), (RaftException)e, replyProto.getLogIndex(), (Collection)replyProto.getCommitInfosList());
    }

    public static GroupListReply toGroupListReply(RaftProtos.GroupListReplyProto replyProto) {
        RaftProtos.RaftRpcReplyProto rp = replyProto.getRpcReply();
        ClientId clientId = ClientId.valueOf((ByteString)rp.getRequestorId());
        RaftGroupId groupId = ProtoUtils.toRaftGroupId((RaftProtos.RaftGroupIdProto)rp.getRaftGroupId());
        List groupInfos = replyProto.getGroupIdList().stream().map(ProtoUtils::toRaftGroupId).collect(Collectors.toList());
        return new GroupListReply(clientId, RaftPeerId.valueOf((ByteString)rp.getReplyId()), groupId, rp.getCallId(), rp.getSuccess(), groupInfos);
    }

    public static GroupInfoReply toGroupInfoReply(RaftProtos.GroupInfoReplyProto replyProto) {
        RaftProtos.RaftRpcReplyProto rp = replyProto.getRpcReply();
        ClientId clientId = ClientId.valueOf((ByteString)rp.getRequestorId());
        RaftGroupId groupId = ProtoUtils.toRaftGroupId((RaftProtos.RaftGroupIdProto)rp.getRaftGroupId());
        RaftGroup raftGroup = ProtoUtils.toRaftGroup((RaftProtos.RaftGroupProto)replyProto.getGroup());
        RaftProtos.RoleInfoProto role = replyProto.getRole();
        boolean isRaftStorageHealthy = replyProto.getIsRaftStorageHealthy();
        return new GroupInfoReply(clientId, RaftPeerId.valueOf((ByteString)rp.getReplyId()), groupId, rp.getCallId(), rp.getSuccess(), role, isRaftStorageHealthy, (Collection)replyProto.getCommitInfosList(), raftGroup);
    }

    public static StateMachineException wrapStateMachineException(RaftGroupMemberId memberId, String className, String errorMsg, ByteString stackTraceBytes) {
        StateMachineException sme;
        if (className == null) {
            sme = new StateMachineException(errorMsg);
        } else {
            try {
                Class<?> clazz = Class.forName(className);
                Exception e = ReflectionUtils.instantiateException(clazz.asSubclass(Exception.class), (String)errorMsg, null);
                sme = new StateMachineException(memberId, (Throwable)e);
            }
            catch (Exception e) {
                sme = new StateMachineException(className + ": " + errorMsg);
            }
        }
        StackTraceElement[] stacktrace = (StackTraceElement[])ProtoUtils.toObject((ByteString)stackTraceBytes);
        sme.setStackTrace(stacktrace);
        return sme;
    }

    public static AlreadyClosedException wrapAlreadyClosedException(String className, String errorMsg, ByteString stackTraceBytes) {
        AlreadyClosedException ace;
        if (className == null) {
            ace = new AlreadyClosedException(errorMsg);
        } else {
            try {
                Class<?> clazz = Class.forName(className);
                Exception e = ReflectionUtils.instantiateException(clazz.asSubclass(Exception.class), (String)errorMsg, null);
                ace = new AlreadyClosedException(errorMsg, (Throwable)e);
            }
            catch (Exception e) {
                ace = new AlreadyClosedException(className + ": " + errorMsg);
            }
        }
        StackTraceElement[] stacktrace = (StackTraceElement[])ProtoUtils.toObject((ByteString)stackTraceBytes);
        ace.setStackTrace(stacktrace);
        return ace;
    }

    public static Message toMessage(RaftProtos.ClientMessageEntryProto p) {
        return Message.valueOf((ByteString)p.getContent());
    }

    public static RaftProtos.ClientMessageEntryProto.Builder toClientMessageEntryProtoBuilder(ByteString message) {
        return RaftProtos.ClientMessageEntryProto.newBuilder().setContent(message);
    }

    public static RaftProtos.ClientMessageEntryProto.Builder toClientMessageEntryProtoBuilder(Message message) {
        return ClientProtoUtils.toClientMessageEntryProtoBuilder(message.getContent());
    }

    public static SetConfigurationRequest toSetConfigurationRequest(RaftProtos.SetConfigurationRequestProto p) {
        RaftProtos.RaftRpcRequestProto m = p.getRpcRequest();
        List peers = ProtoUtils.toRaftPeers((List)p.getPeersList());
        return new SetConfigurationRequest(ClientId.valueOf((ByteString)m.getRequestorId()), RaftPeerId.valueOf((ByteString)m.getReplyId()), ProtoUtils.toRaftGroupId((RaftProtos.RaftGroupIdProto)m.getRaftGroupId()), p.getRpcRequest().getCallId(), peers);
    }

    public static RaftProtos.SetConfigurationRequestProto toSetConfigurationRequestProto(SetConfigurationRequest request) {
        return RaftProtos.SetConfigurationRequestProto.newBuilder().setRpcRequest(ClientProtoUtils.toRaftRpcRequestProtoBuilder((RaftClientRequest)request)).addAllPeers(ProtoUtils.toRaftPeerProtos((Collection)request.getPeersInNewConf())).build();
    }

    public static GroupManagementRequest toGroupManagementRequest(RaftProtos.GroupManagementRequestProto p) {
        RaftProtos.RaftRpcRequestProto m = p.getRpcRequest();
        ClientId clientId = ClientId.valueOf((ByteString)m.getRequestorId());
        RaftPeerId serverId = RaftPeerId.valueOf((ByteString)m.getReplyId());
        switch (p.getOpCase()) {
            case GROUPADD: {
                return GroupManagementRequest.newAdd((ClientId)clientId, (RaftPeerId)serverId, (long)m.getCallId(), (RaftGroup)ProtoUtils.toRaftGroup((RaftProtos.RaftGroupProto)p.getGroupAdd().getGroup()));
            }
            case GROUPREMOVE: {
                RaftProtos.GroupRemoveRequestProto remove = p.getGroupRemove();
                return GroupManagementRequest.newRemove((ClientId)clientId, (RaftPeerId)serverId, (long)m.getCallId(), (RaftGroupId)ProtoUtils.toRaftGroupId((RaftProtos.RaftGroupIdProto)remove.getGroupId()), (boolean)remove.getDeleteDirectory());
            }
        }
        throw new IllegalArgumentException("Unexpected op " + p.getOpCase() + " in " + p);
    }

    public static GroupInfoRequest toGroupInfoRequest(RaftProtos.GroupInfoRequestProto p) {
        RaftProtos.RaftRpcRequestProto m = p.getRpcRequest();
        return new GroupInfoRequest(ClientId.valueOf((ByteString)m.getRequestorId()), RaftPeerId.valueOf((ByteString)m.getReplyId()), ProtoUtils.toRaftGroupId((RaftProtos.RaftGroupIdProto)m.getRaftGroupId()), m.getCallId());
    }

    public static GroupListRequest toGroupListRequest(RaftProtos.GroupListRequestProto p) {
        RaftProtos.RaftRpcRequestProto m = p.getRpcRequest();
        return new GroupListRequest(ClientId.valueOf((ByteString)m.getRequestorId()), RaftPeerId.valueOf((ByteString)m.getReplyId()), ProtoUtils.toRaftGroupId((RaftProtos.RaftGroupIdProto)m.getRaftGroupId()), m.getCallId());
    }

    public static RaftProtos.GroupManagementRequestProto toGroupManagementRequestProto(GroupManagementRequest request) {
        GroupManagementRequest.Remove remove;
        RaftProtos.GroupManagementRequestProto.Builder b = RaftProtos.GroupManagementRequestProto.newBuilder().setRpcRequest(ClientProtoUtils.toRaftRpcRequestProtoBuilder((RaftClientRequest)request));
        GroupManagementRequest.Add add = request.getAdd();
        if (add != null) {
            b.setGroupAdd(RaftProtos.GroupAddRequestProto.newBuilder().setGroup(ProtoUtils.toRaftGroupProtoBuilder((RaftGroup)add.getGroup())).build());
        }
        if ((remove = request.getRemove()) != null) {
            b.setGroupRemove(RaftProtos.GroupRemoveRequestProto.newBuilder().setGroupId(ProtoUtils.toRaftGroupIdProtoBuilder((RaftGroupId)remove.getGroupId())).setDeleteDirectory(remove.isDeleteDirectory()).build());
        }
        return b.build();
    }

    public static RaftProtos.GroupInfoRequestProto toGroupInfoRequestProto(GroupInfoRequest request) {
        return RaftProtos.GroupInfoRequestProto.newBuilder().setRpcRequest(ClientProtoUtils.toRaftRpcRequestProtoBuilder((RaftClientRequest)request)).build();
    }

    public static RaftProtos.GroupListRequestProto toGroupListRequestProto(GroupListRequest request) {
        return RaftProtos.GroupListRequestProto.newBuilder().setRpcRequest(ClientProtoUtils.toRaftRpcRequestProtoBuilder((RaftClientRequest)request)).build();
    }

    public static String toString(RaftProtos.RaftClientRequestProto proto) {
        RaftProtos.RaftRpcRequestProto rpc = proto.getRpcRequest();
        return ClientId.valueOf((ByteString)rpc.getRequestorId()) + "->" + rpc.getReplyId().toStringUtf8() + "#" + rpc.getCallId() + "-" + ProtoUtils.toString((RaftProtos.SlidingWindowEntry)rpc.getSlidingWindowEntry());
    }

    public static String toString(RaftProtos.RaftClientReplyProto proto) {
        RaftProtos.RaftRpcReplyProto rpc = proto.getRpcReply();
        return ClientId.valueOf((ByteString)rpc.getRequestorId()) + "<-" + rpc.getReplyId().toStringUtf8() + "#" + rpc.getCallId();
    }
}

