/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.hadooprpc.client;

import java.io.IOException;
import java.util.function.Function;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.ratis.client.impl.ClientProtoUtils;
import org.apache.ratis.hadooprpc.Proxy;
import org.apache.ratis.hadooprpc.client.CombinedClientProtocol;
import org.apache.ratis.hadooprpc.client.CombinedClientProtocolPB;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.GroupInfoReply;
import org.apache.ratis.protocol.GroupInfoRequest;
import org.apache.ratis.protocol.GroupListReply;
import org.apache.ratis.protocol.GroupListRequest;
import org.apache.ratis.protocol.GroupManagementRequest;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.SetConfigurationRequest;
import org.apache.ratis.thirdparty.com.google.protobuf.ServiceException;
import org.apache.ratis.util.ProtoUtils;
import org.apache.ratis.util.function.CheckedFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class CombinedClientProtocolClientSideTranslatorPB
extends Proxy<CombinedClientProtocolPB>
implements CombinedClientProtocol {
    private static final Logger LOG = LoggerFactory.getLogger(CombinedClientProtocolClientSideTranslatorPB.class);

    public CombinedClientProtocolClientSideTranslatorPB(String addressStr, Configuration conf) throws IOException {
        super(CombinedClientProtocolPB.class, addressStr, conf);
    }

    public RaftClientReply submitClientRequest(RaftClientRequest request) throws IOException {
        return CombinedClientProtocolClientSideTranslatorPB.handleRequest(request, ClientProtoUtils::toRaftClientRequestProto, ClientProtoUtils::toRaftClientReply, p -> ((CombinedClientProtocolPB)this.getProtocol()).submitClientRequest(null, (RaftProtos.RaftClientRequestProto)p));
    }

    public RaftClientReply setConfiguration(SetConfigurationRequest request) throws IOException {
        return CombinedClientProtocolClientSideTranslatorPB.handleRequest(request, ClientProtoUtils::toSetConfigurationRequestProto, ClientProtoUtils::toRaftClientReply, p -> ((CombinedClientProtocolPB)this.getProtocol()).setConfiguration(null, (RaftProtos.SetConfigurationRequestProto)p));
    }

    public RaftClientReply groupManagement(GroupManagementRequest request) throws IOException {
        return CombinedClientProtocolClientSideTranslatorPB.handleRequest(request, ClientProtoUtils::toGroupManagementRequestProto, ClientProtoUtils::toRaftClientReply, p -> ((CombinedClientProtocolPB)this.getProtocol()).groupManagement(null, (RaftProtos.GroupManagementRequestProto)p));
    }

    public GroupListReply getGroupList(GroupListRequest request) throws IOException {
        return CombinedClientProtocolClientSideTranslatorPB.handleRequest(request, ClientProtoUtils::toGroupListRequestProto, ClientProtoUtils::toGroupListReply, p -> ((CombinedClientProtocolPB)this.getProtocol()).groupList(null, (RaftProtos.GroupListRequestProto)p));
    }

    public GroupInfoReply getGroupInfo(GroupInfoRequest request) throws IOException {
        return CombinedClientProtocolClientSideTranslatorPB.handleRequest(request, ClientProtoUtils::toGroupInfoRequestProto, ClientProtoUtils::toGroupInfoReply, p -> ((CombinedClientProtocolPB)this.getProtocol()).groupInfo(null, (RaftProtos.GroupInfoRequestProto)p));
    }

    static <REQUEST extends RaftClientRequest, REPLY extends RaftClientReply, PROTO_REQ, PROTO_REP> REPLY handleRequest(REQUEST request, Function<REQUEST, PROTO_REQ> reqToProto, Function<PROTO_REP, REPLY> repToProto, CheckedFunction<PROTO_REQ, PROTO_REP, ServiceException> handler) throws IOException {
        PROTO_REQ proto = reqToProto.apply(request);
        try {
            Object reply = handler.apply(proto);
            return (REPLY)((RaftClientReply)repToProto.apply(reply));
        }
        catch (ServiceException se) {
            LOG.trace("Failed to handle " + request, (Throwable)se);
            throw ProtoUtils.toIOException((ServiceException)se);
        }
    }
}

