/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.hadooprpc;

import org.apache.hadoop.conf.Configuration;
import org.apache.ratis.client.ClientFactory;
import org.apache.ratis.conf.Parameters;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.hadooprpc.HadoopConfigKeys;
import org.apache.ratis.hadooprpc.client.HadoopClientRpc;
import org.apache.ratis.hadooprpc.server.HadoopRpcService;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.rpc.SupportedRpcType;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.impl.ServerFactory;

public class HadoopFactory
extends ServerFactory.BaseFactory
implements ClientFactory {
    private final Configuration conf;

    public static Parameters newRaftParameters(Configuration conf) {
        Parameters p = new Parameters();
        HadoopConfigKeys.setConf(p, conf);
        return p;
    }

    public HadoopFactory(Parameters parameters) {
        this(HadoopConfigKeys.getConf(parameters));
    }

    public HadoopFactory(Configuration conf) {
        this.conf = conf != null ? conf : new Configuration();
    }

    public Configuration getConf() {
        return this.conf;
    }

    public SupportedRpcType getRpcType() {
        return SupportedRpcType.HADOOP;
    }

    public HadoopRpcService newRaftServerRpc(RaftServer server) {
        return ((HadoopRpcService.Builder)HadoopRpcService.newBuilder().setServer(server)).setConf(this.getConf()).build();
    }

    public HadoopClientRpc newRaftClientRpc(ClientId clientId, RaftProperties properties) {
        return new HadoopClientRpc(clientId, this.getConf());
    }
}

