/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.metrics;

import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.MetricRegistry;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.ratis.metrics.RatisMetricRegistry;
import org.apache.ratis.util.TimeDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MetricsReporting {
    public static final Logger LOG = LoggerFactory.getLogger(MetricsReporting.class);

    private MetricsReporting() {
    }

    public static Consumer<RatisMetricRegistry> consoleReporter(TimeDuration rate) {
        return ratisMetricRegistry -> ConsoleReporter.forRegistry((MetricRegistry)ratisMetricRegistry.getDropWizardMetricRegistry()).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build().start(rate.getDuration(), rate.getUnit());
    }

    public static Consumer<RatisMetricRegistry> jmxReporter() {
        return registry -> {
            JmxReporter.Builder builder = JmxReporter.forRegistry((MetricRegistry)registry.getDropWizardMetricRegistry());
            builder.inDomain(registry.getMetricRegistryInfo().getApplicationName());
            builder.build().start();
        };
    }
}

