/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.logservice.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.ratis.logservice.api.LogName;
import org.apache.ratis.logservice.api.LogStream;
import org.apache.ratis.logservice.proto.LogServiceProtos;
import org.apache.ratis.logservice.server.ArchivalInfo;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;

public class LogServiceProtoUtil {
    public static LogServiceProtos.LogNameProto toLogNameProto(LogName logName) {
        return LogServiceProtos.LogNameProto.newBuilder().setName(logName.getName()).build();
    }

    public static LogName toLogName(LogServiceProtos.LogNameProto logNameProto) {
        return LogName.of(logNameProto.getName());
    }

    public static LogServiceProtos.LogStreamProto toLogStreamProto(LogStream logStream) throws IOException {
        LogServiceProtos.LogNameProto logNameProto = LogServiceProtos.LogNameProto.newBuilder().setName(logStream.getName().getName()).build();
        LogServiceProtos.LogStreamProto logStreamProto = LogServiceProtos.LogStreamProto.newBuilder().setLogName(logNameProto).setSize(logStream.getSize()).setState(logStream.getState().equals((Object)LogStream.State.OPEN) ? LogServiceProtos.LogStreamState.OPEN : LogServiceProtos.LogStreamState.CLOSED).build();
        return logStreamProto;
    }

    public static LogServiceProtos.LogServiceRequestProto toChangeStateRequestProto(LogName logName, LogStream.State state, boolean force) {
        LogServiceProtos.LogNameProto logNameProto = LogServiceProtos.LogNameProto.newBuilder().setName(logName.getName()).build();
        LogServiceProtos.ChangeStateLogRequestProto changeLog = LogServiceProtos.ChangeStateLogRequestProto.newBuilder().setLogName(logNameProto).setState(LogServiceProtos.LogStreamState.valueOf(state.name())).setForce(force).build();
        return LogServiceProtos.LogServiceRequestProto.newBuilder().setChangeState(changeLog).build();
    }

    public static LogServiceProtos.LogServiceRequestProto toChangeStateRequestProto(LogName logName, LogStream.State state) {
        return LogServiceProtoUtil.toChangeStateRequestProto(logName, state, false);
    }

    public static LogServiceProtos.LogServiceRequestProto toGetStateRequestProto(LogName logName) {
        LogServiceProtos.LogNameProto logNameProto = LogServiceProtos.LogNameProto.newBuilder().setName(logName.getName()).build();
        LogServiceProtos.GetStateRequestProto getState = LogServiceProtos.GetStateRequestProto.newBuilder().setLogName(logNameProto).build();
        return LogServiceProtos.LogServiceRequestProto.newBuilder().setGetState(getState).build();
    }

    public static LogServiceProtos.ArchiveLogReplyProto toArchiveLogReplyProto(Throwable t) {
        LogServiceProtos.ArchiveLogReplyProto.Builder builder = LogServiceProtos.ArchiveLogReplyProto.newBuilder();
        if (t != null) {
            builder.setException(LogServiceProtoUtil.toLogException(t));
        }
        return builder.build();
    }

    public static LogServiceProtos.LogServiceRequestProto toGetSizeRequestProto(LogName name) {
        LogServiceProtos.LogNameProto logNameProto = LogServiceProtos.LogNameProto.newBuilder().setName(name.getName()).build();
        LogServiceProtos.GetLogSizeRequestProto getLogSize = LogServiceProtos.GetLogSizeRequestProto.newBuilder().setLogName(logNameProto).build();
        return LogServiceProtos.LogServiceRequestProto.newBuilder().setSizeRequest(getLogSize).build();
    }

    public static LogServiceProtos.LogServiceRequestProto toGetLengthRequestProto(LogName name) {
        LogServiceProtos.LogNameProto logNameProto = LogServiceProtos.LogNameProto.newBuilder().setName(name.getName()).build();
        LogServiceProtos.GetLogLengthRequestProto.Builder builder = LogServiceProtos.GetLogLengthRequestProto.newBuilder();
        builder.setLogName(logNameProto);
        return LogServiceProtos.LogServiceRequestProto.newBuilder().setLengthQuery(builder.build()).build();
    }

    public static LogServiceProtos.LogServiceRequestProto toGetLastCommittedIndexRequestProto(LogName name) {
        LogServiceProtos.LogNameProto logNameProto = LogServiceProtos.LogNameProto.newBuilder().setName(name.getName()).build();
        LogServiceProtos.GetLogLastCommittedIndexRequestProto.Builder builder = LogServiceProtos.GetLogLastCommittedIndexRequestProto.newBuilder();
        builder.setLogName(logNameProto);
        return LogServiceProtos.LogServiceRequestProto.newBuilder().setLastIndexQuery(builder.build()).build();
    }

    public static LogServiceProtos.LogServiceRequestProto toGetStartIndexProto(LogName name) {
        LogServiceProtos.LogNameProto logNameProto = LogServiceProtos.LogNameProto.newBuilder().setName(name.getName()).build();
        LogServiceProtos.GetLogStartIndexRequestProto.Builder builder = LogServiceProtos.GetLogStartIndexRequestProto.newBuilder();
        builder.setLogName(logNameProto);
        return LogServiceProtos.LogServiceRequestProto.newBuilder().setStartIndexQuery(builder.build()).build();
    }

    public static LogServiceProtos.LogServiceRequestProto toReadLogRequestProto(LogName name, long start, int total) {
        LogServiceProtos.LogNameProto logNameProto = LogServiceProtos.LogNameProto.newBuilder().setName(name.getName()).build();
        LogServiceProtos.ReadLogRequestProto.Builder builder = LogServiceProtos.ReadLogRequestProto.newBuilder();
        builder.setLogName(logNameProto);
        builder.setStartRecordId(start);
        builder.setNumRecords(total);
        return LogServiceProtos.LogServiceRequestProto.newBuilder().setReadNextQuery(builder.build()).build();
    }

    public static LogServiceProtos.LogServiceRequestProto toSyncLogRequestProto(LogName name) {
        LogServiceProtos.LogNameProto logNameProto = LogServiceProtos.LogNameProto.newBuilder().setName(name.getName()).build();
        LogServiceProtos.SyncLogRequestProto.Builder builder = LogServiceProtos.SyncLogRequestProto.newBuilder();
        builder.setLogName(logNameProto);
        return LogServiceProtos.LogServiceRequestProto.newBuilder().setSyncRequest(builder.build()).build();
    }

    public static LogServiceProtos.LogServiceRequestProto toAppendEntryLogRequestProto(LogName name, List<byte[]> entries) {
        LogServiceProtos.LogNameProto logNameProto = LogServiceProtos.LogNameProto.newBuilder().setName(name.getName()).build();
        LogServiceProtos.AppendLogEntryRequestProto.Builder builder = LogServiceProtos.AppendLogEntryRequestProto.newBuilder();
        builder.setLogName(logNameProto);
        for (int i = 0; i < entries.size(); ++i) {
            builder.addData(ByteString.copyFrom((byte[])entries.get(i)));
        }
        return LogServiceProtos.LogServiceRequestProto.newBuilder().setAppendRequest(builder.build()).build();
    }

    public static LogServiceProtos.LogServiceRequestProto toAppendBBEntryLogRequestProto(LogName name, List<ByteBuffer> entries) {
        LogServiceProtos.LogNameProto logNameProto = LogServiceProtos.LogNameProto.newBuilder().setName(name.getName()).build();
        LogServiceProtos.AppendLogEntryRequestProto.Builder builder = LogServiceProtos.AppendLogEntryRequestProto.newBuilder();
        builder.setLogName(logNameProto);
        for (int i = 0; i < entries.size(); ++i) {
            ByteBuffer currentBuf = entries.get(i);
            int pos = currentBuf.position();
            builder.addData(ByteString.copyFrom((ByteBuffer)currentBuf));
            currentBuf.position(pos);
        }
        return LogServiceProtos.LogServiceRequestProto.newBuilder().setAppendRequest(builder.build()).build();
    }

    public static List<byte[]> toListByteArray(List<ByteString> list) {
        ArrayList<byte[]> retVal = new ArrayList<byte[]>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            retVal.add(list.get(i).toByteArray());
        }
        return retVal;
    }

    public static LogServiceProtos.GetStateReplyProto toGetStateReplyProto(LogStream.State state) {
        return LogServiceProtos.GetStateReplyProto.newBuilder().setState(LogServiceProtos.LogStreamState.valueOf(state.name())).build();
    }

    public static LogServiceProtos.GetLogLengthReplyProto toGetLogLengthReplyProto(long length, Throwable t) {
        LogServiceProtos.GetLogLengthReplyProto.Builder builder = LogServiceProtos.GetLogLengthReplyProto.newBuilder();
        if (t != null) {
            builder.setException(LogServiceProtoUtil.toLogException(t));
        } else {
            builder.setLength(length);
        }
        return builder.build();
    }

    public static LogServiceProtos.GetLogSizeReplyProto toGetLogSizeReplyProto(long size, Throwable t) {
        LogServiceProtos.GetLogSizeReplyProto.Builder builder = LogServiceProtos.GetLogSizeReplyProto.newBuilder();
        if (t != null) {
            builder.setException(LogServiceProtoUtil.toLogException(t));
        } else {
            builder.setSize(size);
        }
        return builder.build();
    }

    public static LogServiceProtos.GetLogStartIndexReplyProto toGetLogStartIndexReplyProto(long length, Throwable t) {
        LogServiceProtos.GetLogStartIndexReplyProto.Builder builder = LogServiceProtos.GetLogStartIndexReplyProto.newBuilder();
        if (t != null) {
            builder.setException(LogServiceProtoUtil.toLogException(t));
        } else {
            builder.setStartIndex(length);
        }
        return builder.build();
    }

    public static LogServiceProtos.GetLogLastCommittedIndexReplyProto toGetLogLastIndexReplyProto(long lastIndex, Throwable t) {
        LogServiceProtos.GetLogLastCommittedIndexReplyProto.Builder builder = LogServiceProtos.GetLogLastCommittedIndexReplyProto.newBuilder();
        if (t != null) {
            builder.setException(LogServiceProtoUtil.toLogException(t));
        } else {
            builder.setLastCommittedIndex(lastIndex);
        }
        return builder.build();
    }

    public static LogServiceProtos.ReadLogReplyProto toReadLogReplyProto(List<byte[]> entries, Throwable t) {
        LogServiceProtos.ReadLogReplyProto.Builder builder = LogServiceProtos.ReadLogReplyProto.newBuilder();
        if (t != null) {
            builder.setException(LogServiceProtoUtil.toLogException(t));
        } else {
            for (byte[] record : entries) {
                builder.addLogRecord(ByteString.copyFrom((byte[])record));
            }
        }
        return builder.build();
    }

    public static LogServiceProtos.AppendLogEntryReplyProto toAppendLogReplyProto(List<Long> ids, Throwable t) {
        LogServiceProtos.AppendLogEntryReplyProto.Builder builder = LogServiceProtos.AppendLogEntryReplyProto.newBuilder();
        if (t != null) {
            builder.setException(LogServiceProtoUtil.toLogException(t));
        } else if (ids != null) {
            for (long id : ids) {
                builder.addRecordId(id);
            }
        }
        return builder.build();
    }

    public static LogServiceProtos.SyncLogReplyProto toSyncLogReplyProto(long index, Throwable t) {
        LogServiceProtos.SyncLogReplyProto.Builder builder = LogServiceProtos.SyncLogReplyProto.newBuilder();
        if (t != null) {
            builder.setException(LogServiceProtoUtil.toLogException(t));
        } else {
            builder.setLastRecordId(index);
        }
        return builder.build();
    }

    public static LogServiceProtos.ArchiveLogRequestProto toExportInfoProto(ArchivalInfo info) {
        return LogServiceProtos.ArchiveLogRequestProto.newBuilder().setIsExport(true).setLastArchivedRaftIndex(info.getLastArchivedIndex()).setLocation(info.getArchiveLocation()).setLogName(LogServiceProtos.LogNameProto.newBuilder().setName(info.getArchiveLogName().getName()).build()).setStatus(LogServiceProtos.ArchivalStatus.valueOf(info.getStatus().name())).build();
    }

    public static ArchivalInfo toExportInfo(LogServiceProtos.ArchiveLogRequestProto proto) {
        return new ArchivalInfo(proto.getLocation()).updateArchivalInfo(proto);
    }

    public LogServiceProtos.GetLogLengthReplyProto toGetLogLengthReplyProto(long length) {
        LogServiceProtos.GetLogLengthReplyProto.Builder builder = LogServiceProtos.GetLogLengthReplyProto.newBuilder();
        builder.setLength(length);
        return builder.build();
    }

    public static LogServiceProtos.LogServiceException toLogException(Throwable t) {
        LogServiceProtos.LogServiceException.Builder builder = LogServiceProtos.LogServiceException.newBuilder();
        builder.setExceptionClassName(t.getClass().getName());
        builder.setErrorMsg(t.getMessage());
        StackTraceElement[] trace = t.getStackTrace();
        StringBuffer buf = new StringBuffer();
        for (StackTraceElement el : trace) {
            buf.append(el.toString()).append("\n");
        }
        String strace = buf.toString();
        builder.setStacktrace(ByteString.copyFrom((String)strace, (Charset)Charset.defaultCharset()));
        return builder.build();
    }

    public static LogServiceProtos.LogServiceRequestProto toExportInfoRequestProto(LogName logName) {
        LogServiceProtos.LogNameProto logNameProto = LogServiceProtos.LogNameProto.newBuilder().setName(logName.getName()).build();
        LogServiceProtos.GetExportInfoRequestProto exportInfoRequestProto = LogServiceProtos.GetExportInfoRequestProto.newBuilder().setLogName(logNameProto).build();
        return LogServiceProtos.LogServiceRequestProto.newBuilder().setExportInfo(exportInfoRequestProto).build();
    }

    public static LogServiceProtos.LogServiceRequestProto toArchiveLogRequestProto(LogName logName, String location, long raftIndex, boolean isArchival, ArchivalInfo.ArchivalStatus status) {
        LogServiceProtos.LogNameProto logNameProto = LogServiceProtos.LogNameProto.newBuilder().setName(logName.getName()).build();
        LogServiceProtos.ArchiveLogRequestProto.Builder builder = LogServiceProtos.ArchiveLogRequestProto.newBuilder().setLogName(logNameProto).setLastArchivedRaftIndex(raftIndex).setStatus(LogServiceProtos.ArchivalStatus.valueOf(status.name()));
        builder.setIsExport(!isArchival);
        if (location != null) {
            builder.setLocation(location);
        }
        LogServiceProtos.ArchiveLogRequestProto archiveLog = builder.build();
        return LogServiceProtos.LogServiceRequestProto.newBuilder().setArchiveLog(archiveLog).build();
    }
}

