/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.logservice.server;

import com.beust.jcommander.JCommander;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.logservice.api.LogServiceConfiguration;
import org.apache.ratis.logservice.common.Constants;
import org.apache.ratis.logservice.server.BaseServer;
import org.apache.ratis.logservice.server.MetaStateMachine;
import org.apache.ratis.logservice.server.ServerOpts;
import org.apache.ratis.logservice.util.LogServiceUtils;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.util.FileUtils;
import org.apache.ratis.util.LifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataServer
extends BaseServer {
    private static final Logger LOG = LoggerFactory.getLogger(MetadataServer.class);
    private RaftServer server;
    private String id;
    private StateMachine metaStateMachine;
    private LifeCycle lifeCycle;

    public StateMachine getMetaStateMachine() {
        return this.metaStateMachine;
    }

    public MetadataServer(ServerOpts opts) {
        super(opts);
        LOG.debug("Metadata Server options: {}", (Object)opts);
        this.id = opts.getHost() + "_" + opts.getPort();
        this.lifeCycle = new LifeCycle((Object)this.id);
    }

    public void start() throws IOException {
        ServerOpts opts = this.getServerOpts();
        if (opts.getHost() == null) {
            opts.setHost(LogServiceUtils.getHostName());
        }
        this.lifeCycle = new LifeCycle((Object)this.id);
        RaftProperties properties = new RaftProperties();
        if (opts.getWorkingDir() != null) {
            RaftServerConfigKeys.setStorageDirs((RaftProperties)properties, Collections.singletonList(new File(opts.getWorkingDir())));
        } else {
            String path = this.getConfig().get("logservice.metaserver.workdir");
            if (path != null) {
                RaftServerConfigKeys.setStorageDirs((RaftProperties)properties, Collections.singletonList(new File(path)));
            }
        }
        this.setRaftProperties(properties);
        long failureDetectionPeriod = this.getConfig().getLong("logservice.peer.failure.detection.period", 60000L);
        Set<RaftPeer> peers = LogServiceUtils.getPeersFromQuorum(opts.getMetaQuorum());
        RaftGroupId raftMetaGroupId = RaftGroupId.valueOf((UUID)opts.getMetaGroupId());
        RaftGroup metaGroup = RaftGroup.valueOf((RaftGroupId)raftMetaGroupId, peers);
        this.metaStateMachine = new MetaStateMachine(raftMetaGroupId, RaftGroupId.valueOf((UUID)opts.getLogServerGroupId()), failureDetectionPeriod);
        this.validateRaftProperties(properties);
        this.server = RaftServer.newBuilder().setGroup(metaGroup).setServerId(RaftPeerId.valueOf((String)this.id)).setStateMachineRegistry(raftGroupId -> {
            if (raftGroupId.equals((Object)Constants.META_GROUP_ID)) {
                return this.metaStateMachine;
            }
            return null;
        }).setProperties(properties).build();
        this.lifeCycle.startAndTransition(() -> this.server.start(), new Class[]{IOException.class});
    }

    public static void main(String[] args) throws IOException {
        ServerOpts opts = new ServerOpts();
        JCommander.newBuilder().addObject((Object)opts).build().parse(args);
        LogServiceConfiguration config = LogServiceConfiguration.create();
        opts = config.addMetaServerOpts(opts);
        try (MetadataServer master = new MetadataServer(opts);){
            master.start();
            try {
                while (true) {
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public void close() throws IOException {
        this.server.close();
    }

    public String getId() {
        return this.id;
    }

    public String getAddress() {
        return this.getServerOpts().getHost() + ":" + this.getServerOpts().getPort();
    }

    public void cleanUp() throws IOException {
        FileUtils.deleteFully((File)new File(this.getServerOpts().getWorkingDir()));
    }

    public RaftServer getServer() {
        return this.server;
    }

    public static class Builder
    extends BaseServer.Builder<MetadataServer> {
        @Override
        public MetadataServer build() {
            this.validate();
            return new MetadataServer(this.getOpts());
        }
    }
}

