/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.logservice.metrics;

import org.apache.ratis.metrics.MetricRegistries;
import org.apache.ratis.metrics.MetricRegistryInfo;
import org.apache.ratis.metrics.RatisMetricRegistry;

public class LogServiceMetricsRegistry {
    public static final String RATIS_LOG_STATEMACHINE_METRICS = "log_statemachine";
    public static final String RATIS_LOG_SERVICE_METRICS = "ratis_log_service";
    public static final String RATIS_LOG_SERVICE_METRICS_DESC = "Ratis log service metrics";
    public static final String RATIS_LOG_SERVICE_META_DATA_METRICS = "metadata_statemachine";
    public static final String RATIS_LOG_SERVICE_META_DATA_METRICS_DESC = "Ratis log service metadata metrics";

    public static RatisMetricRegistry createMetricRegistryForLogService(String logName, String serverId) {
        return LogServiceMetricsRegistry.create(new MetricRegistryInfo(logName + "." + serverId, RATIS_LOG_SERVICE_METRICS, RATIS_LOG_STATEMACHINE_METRICS, RATIS_LOG_SERVICE_METRICS_DESC));
    }

    public static RatisMetricRegistry getMetricRegistryForLogService(String logName, String serverId) {
        return (RatisMetricRegistry)MetricRegistries.global().get(new MetricRegistryInfo(logName + "." + serverId, RATIS_LOG_SERVICE_METRICS, RATIS_LOG_STATEMACHINE_METRICS, RATIS_LOG_SERVICE_METRICS_DESC)).get();
    }

    public static RatisMetricRegistry createMetricRegistryForLogServiceMetaData(String serverId) {
        return LogServiceMetricsRegistry.create(new MetricRegistryInfo(serverId, RATIS_LOG_SERVICE_METRICS, RATIS_LOG_SERVICE_META_DATA_METRICS, RATIS_LOG_SERVICE_META_DATA_METRICS_DESC));
    }

    public static RatisMetricRegistry getMetricRegistryForLogServiceMetaData(String serverId) {
        return (RatisMetricRegistry)MetricRegistries.global().get(new MetricRegistryInfo(serverId, RATIS_LOG_SERVICE_METRICS, RATIS_LOG_SERVICE_META_DATA_METRICS, RATIS_LOG_SERVICE_META_DATA_METRICS_DESC)).get();
    }

    private static RatisMetricRegistry create(MetricRegistryInfo info) {
        RatisMetricRegistry registry = MetricRegistries.global().create(info);
        return registry;
    }
}

