/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.grpc.server;

import java.io.IOException;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.grpc.GrpcConfigKeys;
import org.apache.ratis.grpc.GrpcUtil;
import org.apache.ratis.grpc.server.GrpcServerProtocolClient;
import org.apache.ratis.grpc.server.GrpcService;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.impl.FollowerInfo;
import org.apache.ratis.server.impl.LeaderState;
import org.apache.ratis.server.impl.LogAppender;
import org.apache.ratis.server.impl.RaftServerImpl;
import org.apache.ratis.server.impl.ServerProtoUtils;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.statemachine.SnapshotInfo;
import org.apache.ratis.thirdparty.io.grpc.stub.StreamObserver;
import org.apache.ratis.util.CodeInjectionForTesting;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.TimeDuration;
import org.apache.ratis.util.TimeoutScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcLogAppender
extends LogAppender {
    public static final Logger LOG = LoggerFactory.getLogger(GrpcLogAppender.class);
    private final GrpcService rpcService;
    private final Map<Long, RaftProtos.AppendEntriesRequestProto> pendingRequests;
    private final int maxPendingRequestsNum;
    private long callId = 0L;
    private volatile boolean firstResponseReceived = false;
    private final boolean installSnapshotEnabled;
    private final TimeDuration requestTimeoutDuration;
    private final TimeoutScheduler scheduler = TimeoutScheduler.newInstance((int)1);
    private volatile StreamObserver<RaftProtos.AppendEntriesRequestProto> appendLogRequestObserver;

    public GrpcLogAppender(RaftServerImpl server, LeaderState leaderState, FollowerInfo f) {
        super(server, leaderState, f);
        this.rpcService = (GrpcService)server.getServerRpc();
        this.maxPendingRequestsNum = GrpcConfigKeys.Server.leaderOutstandingAppendsMax(server.getProxy().getProperties());
        this.requestTimeoutDuration = RaftServerConfigKeys.Rpc.requestTimeout((RaftProperties)server.getProxy().getProperties());
        this.pendingRequests = new ConcurrentHashMap<Long, RaftProtos.AppendEntriesRequestProto>();
        this.installSnapshotEnabled = RaftServerConfigKeys.Log.Appender.installSnapshotEnabled((RaftProperties)server.getProxy().getProperties());
    }

    private GrpcServerProtocolClient getClient() throws IOException {
        return (GrpcServerProtocolClient)this.rpcService.getProxies().getProxy(this.getFollowerId());
    }

    private synchronized void resetClient(RaftProtos.AppendEntriesRequestProto request) {
        this.rpcService.getProxies().resetProxy(this.getFollowerId());
        this.appendLogRequestObserver = null;
        this.firstResponseReceived = false;
        long nextIndex = request != null && request.hasPreviousLog() ? request.getPreviousLog().getIndex() + 1L : this.follower.getMatchIndex() + 1L;
        this.pendingRequests.clear();
        this.follower.decreaseNextIndex(nextIndex);
    }

    protected void runAppenderImpl() throws IOException {
        while (this.isAppenderRunning()) {
            boolean shouldAppendLog = true;
            if (this.shouldSendRequest()) {
                if (this.installSnapshotEnabled) {
                    SnapshotInfo snapshot = this.shouldInstallSnapshot();
                    if (snapshot != null) {
                        this.installSnapshot(snapshot);
                        shouldAppendLog = false;
                    }
                } else {
                    TermIndex installSnapshotNotificationTermIndex = this.shouldNotifyToInstallSnapshot();
                    if (installSnapshotNotificationTermIndex != null) {
                        this.installSnapshot(installSnapshotNotificationTermIndex);
                        shouldAppendLog = false;
                    }
                }
                if (shouldAppendLog && !this.shouldWait()) {
                    this.appendLog();
                }
            }
            this.checkSlowness();
            this.mayWait();
        }
        Optional.ofNullable(this.appendLogRequestObserver).ifPresent(StreamObserver::onCompleted);
    }

    private long getWaitTimeMs() {
        if (!this.shouldSendRequest()) {
            return this.getHeartbeatRemainingTime();
        }
        if (this.shouldWait()) {
            return this.halfMinTimeoutMs;
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mayWait() {
        long waitTimeMs = this.getWaitTimeMs();
        if (waitTimeMs <= 0L) {
            return;
        }
        GrpcLogAppender grpcLogAppender = this;
        synchronized (grpcLogAppender) {
            try {
                LOG.trace("{}: wait {}ms", (Object)this, (Object)waitTimeMs);
                ((Object)((Object)this)).wait(waitTimeMs);
            }
            catch (InterruptedException ie) {
                LOG.warn((Object)((Object)this) + ": Wait interrupted by " + ie);
            }
        }
    }

    protected boolean shouldSendRequest() {
        return this.appendLogRequestObserver == null || super.shouldSendRequest();
    }

    private boolean shouldWait() {
        int size = this.pendingRequests.size();
        if (size == 0) {
            return false;
        }
        return !this.firstResponseReceived || size >= this.maxPendingRequestsNum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendLog() throws IOException {
        StreamObserver<RaftProtos.AppendEntriesRequestProto> s;
        RaftProtos.AppendEntriesRequestProto pending;
        GrpcLogAppender grpcLogAppender = this;
        synchronized (grpcLogAppender) {
            pending = this.createRequest(this.callId++);
            if (pending == null) {
                return;
            }
            this.pendingRequests.put(pending.getServerRequest().getCallId(), pending);
            this.increaseNextIndex(pending);
            if (this.appendLogRequestObserver == null) {
                this.appendLogRequestObserver = this.getClient().appendEntries(new AppendLogResponseHandler());
            }
            s = this.appendLogRequestObserver;
        }
        if (this.isAppenderRunning()) {
            this.sendRequest(pending, s);
        }
    }

    private void sendRequest(RaftProtos.AppendEntriesRequestProto request, StreamObserver<RaftProtos.AppendEntriesRequestProto> s) {
        CodeInjectionForTesting.execute((String)GrpcService.GRPC_SEND_SERVER_REQUEST, (Object)this.server.getId(), null, (Object[])new Object[]{request});
        s.onNext((Object)request);
        this.scheduler.onTimeout(this.requestTimeoutDuration, () -> this.timeoutAppendRequest(request), LOG, () -> "Timeout check failed for append entry request: " + request);
        this.follower.updateLastRpcSendTime();
    }

    private void timeoutAppendRequest(RaftProtos.AppendEntriesRequestProto request) {
        RaftProtos.AppendEntriesRequestProto pendingRequest = this.pendingRequests.remove(request.getServerRequest().getCallId());
        if (pendingRequest != null) {
            LOG.warn("{}: appendEntries Timeout, request={}", (Object)this, (Object)ServerProtoUtils.toString((RaftProtos.AppendEntriesRequestProto)pendingRequest));
        }
    }

    private void increaseNextIndex(RaftProtos.AppendEntriesRequestProto request) {
        int count = request.getEntriesCount();
        if (count > 0) {
            this.follower.increaseNextIndex(request.getEntries(count - 1).getIndex() + 1L);
        }
    }

    private boolean checkAndUpdateMatchIndex(RaftProtos.AppendEntriesRequestProto request) {
        int n = request.getEntriesCount();
        long newMatchIndex = n == 0 ? request.getPreviousLog().getIndex() : request.getEntries(n - 1).getIndex();
        return this.follower.updateMatchIndex(newMatchIndex);
    }

    private synchronized void updateNextIndex(long replyNextIndex) {
        this.pendingRequests.clear();
        this.follower.updateNextIndex(replyNextIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installSnapshot(SnapshotInfo snapshot) {
        LOG.info("{}: followerNextIndex = {} but logStartIndex = {}, send snapshot {} to follower", new Object[]{this, this.follower.getNextIndex(), this.raftLog.getStartIndex(), snapshot});
        InstallSnapshotResponseHandler responseHandler = new InstallSnapshotResponseHandler();
        StreamObserver<RaftProtos.InstallSnapshotRequestProto> snapshotRequestObserver = null;
        String requestId = UUID.randomUUID().toString();
        try {
            snapshotRequestObserver = this.getClient().installSnapshot(responseHandler);
            for (RaftProtos.InstallSnapshotRequestProto request : new LogAppender.SnapshotRequestIter((LogAppender)this, snapshot, requestId)) {
                if (!this.isAppenderRunning()) break;
                snapshotRequestObserver.onNext((Object)request);
                this.follower.updateLastRpcSendTime();
                responseHandler.addPending(request);
            }
            snapshotRequestObserver.onCompleted();
        }
        catch (Exception e) {
            LOG.warn("{}: failed to install snapshot {}: {}", new Object[]{this, snapshot.getFiles(), e});
            if (snapshotRequestObserver != null) {
                snapshotRequestObserver.onError((Throwable)e);
            }
            return;
        }
        Object object = this;
        synchronized (object) {
            while (this.isAppenderRunning() && !responseHandler.isDone()) {
                try {
                    ((Object)((Object)this)).wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (responseHandler.hasAllResponse()) {
            this.follower.setSnapshotIndex(snapshot.getTermIndex().getIndex());
            LOG.info("{}: installed snapshot {} successfully", (Object)this, (Object)snapshot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installSnapshot(TermIndex firstAvailableLogTermIndex) {
        LOG.info("{}: followerNextIndex = {} but logStartIndex = {}, notify follower to install snapshot-{}", new Object[]{this, this.follower.getNextIndex(), this.raftLog.getStartIndex(), firstAvailableLogTermIndex});
        InstallSnapshotResponseHandler responseHandler = new InstallSnapshotResponseHandler();
        StreamObserver<RaftProtos.InstallSnapshotRequestProto> snapshotRequestObserver = null;
        RaftProtos.InstallSnapshotRequestProto request = this.createInstallSnapshotNotificationRequest(firstAvailableLogTermIndex);
        if (LOG.isInfoEnabled()) {
            LOG.info("{}: send {}", (Object)this, (Object)ServerProtoUtils.toString((RaftProtos.InstallSnapshotRequestProto)request));
        }
        try {
            snapshotRequestObserver = this.getClient().installSnapshot(responseHandler);
            snapshotRequestObserver.onNext((Object)request);
            this.follower.updateLastRpcSendTime();
            responseHandler.addPending(request);
            snapshotRequestObserver.onCompleted();
        }
        catch (Exception e) {
            GrpcUtil.warn(LOG, () -> (Object)((Object)this) + ": Failed to notify follower to install snapshot.", e);
            if (snapshotRequestObserver != null) {
                snapshotRequestObserver.onError((Throwable)e);
            }
            return;
        }
        GrpcLogAppender grpcLogAppender = this;
        synchronized (grpcLogAppender) {
            if (this.isAppenderRunning() && !responseHandler.isDone()) {
                try {
                    ((Object)((Object)this)).wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private TermIndex shouldNotifyToInstallSnapshot() {
        if (this.follower.getNextIndex() < this.raftLog.getStartIndex()) {
            return this.raftLog.getTermIndex(this.raftLog.getStartIndex());
        }
        return null;
    }

    private class InstallSnapshotResponseHandler
    implements StreamObserver<RaftProtos.InstallSnapshotReplyProto> {
        private final String name;
        private final Queue<Integer> pending;
        private final AtomicBoolean done;

        InstallSnapshotResponseHandler() {
            this.name = GrpcLogAppender.this.follower.getName() + "-" + this.getClass().getSimpleName();
            this.done = new AtomicBoolean(false);
            this.pending = new LinkedList<Integer>();
        }

        synchronized void addPending(RaftProtos.InstallSnapshotRequestProto request) {
            this.pending.offer(request.getSnapshotChunk().getRequestIndex());
        }

        synchronized void removePending(RaftProtos.InstallSnapshotReplyProto reply) {
            Integer index = this.pending.poll();
            Objects.requireNonNull(index, "index == null");
            Preconditions.assertTrue((index.intValue() == reply.getRequestIndex() ? 1 : 0) != 0);
        }

        boolean isDone() {
            return this.done.get();
        }

        void close() {
            this.done.set(true);
            GrpcLogAppender.this.notifyAppend();
        }

        synchronized boolean hasAllResponse() {
            return this.pending.isEmpty();
        }

        public void onNext(RaftProtos.InstallSnapshotReplyProto reply) {
            if (LOG.isInfoEnabled()) {
                LOG.info("{}: received {} reply {}", new Object[]{this, GrpcLogAppender.this.firstResponseReceived ? "a" : "the first", ServerProtoUtils.toString((RaftProtos.InstallSnapshotReplyProto)reply)});
            }
            GrpcLogAppender.this.follower.updateLastRpcResponseTime();
            if (!GrpcLogAppender.this.firstResponseReceived) {
                GrpcLogAppender.this.firstResponseReceived = true;
            }
            switch (reply.getResult()) {
                case SUCCESS: 
                case IN_PROGRESS: {
                    this.removePending(reply);
                    break;
                }
                case ALREADY_INSTALLED: {
                    long followerSnapshotIndex = reply.getSnapshotIndex();
                    LOG.info("{}: set follower snapshotIndex to {}.", (Object)this, (Object)followerSnapshotIndex);
                    GrpcLogAppender.this.follower.setSnapshotIndex(followerSnapshotIndex);
                    this.removePending(reply);
                    break;
                }
                case NOT_LEADER: {
                    GrpcLogAppender.this.checkResponseTerm(reply.getTerm());
                    break;
                }
                case CONF_MISMATCH: {
                    LOG.error("{}: Configuration Mismatch ({}): Leader {} has it set to {} but follower {} has it set to {}", new Object[]{this, "raft.server.log.appender.install.snapshot.enabled", GrpcLogAppender.this.server.getId(), GrpcLogAppender.this.installSnapshotEnabled, GrpcLogAppender.this.getFollowerId(), !GrpcLogAppender.this.installSnapshotEnabled});
                }
            }
        }

        public void onError(Throwable t) {
            if (!GrpcLogAppender.this.isAppenderRunning()) {
                LOG.info("{} is stopped", (Object)this);
                return;
            }
            LOG.error("{}: Failed installSnapshot: {}", (Object)this, (Object)t);
            GrpcLogAppender.this.resetClient(null);
            this.close();
        }

        public void onCompleted() {
            LOG.info("{}: follower responses installSnapshot COMPLETED", (Object)this);
            this.close();
        }

        public String toString() {
            return this.name;
        }
    }

    private class AppendLogResponseHandler
    implements StreamObserver<RaftProtos.AppendEntriesReplyProto> {
        private final String name;

        private AppendLogResponseHandler() {
            this.name = GrpcLogAppender.this.follower.getName() + "-" + this.getClass().getSimpleName();
        }

        public void onNext(RaftProtos.AppendEntriesReplyProto reply) {
            RaftProtos.AppendEntriesRequestProto request = (RaftProtos.AppendEntriesRequestProto)GrpcLogAppender.this.pendingRequests.remove(reply.getServerReply().getCallId());
            if (LOG.isDebugEnabled()) {
                LOG.debug("{}: received {} reply {}, request={}", new Object[]{this, GrpcLogAppender.this.firstResponseReceived ? "a" : "the first", ServerProtoUtils.toString((RaftProtos.AppendEntriesReplyProto)reply), ServerProtoUtils.toString((RaftProtos.AppendEntriesRequestProto)request)});
            }
            try {
                this.onNextImpl(request, reply);
            }
            catch (Throwable t) {
                LOG.error("Failed onNext request=" + ServerProtoUtils.toString((RaftProtos.AppendEntriesRequestProto)request) + ", reply=" + ServerProtoUtils.toString((RaftProtos.AppendEntriesReplyProto)reply), t);
            }
        }

        private void onNextImpl(RaftProtos.AppendEntriesRequestProto request, RaftProtos.AppendEntriesReplyProto reply) {
            GrpcLogAppender.this.follower.updateLastRpcResponseTime();
            if (!GrpcLogAppender.this.firstResponseReceived) {
                GrpcLogAppender.this.firstResponseReceived = true;
            }
            if (request == null) {
                LOG.warn("{}: Request not found, ignoring reply: {}", (Object)this, (Object)ServerProtoUtils.toString((RaftProtos.AppendEntriesReplyProto)reply));
                return;
            }
            switch (reply.getResult()) {
                case SUCCESS: {
                    GrpcLogAppender.this.updateCommitIndex(reply.getFollowerCommit());
                    if (!GrpcLogAppender.this.checkAndUpdateMatchIndex(request)) break;
                    GrpcLogAppender.this.submitEventOnSuccessAppend();
                    break;
                }
                case NOT_LEADER: {
                    if (!GrpcLogAppender.this.checkResponseTerm(reply.getTerm())) break;
                    return;
                }
                case INCONSISTENCY: {
                    GrpcLogAppender.this.updateNextIndex(reply.getNextIndex());
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected reply result: " + reply.getResult());
                }
            }
            GrpcLogAppender.this.notifyAppend();
        }

        public void onError(Throwable t) {
            if (!GrpcLogAppender.this.isAppenderRunning()) {
                LOG.info("{} is stopped", (Object)GrpcLogAppender.this);
                return;
            }
            GrpcUtil.warn(LOG, () -> this + ": Failed appendEntries", t);
            long callId = GrpcUtil.getCallId(t);
            GrpcLogAppender.this.resetClient((RaftProtos.AppendEntriesRequestProto)GrpcLogAppender.this.pendingRequests.remove(callId));
        }

        public void onCompleted() {
            LOG.info("{}: follower responses appendEntries COMPLETED", (Object)this);
            GrpcLogAppender.this.resetClient(null);
        }

        public String toString() {
            return this.name;
        }
    }
}

