/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.grpc.client;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.ratis.client.impl.ClientProtoUtils;
import org.apache.ratis.grpc.GrpcUtil;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.proto.grpc.RaftClientProtocolServiceGrpc;
import org.apache.ratis.protocol.GroupMismatchException;
import org.apache.ratis.protocol.RaftClientAsynchronousProtocol;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftException;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.SetConfigurationRequest;
import org.apache.ratis.thirdparty.io.grpc.stub.StreamObserver;
import org.apache.ratis.util.CollectionUtils;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.SlidingWindow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcClientProtocolService
extends RaftClientProtocolServiceGrpc.RaftClientProtocolServiceImplBase {
    public static final Logger LOG = LoggerFactory.getLogger(GrpcClientProtocolService.class);
    private static final PendingOrderedRequest COMPLETED = new PendingOrderedRequest(null);
    private final Supplier<RaftPeerId> idSupplier;
    private final RaftClientAsynchronousProtocol protocol;
    private final OrderedStreamObservers orderedStreamObservers = new OrderedStreamObservers();
    private final AtomicInteger streamCount = new AtomicInteger();

    public GrpcClientProtocolService(Supplier<RaftPeerId> idSupplier, RaftClientAsynchronousProtocol protocol) {
        this.idSupplier = idSupplier;
        this.protocol = protocol;
    }

    RaftPeerId getId() {
        return this.idSupplier.get();
    }

    public void setConfiguration(RaftProtos.SetConfigurationRequestProto proto, StreamObserver<RaftProtos.RaftClientReplyProto> responseObserver) {
        SetConfigurationRequest request = ClientProtoUtils.toSetConfigurationRequest((RaftProtos.SetConfigurationRequestProto)proto);
        GrpcUtil.asyncCall(responseObserver, () -> this.protocol.setConfigurationAsync(request), ClientProtoUtils::toRaftClientReplyProto);
    }

    public StreamObserver<RaftProtos.RaftClientRequestProto> ordered(StreamObserver<RaftProtos.RaftClientReplyProto> responseObserver) {
        OrderedRequestStreamObserver so = new OrderedRequestStreamObserver(responseObserver);
        this.orderedStreamObservers.putNew(so);
        return so;
    }

    public void closeAllOrderedRequestStreamObservers(RaftGroupId groupId) {
        LOG.debug("{}: closeAllOrderedRequestStreamObservers", (Object)this.getId());
        this.orderedStreamObservers.closeAllExisting(groupId);
    }

    public StreamObserver<RaftProtos.RaftClientRequestProto> unordered(StreamObserver<RaftProtos.RaftClientReplyProto> responseObserver) {
        return new UnorderedRequestStreamObserver(responseObserver);
    }

    private class OrderedRequestStreamObserver
    extends RequestStreamObserver {
        private final SlidingWindow.Server<PendingOrderedRequest, RaftClientReply> slidingWindow;
        private final AtomicReference<RaftGroupId> groupId;

        OrderedRequestStreamObserver(StreamObserver<RaftProtos.RaftClientReplyProto> responseObserver) {
            super(responseObserver);
            this.slidingWindow = new SlidingWindow.Server((Object)this.getName(), (SlidingWindow.ServerSideRequest)COMPLETED);
            this.groupId = new AtomicReference();
        }

        RaftGroupId getGroupId() {
            return this.groupId.get();
        }

        void processClientRequest(PendingOrderedRequest pending) {
            long seq = pending.getSeqNum();
            this.processClientRequest(pending.getRequest(), reply -> this.slidingWindow.receiveReply(seq, reply, this::sendReply));
        }

        @Override
        void processClientRequest(RaftClientRequest r) {
            RaftGroupId requestGroupId = r.getRaftGroupId();
            RaftGroupId updated = this.groupId.updateAndGet(g -> g != null ? g : requestGroupId);
            PendingOrderedRequest pending = new PendingOrderedRequest(r);
            if (!requestGroupId.equals((Object)updated)) {
                GroupMismatchException exception = new GroupMismatchException(this.getId() + ": The group (" + requestGroupId + ") of " + r.getClientId() + " does not match the group (" + updated + ") of the " + this.getClass().getSimpleName());
                this.responseError((Throwable)exception, () -> "processClientRequest (Group mismatched) for " + r);
                return;
            }
            this.slidingWindow.receivedRequest((SlidingWindow.ServerSideRequest)pending, this::processClientRequest);
        }

        private void sendReply(PendingOrderedRequest ready) {
            Preconditions.assertTrue((boolean)ready.hasReply());
            if (ready == COMPLETED) {
                this.close(true);
            } else {
                LOG.debug("{}: sendReply seq={}, {}", new Object[]{this.getName(), ready.getSeqNum(), ready.getReply()});
                this.responseNext(ClientProtoUtils.toRaftClientReplyProto((RaftClientReply)ready.getReply()));
            }
        }

        @Override
        public void onError(Throwable t) {
            GrpcUtil.warn(LOG, () -> this.getName() + ": onError", t);
            this.close(false);
        }

        public void onCompleted() {
            if (this.slidingWindow.endOfRequests(this::sendReply)) {
                this.close(true);
            }
        }

        private void close(boolean complete) {
            if (this.setClose()) {
                LOG.debug("{}: close", (Object)this.getName());
                if (complete) {
                    this.responseCompleted();
                }
                this.cleanup();
            }
        }

        private void cleanup() {
            this.slidingWindow.close();
            GrpcClientProtocolService.this.orderedStreamObservers.removeExisting(this);
        }

        @Override
        boolean responseError(Throwable t, Supplier<String> message) {
            if (super.responseError(t, message)) {
                this.cleanup();
                return true;
            }
            return false;
        }
    }

    private class UnorderedRequestStreamObserver
    extends RequestStreamObserver {
        private final Map<Long, CompletableFuture<Void>> futures;

        UnorderedRequestStreamObserver(StreamObserver<RaftProtos.RaftClientReplyProto> responseObserver) {
            super(responseObserver);
            this.futures = new HashMap<Long, CompletableFuture<Void>>();
        }

        @Override
        void processClientRequest(RaftClientRequest request) {
            CompletableFuture<Void> f = this.processClientRequest(request, reply -> {
                if (!reply.isSuccess()) {
                    LOG.info("Failed " + request + ", reply=" + reply);
                }
                RaftProtos.RaftClientReplyProto proto = ClientProtoUtils.toRaftClientReplyProto((RaftClientReply)reply);
                this.responseNext(proto);
            });
            long callId = request.getCallId();
            this.put(callId, f);
            f.thenAccept(dummy -> this.remove(callId));
        }

        private synchronized void put(long callId, CompletableFuture<Void> f) {
            this.futures.put(callId, f);
        }

        private synchronized void remove(long callId) {
            this.futures.remove(callId);
        }

        private synchronized CompletableFuture<Void> allOfFutures() {
            return JavaUtils.allOf(this.futures.values());
        }

        public void onCompleted() {
            this.allOfFutures().thenAccept(dummy -> {
                if (this.setClose()) {
                    LOG.debug("{}: close", (Object)this.getName());
                    this.responseCompleted();
                }
            });
        }
    }

    private abstract class RequestStreamObserver
    implements StreamObserver<RaftProtos.RaftClientRequestProto> {
        private final int id;
        private final String name;
        private final StreamObserver<RaftProtos.RaftClientReplyProto> responseObserver;
        private final AtomicBoolean isClosed;

        RequestStreamObserver(StreamObserver<RaftProtos.RaftClientReplyProto> responseObserver) {
            this.id = GrpcClientProtocolService.this.streamCount.getAndIncrement();
            this.name = this.getId() + "-" + this.getClass().getSimpleName() + this.id;
            this.isClosed = new AtomicBoolean();
            LOG.debug("new {}", (Object)this.name);
            this.responseObserver = responseObserver;
        }

        int getId() {
            return this.id;
        }

        String getName() {
            return this.name;
        }

        synchronized void responseNext(RaftProtos.RaftClientReplyProto reply) {
            this.responseObserver.onNext((Object)reply);
        }

        synchronized void responseCompleted() {
            block2: {
                try {
                    this.responseObserver.onCompleted();
                }
                catch (Exception e) {
                    if (!LOG.isTraceEnabled()) break block2;
                    LOG.trace(this.getName() + ": Failed onCompleted, exception is ignored", (Throwable)e);
                }
            }
        }

        synchronized void responseError(Throwable t) {
            block2: {
                try {
                    this.responseObserver.onError(t);
                }
                catch (Exception e) {
                    if (!LOG.isTraceEnabled()) break block2;
                    LOG.trace(this.getName() + ": Failed onError, exception is ignored", (Throwable)e);
                }
            }
        }

        boolean setClose() {
            return this.isClosed.compareAndSet(false, true);
        }

        CompletableFuture<Void> processClientRequest(RaftClientRequest request, Consumer<RaftClientReply> replyHandler) {
            try {
                return ((CompletableFuture)GrpcClientProtocolService.this.protocol.submitClientRequestAsync(request).thenAcceptAsync(replyHandler)).exceptionally(exception -> {
                    this.responseError((Throwable)exception, () -> "processClientRequest for " + request);
                    return null;
                });
            }
            catch (IOException e) {
                throw new CompletionException("Failed processClientRequest for " + request + " in " + this.name, e);
            }
        }

        abstract void processClientRequest(RaftClientRequest var1);

        public void onNext(RaftProtos.RaftClientRequestProto request) {
            try {
                RaftClientRequest r = ClientProtoUtils.toRaftClientRequest((RaftProtos.RaftClientRequestProto)request);
                this.processClientRequest(r);
            }
            catch (Throwable e) {
                this.responseError(e, () -> "onNext for " + ClientProtoUtils.toString((RaftProtos.RaftClientRequestProto)request) + " in " + this.name);
            }
        }

        public void onError(Throwable t) {
            GrpcUtil.warn(LOG, () -> this.name + ": onError", t);
        }

        boolean responseError(Throwable t, Supplier<String> message) {
            if (this.setClose()) {
                t = JavaUtils.unwrapCompletionException((Throwable)t);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(this.name + ": Failed " + message.get(), t);
                }
                this.responseError((Throwable)GrpcUtil.wrapException(t));
                return true;
            }
            return false;
        }
    }

    static class OrderedStreamObservers {
        private final Map<Integer, OrderedRequestStreamObserver> map = new ConcurrentHashMap<Integer, OrderedRequestStreamObserver>();

        OrderedStreamObservers() {
        }

        void putNew(OrderedRequestStreamObserver so) {
            CollectionUtils.putNew((Object)so.getId(), (Object)so, this.map, () -> this.getClass().getSimpleName());
        }

        void removeExisting(OrderedRequestStreamObserver so) {
            CollectionUtils.removeExisting((Object)so.getId(), (Object)so, this.map, () -> this.getClass().getSimpleName());
        }

        void closeAllExisting(RaftGroupId groupId) {
            Iterator<Map.Entry<Integer, OrderedRequestStreamObserver>> i = this.map.entrySet().iterator();
            while (i.hasNext()) {
                OrderedRequestStreamObserver so = i.next().getValue();
                RaftGroupId gid = so.getGroupId();
                if (gid != null && !gid.equals((Object)groupId)) continue;
                so.close(true);
                i.remove();
            }
        }
    }

    private static class PendingOrderedRequest
    implements SlidingWindow.ServerSideRequest<RaftClientReply> {
        private final RaftClientRequest request;
        private final AtomicReference<RaftClientReply> reply = new AtomicReference();

        PendingOrderedRequest(RaftClientRequest request) {
            this.request = request;
        }

        public void fail(Throwable t) {
            Preconditions.assertTrue((boolean)(t instanceof RaftException), () -> "Requires RaftException but " + t);
            this.setReply(new RaftClientReply(this.request, (RaftException)t, null));
        }

        public boolean hasReply() {
            return this.getReply() != null || this == COMPLETED;
        }

        public void setReply(RaftClientReply r) {
            boolean set = this.reply.compareAndSet(null, r);
            Preconditions.assertTrue((boolean)set, () -> "Reply is already set: request=" + this.request + ", reply=" + this.reply);
        }

        RaftClientReply getReply() {
            return this.reply.get();
        }

        RaftClientRequest getRequest() {
            return this.request;
        }

        public long getSeqNum() {
            return this.request != null ? this.request.getSlidingWindowEntry().getSeqNum() : Long.MAX_VALUE;
        }

        public boolean isFirstRequest() {
            return this.request != null && this.request.getSlidingWindowEntry().getIsFirst();
        }

        public String toString() {
            return this.request != null ? this.getSeqNum() + ":" + this.reply : "COMPLETED";
        }
    }
}

