/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.statemachine.impl;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.ratis.io.MD5Hash;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.server.storage.FileInfo;
import org.apache.ratis.server.storage.RaftStorage;
import org.apache.ratis.statemachine.StateMachineStorage;
import org.apache.ratis.statemachine.impl.FileListSnapshotInfo;
import org.apache.ratis.statemachine.impl.SingleFileSnapshotInfo;
import org.apache.ratis.statemachine.impl.SnapshotFileComparator;
import org.apache.ratis.statemachine.impl.SnapshotRetentionPolicy;
import org.apache.ratis.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.ratis.util.MD5FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleStateMachineStorage
implements StateMachineStorage {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleStateMachineStorage.class);
    static final String SNAPSHOT_FILE_PREFIX = "snapshot";
    static final String CORRUPT_SNAPSHOT_FILE_SUFFIX = ".corrupt";
    public static final Pattern SNAPSHOT_REGEX = Pattern.compile("snapshot\\.(\\d+)_(\\d+)");
    private RaftStorage raftStorage;
    private File smDir = null;
    private volatile SingleFileSnapshotInfo currentSnapshot = null;

    @Override
    public void init(RaftStorage raftStorage) throws IOException {
        this.raftStorage = raftStorage;
        this.smDir = raftStorage.getStorageDir().getStateMachineDir();
        this.loadLatestSnapshot();
    }

    @Override
    public void format() throws IOException {
    }

    @Override
    public void cleanupOldSnapshots(SnapshotRetentionPolicy snapshotRetentionPolicy) throws IOException {
        if (snapshotRetentionPolicy != null && snapshotRetentionPolicy.getNumSnapshotsRetained() > 0) {
            ArrayList<SingleFileSnapshotInfo> allSnapshotFiles = new ArrayList<SingleFileSnapshotInfo>();
            DirectoryStream<Path> stream = Files.newDirectoryStream(this.smDir.toPath());
            Object object = null;
            try {
                for (Path path : stream) {
                    Matcher matcher = SNAPSHOT_REGEX.matcher(path.getFileName().toString());
                    if (!matcher.matches()) continue;
                    long endIndex = Long.parseLong(matcher.group(2));
                    long term = Long.parseLong(matcher.group(1));
                    FileInfo fileInfo = new FileInfo(path, null);
                    allSnapshotFiles.add(new SingleFileSnapshotInfo(fileInfo, term, endIndex));
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (stream != null) {
                    if (object != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        stream.close();
                    }
                }
            }
            if (allSnapshotFiles.size() > snapshotRetentionPolicy.getNumSnapshotsRetained()) {
                allSnapshotFiles.sort(new SnapshotFileComparator());
                List snapshotFilesToBeCleaned = allSnapshotFiles.subList(snapshotRetentionPolicy.getNumSnapshotsRetained(), allSnapshotFiles.size()).stream().map(singleFileSnapshotInfo -> singleFileSnapshotInfo.getFile().getPath().toFile()).collect(Collectors.toList());
                for (File snapshotFile : snapshotFilesToBeCleaned) {
                    LOG.info("Deleting old snapshot at {}", (Object)snapshotFile.getAbsolutePath());
                    FileUtils.deleteQuietly((File)snapshotFile);
                }
            }
        }
    }

    public static TermIndex getTermIndexFromSnapshotFile(File file) {
        String name = file.getName();
        Matcher m = SNAPSHOT_REGEX.matcher(name);
        if (!m.matches()) {
            throw new IllegalArgumentException("File \"" + file + "\" does not match snapshot file name pattern \"" + SNAPSHOT_REGEX + "\"");
        }
        long term = Long.parseLong(m.group(1));
        long index = Long.parseLong(m.group(2));
        return TermIndex.newTermIndex(term, index);
    }

    protected static String getTmpSnapshotFileName(long term, long endIndex) {
        return SimpleStateMachineStorage.getSnapshotFileName(term, endIndex) + ".tmp";
    }

    protected static String getCorruptSnapshotFileName(long term, long endIndex) {
        return SimpleStateMachineStorage.getSnapshotFileName(term, endIndex) + CORRUPT_SNAPSHOT_FILE_SUFFIX;
    }

    public File getSnapshotFile(long term, long endIndex) {
        return new File(this.smDir, SimpleStateMachineStorage.getSnapshotFileName(term, endIndex));
    }

    protected File getTmpSnapshotFile(long term, long endIndex) {
        return new File(this.smDir, SimpleStateMachineStorage.getTmpSnapshotFileName(term, endIndex));
    }

    protected File getCorruptSnapshotFile(long term, long endIndex) {
        return new File(this.smDir, SimpleStateMachineStorage.getCorruptSnapshotFileName(term, endIndex));
    }

    public SingleFileSnapshotInfo findLatestSnapshot() throws IOException {
        FileListSnapshotInfo latest = null;
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.smDir.toPath());){
            for (Path path : stream) {
                Matcher matcher = SNAPSHOT_REGEX.matcher(path.getFileName().toString());
                if (!matcher.matches()) continue;
                long endIndex = Long.parseLong(matcher.group(2));
                if (latest != null && endIndex <= latest.getIndex()) continue;
                long term = Long.parseLong(matcher.group(1));
                MD5Hash fileDigest = MD5FileUtil.readStoredMd5ForFile((File)path.toFile());
                FileInfo fileInfo = new FileInfo(path, fileDigest);
                latest = new SingleFileSnapshotInfo(fileInfo, term, endIndex);
            }
        }
        return latest;
    }

    public void loadLatestSnapshot() throws IOException {
        this.currentSnapshot = this.findLatestSnapshot();
    }

    public static String getSnapshotFileName(long term, long endIndex) {
        return "snapshot." + term + "_" + endIndex;
    }

    @Override
    public SingleFileSnapshotInfo getLatestSnapshot() {
        return this.currentSnapshot;
    }

    @VisibleForTesting
    public File getSmDir() {
        return this.smDir;
    }
}

