/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.raftlog.segmented;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.zip.Checksum;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.server.raftlog.segmented.BufferedWriteChannel;
import org.apache.ratis.server.raftlog.segmented.SegmentedRaftLogFormat;
import org.apache.ratis.thirdparty.com.google.protobuf.CodedOutputStream;
import org.apache.ratis.util.FileUtils;
import org.apache.ratis.util.IOUtils;
import org.apache.ratis.util.PureJavaCrc32C;
import org.apache.ratis.util.function.CheckedConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentedRaftLogOutputStream
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(SegmentedRaftLogOutputStream.class);
    private static final ByteBuffer fill = ByteBuffer.allocateDirect(0x100000);
    private static final int BUFFER_SIZE = 0x100000;
    private File file;
    private FileChannel fc;
    private BufferedWriteChannel out;
    private final Checksum checksum;
    private final long segmentMaxSize;
    private final long preallocatedSize;
    private long preallocatedPos;

    public SegmentedRaftLogOutputStream(File file, boolean append, long segmentMaxSize, long preallocatedSize, int bufferSize) throws IOException {
        this.file = file;
        this.checksum = new PureJavaCrc32C();
        this.segmentMaxSize = segmentMaxSize;
        this.preallocatedSize = preallocatedSize;
        RandomAccessFile rp = new RandomAccessFile(file, "rw");
        try {
            this.fc = rp.getChannel();
            this.fc.position(this.fc.size());
            this.preallocatedPos = this.fc.size();
            this.out = new BufferedWriteChannel(this.fc, bufferSize);
            if (!append) {
                this.create();
            }
        }
        catch (IOException ioe) {
            LOG.warn("Hit IOException while creating log segment " + file + ", delete the partial file.");
            try {
                FileUtils.deleteFully((File)file);
            }
            catch (IOException e) {
                LOG.warn("Failed to delete the file " + file, (Throwable)e);
            }
            throw ioe;
        }
    }

    public void write(RaftProtos.LogEntryProto entry) throws IOException {
        int serialized = entry.getSerializedSize();
        int bufferSize = CodedOutputStream.computeUInt32SizeNoTag((int)serialized) + serialized;
        this.preallocateIfNecessary(bufferSize + 4);
        byte[] buf = new byte[bufferSize];
        CodedOutputStream cout = CodedOutputStream.newInstance((byte[])buf);
        cout.writeUInt32NoTag(serialized);
        entry.writeTo(cout);
        this.checksum.reset();
        this.checksum.update(buf, 0, buf.length);
        int sum = (int)this.checksum.getValue();
        this.out.write(buf);
        this.writeInt(sum);
    }

    private void writeInt(int v) throws IOException {
        this.out.write(v >>> 24 & 0xFF);
        this.out.write(v >>> 16 & 0xFF);
        this.out.write(v >>> 8 & 0xFF);
        this.out.write(v & 0xFF);
    }

    private void create() throws IOException {
        this.fc.truncate(0L);
        this.fc.position(0L);
        this.preallocatedPos = 0L;
        this.preallocate();
        SegmentedRaftLogFormat.applyHeaderTo(CheckedConsumer.asCheckedFunction(this.out::write));
        this.flush();
    }

    @Override
    public void close() throws IOException {
        try {
            this.out.flush();
            if (this.fc != null && this.fc.isOpen()) {
                this.fc.truncate(this.fc.position());
            }
        }
        catch (Throwable throwable) {
            IOUtils.cleanup((Logger)LOG, (Closeable[])new Closeable[]{this.fc, this.out});
            this.fc = null;
            this.out = null;
            throw throwable;
        }
        IOUtils.cleanup((Logger)LOG, (Closeable[])new Closeable[]{this.fc, this.out});
        this.fc = null;
        this.out = null;
    }

    public void flush() throws IOException {
        if (this.out == null) {
            throw new IOException("Trying to use aborted output stream");
        }
        this.out.flush();
    }

    private void preallocate() throws IOException {
        fill.position(0);
        long targetSize = Math.min(this.segmentMaxSize - this.fc.size(), this.preallocatedSize);
        int allocated = 0;
        while ((long)allocated < targetSize) {
            int size = (int)Math.min(0x100000L, targetSize - (long)allocated);
            ByteBuffer buffer = fill.slice();
            buffer.limit(size);
            IOUtils.writeFully((FileChannel)this.fc, (ByteBuffer)buffer, (long)this.preallocatedPos);
            this.preallocatedPos += (long)size;
            allocated += size;
        }
        LOG.debug("Pre-allocated {} bytes for the log segment", (Object)allocated);
    }

    private void preallocateIfNecessary(int size) throws IOException {
        if (this.out.position() + (long)size > this.preallocatedPos) {
            this.preallocate();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.file + ")";
    }

    static {
        fill.position(0);
        for (int i = 0; i < fill.capacity(); ++i) {
            fill.put(SegmentedRaftLogFormat.getTerminator());
        }
    }
}

