/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.metrics;

import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.ratis.metrics.JVMMetrics;
import org.apache.ratis.metrics.MetricRegistries;
import org.apache.ratis.metrics.MetricRegistryInfo;
import org.apache.ratis.metrics.MetricsReporting;
import org.apache.ratis.metrics.RatisMetricRegistry;

public class RatisMetrics {
    public static final String RATIS_LOG_WORKER_METRICS_DESC = "Ratis metrics";
    public static final String RATIS_LOG_WORKER_METRICS = "ratis_log_worker";
    public static final String RATIS_APPLICATION_NAME_METRICS = "ratis_core";
    public static final String RATIS_LEADER_ELECTION_METRICS = "leader_election";
    public static final String RATIS_LEADER_ELECTION_METRICS_DESC = "Metrics for Ratis Leader Election.";
    public static final String RATIS_HEARTBEAT_METRICS = "heartbeat";
    public static final String RATIS_HEARTBEAT_METRICS_DESC = "Metrics for Ratis Heartbeat.";
    static MetricsReporting metricsReporting = new MetricsReporting(500L, TimeUnit.MILLISECONDS);

    public static RatisMetricRegistry createMetricRegistryForLogWorker(String name) {
        return RatisMetrics.create(new MetricRegistryInfo(name, RATIS_APPLICATION_NAME_METRICS, RATIS_LOG_WORKER_METRICS, RATIS_LOG_WORKER_METRICS_DESC));
    }

    public static RatisMetricRegistry getMetricRegistryForLogWorker(String name) {
        return (RatisMetricRegistry)MetricRegistries.global().get(new MetricRegistryInfo(name, RATIS_APPLICATION_NAME_METRICS, RATIS_LOG_WORKER_METRICS, RATIS_LOG_WORKER_METRICS_DESC)).get();
    }

    private static RatisMetricRegistry create(MetricRegistryInfo info) {
        Optional metricRegistry = MetricRegistries.global().get(info);
        if (metricRegistry.isPresent()) {
            return (RatisMetricRegistry)metricRegistry.get();
        }
        RatisMetricRegistry registry = MetricRegistries.global().create(info);
        metricsReporting.startMetricsReporter(registry, new MetricsReporting.MetricReporterType[]{MetricsReporting.MetricReporterType.JMX, MetricsReporting.MetricReporterType.HADOOP2});
        JVMMetrics.startJVMReporting((long)1000L, (TimeUnit)TimeUnit.MILLISECONDS, (MetricsReporting.MetricReporterType[])new MetricsReporting.MetricReporterType[]{MetricsReporting.MetricReporterType.JMX});
        return registry;
    }

    public static RatisMetricRegistry getMetricRegistryForLeaderElection(String serverId) {
        return RatisMetrics.create(new MetricRegistryInfo(serverId, RATIS_APPLICATION_NAME_METRICS, RATIS_LEADER_ELECTION_METRICS, RATIS_LEADER_ELECTION_METRICS_DESC));
    }

    public static RatisMetricRegistry getMetricRegistryForHeartbeat(String serverId) {
        return RatisMetrics.create(new MetricRegistryInfo(serverId, RATIS_APPLICATION_NAME_METRICS, RATIS_HEARTBEAT_METRICS, RATIS_HEARTBEAT_METRICS_DESC));
    }
}

