/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.metrics;

import org.apache.ratis.metrics.RatisMetricRegistry;
import org.apache.ratis.server.impl.RaftServerImpl;
import org.apache.ratis.server.metrics.RatisMetrics;

public final class LeaderElectionMetrics {
    private long leaderElectionCompletionLatency = 0L;
    private RatisMetricRegistry ratisMetricRegistry;

    private LeaderElectionMetrics(RaftServerImpl raftServer) {
        this.ratisMetricRegistry = RatisMetrics.getMetricRegistryForLeaderElection(raftServer.getMemberId().toString());
        this.ratisMetricRegistry.gauge("leader_election_latency", () -> () -> this.leaderElectionCompletionLatency);
        this.ratisMetricRegistry.gauge("last_leader_elapsed_time", () -> () -> raftServer.getState().getLastLeaderElapsedTimeMs());
    }

    public static LeaderElectionMetrics getLeaderElectionMetrics(RaftServerImpl raftServer) {
        return new LeaderElectionMetrics(raftServer);
    }

    public void onNewLeaderElection() {
        this.ratisMetricRegistry.counter("leader_election_count").inc();
    }

    public void onLeaderElectionCompletion(long elapsedTime) {
        this.leaderElectionCompletionLatency = elapsedTime;
    }

    public void onLeaderElectionTimeout() {
        this.ratisMetricRegistry.counter("leader_election_timeout_count").inc();
    }
}

