/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.metrics;

import java.util.HashMap;
import java.util.Map;
import org.apache.ratis.metrics.RatisMetricRegistry;
import org.apache.ratis.server.impl.RaftServerImpl;
import org.apache.ratis.server.metrics.RatisMetrics;

public final class HeartbeatMetrics {
    private RatisMetricRegistry registry = null;
    private Map<String, Long> followerLastHeartbeatElapsedTimeMap = new HashMap<String, Long>();

    public static HeartbeatMetrics getHeartbeatMetrics(RaftServerImpl raftServer) {
        return new HeartbeatMetrics(raftServer.getMemberId().toString());
    }

    private HeartbeatMetrics(String serverId) {
        this.registry = RatisMetrics.getMetricRegistryForHeartbeat(serverId);
    }

    public void addFollower(String followerName) {
        String followerMetricKey = String.format("follower_%s_last_heartbeat_elapsed_time", followerName);
        this.followerLastHeartbeatElapsedTimeMap.put(followerName, 0L);
        this.registry.gauge(followerMetricKey, () -> () -> this.followerLastHeartbeatElapsedTimeMap.get(followerName));
    }

    public void recordFollowerHeartbeatElapsedTime(String followerName, long elapsedTime) {
        this.followerLastHeartbeatElapsedTimeMap.put(followerName, elapsedTime);
    }
}

