/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.NotLeaderException;
import org.apache.ratis.protocol.NotReplicatedException;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftException;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.ReconfigurationTimeoutException;
import org.apache.ratis.protocol.SetConfigurationRequest;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.impl.CommitInfoCache;
import org.apache.ratis.server.impl.FollowerInfo;
import org.apache.ratis.server.impl.LogAppender;
import org.apache.ratis.server.impl.PeerConfiguration;
import org.apache.ratis.server.impl.PendingRequest;
import org.apache.ratis.server.impl.PendingRequests;
import org.apache.ratis.server.impl.RaftConfiguration;
import org.apache.ratis.server.impl.RaftServerImpl;
import org.apache.ratis.server.impl.ServerProtoUtils;
import org.apache.ratis.server.impl.ServerState;
import org.apache.ratis.server.impl.WatchRequests;
import org.apache.ratis.server.metrics.HeartbeatMetrics;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.server.raftlog.RaftLog;
import org.apache.ratis.statemachine.TransactionContext;
import org.apache.ratis.util.CodeInjectionForTesting;
import org.apache.ratis.util.CollectionUtils;
import org.apache.ratis.util.Daemon;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.TimeDuration;
import org.apache.ratis.util.Timestamp;
import org.slf4j.Logger;

public class LeaderState {
    private static final Logger LOG = RaftServerImpl.LOG;
    public static final String APPEND_PLACEHOLDER = LeaderState.class.getSimpleName() + ".placeholder";
    private final StateUpdateEvent UPDATE_COMMIT_EVENT = new StateUpdateEvent(StateUpdateEvent.Type.UPDATE_COMMIT, -1L, this::updateCommit);
    private final StateUpdateEvent CHECK_STAGING_EVENT = new StateUpdateEvent(StateUpdateEvent.Type.CHECK_STAGING, -1L, this::checkStaging);
    private final RaftServerImpl server;
    private final RaftLog raftLog;
    private final long currentTerm;
    private volatile ConfigurationStagingState stagingState;
    private List<List<FollowerInfo>> voterLists;
    private final SenderList senders;
    private final EventQueue eventQueue = new EventQueue();
    private final EventProcessor processor;
    private final PendingRequests pendingRequests;
    private final WatchRequests watchRequests;
    private volatile boolean running = true;
    private final int stagingCatchupGap;
    private final TimeDuration syncInterval;
    private final long placeHolderIndex;
    private final HeartbeatMetrics heartbeatMetrics;

    LeaderState(RaftServerImpl server, RaftProperties properties) {
        this.server = server;
        this.stagingCatchupGap = RaftServerConfigKeys.stagingCatchupGap(properties);
        this.syncInterval = RaftServerConfigKeys.Rpc.sleepTime(properties);
        ServerState state = server.getState();
        this.raftLog = state.getLog();
        this.currentTerm = state.getCurrentTerm();
        this.processor = new EventProcessor();
        this.pendingRequests = new PendingRequests(server.getId(), properties);
        this.watchRequests = new WatchRequests(server.getId(), properties);
        RaftConfiguration conf = server.getRaftConf();
        Collection<RaftPeer> others = conf.getOtherPeers(server.getId());
        this.placeHolderIndex = this.raftLog.getNextIndex();
        this.senders = new SenderList();
        this.heartbeatMetrics = HeartbeatMetrics.getHeartbeatMetrics(server);
        this.addSenders(others, this.placeHolderIndex, true);
        this.voterLists = this.divideFollowers(conf);
    }

    RaftProtos.LogEntryProto start() {
        RaftProtos.LogEntryProto placeHolder = ServerProtoUtils.toLogEntryProto(this.server.getRaftConf(), this.server.getState().getCurrentTerm(), this.raftLog.getNextIndex());
        CodeInjectionForTesting.execute((String)APPEND_PLACEHOLDER, (Object)this.server.getId().toString(), null, (Object[])new Object[0]);
        this.raftLog.append(placeHolder);
        this.server.getStateMachine().notifyLeader(this.raftLog.getLastCommittedIndex());
        this.processor.start();
        this.senders.forEach(LogAppender::startAppender);
        return placeHolder;
    }

    boolean isReady() {
        return this.server.getState().getLastAppliedIndex() >= this.placeHolderIndex;
    }

    void stop() {
        this.running = false;
        this.senders.forEach(LogAppender::stopAppender);
        NotLeaderException nle = this.server.generateNotLeaderException();
        Collection<RaftProtos.CommitInfoProto> commitInfos = this.server.getCommitInfos();
        try {
            Collection<TransactionContext> transactions = this.pendingRequests.sendNotLeaderResponses(nle, commitInfos);
            this.server.getStateMachine().notifyNotLeader(transactions);
            this.watchRequests.failWatches((Exception)nle);
        }
        catch (IOException e) {
            LOG.warn(this.server.getId() + ": Caught exception in sendNotLeaderResponses", (Throwable)e);
        }
        this.server.getServerRpc().notifyNotLeader(this.server.getGroupId());
    }

    void notifySenders() {
        this.senders.forEach(LogAppender::notifyAppend);
    }

    boolean inStagingState() {
        return this.stagingState != null;
    }

    long getCurrentTerm() {
        return this.currentTerm;
    }

    TimeDuration getSyncInterval() {
        return this.syncInterval;
    }

    PendingRequest startSetConfiguration(SetConfigurationRequest request) {
        Preconditions.assertTrue((this.running && !this.inStagingState() ? 1 : 0) != 0);
        List peersInNewConf = request.getPeersInNewConf();
        Collection<RaftPeer> peersToBootStrap = this.server.getRaftConf().filterNotContainedInConf(peersInNewConf);
        PendingRequest pending = this.pendingRequests.addConfRequest(request);
        ConfigurationStagingState stagingState = new ConfigurationStagingState(peersToBootStrap, new PeerConfiguration(peersInNewConf));
        Collection<RaftPeer> newPeers = stagingState.getNewPeers();
        this.stagingState = stagingState;
        if (newPeers.isEmpty()) {
            this.applyOldNewConf();
        } else {
            this.addAndStartSenders(newPeers);
        }
        return pending;
    }

    PendingRequests.Permit tryAcquirePendingRequest() {
        return this.pendingRequests.tryAcquire();
    }

    PendingRequest addPendingRequest(PendingRequests.Permit permit, RaftClientRequest request, TransactionContext entry) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}: addPendingRequest at {}, entry=", new Object[]{this.server.getId(), request, ServerProtoUtils.toLogEntryString(entry.getLogEntry())});
        }
        return this.pendingRequests.add(permit, request, entry);
    }

    CompletableFuture<RaftClientReply> addWatchReqeust(RaftClientRequest request) {
        LOG.debug("{}: addWatchRequest {}", (Object)this.server.getId(), (Object)request);
        return ((CompletableFuture)this.watchRequests.add(request).thenApply(v -> new RaftClientReply(request, this.server.getCommitInfos()))).exceptionally(e -> {
            if ((e = JavaUtils.unwrapCompletionException((Throwable)e)) instanceof NotReplicatedException) {
                return new RaftClientReply(request, (NotReplicatedException)e, this.server.getCommitInfos());
            }
            if (e instanceof NotLeaderException) {
                return new RaftClientReply(request, (RaftException)((NotLeaderException)e), this.server.getCommitInfos());
            }
            throw new CompletionException((Throwable)e);
        });
    }

    void commitIndexChanged() {
        this.getMajorityMin(FollowerInfo::getCommitIndex, this.raftLog::getLastCommittedIndex).ifPresent(m -> {
            this.watchRequests.update(RaftProtos.ReplicationLevel.ALL_COMMITTED, ((MinMajorityMax)m).min);
            this.watchRequests.update(RaftProtos.ReplicationLevel.MAJORITY_COMMITTED, ((MinMajorityMax)m).majority);
            this.watchRequests.update(RaftProtos.ReplicationLevel.MAJORITY, ((MinMajorityMax)m).max);
        });
    }

    private void applyOldNewConf() {
        ServerState state = this.server.getState();
        RaftConfiguration current = this.server.getRaftConf();
        RaftConfiguration oldNewConf = this.stagingState.generateOldNewConf(current, state.getLog().getNextIndex());
        long index = state.getLog().append(state.getCurrentTerm(), oldNewConf);
        this.updateConfiguration(index, oldNewConf);
        this.stagingState = null;
        this.notifySenders();
    }

    private void updateConfiguration(long logIndex, RaftConfiguration newConf) {
        this.voterLists = this.divideFollowers(newConf);
        this.server.getState().setRaftConf(logIndex, newConf);
    }

    void updateFollowerCommitInfos(CommitInfoCache cache, List<RaftProtos.CommitInfoProto> protos) {
        this.senders.stream().map(LogAppender::getFollower).map(f -> cache.update(f.getPeer(), f.getCommitIndex())).forEach(protos::add);
    }

    RaftProtos.AppendEntriesRequestProto newAppendEntriesRequestProto(RaftPeerId targetId, TermIndex previous, List<RaftProtos.LogEntryProto> entries, boolean initializing, long callId) {
        return ServerProtoUtils.toAppendEntriesRequestProto(this.server.getMemberId(), targetId, this.currentTerm, entries, this.raftLog.getLastCommittedIndex(), initializing, previous, this.server.getCommitInfos(), callId);
    }

    void addAndStartSenders(Collection<RaftPeer> newPeers) {
        this.addSenders(newPeers, this.raftLog.getNextIndex(), false).forEach(LogAppender::startAppender);
    }

    Collection<LogAppender> addSenders(Collection<RaftPeer> newPeers, long nextIndex, boolean attendVote) {
        Timestamp t = Timestamp.currentTime().addTimeMs((long)(-this.server.getMaxTimeoutMs()));
        List<LogAppender> newAppenders = newPeers.stream().map(peer -> {
            LogAppender logAppender = this.server.newLogAppender(this, (RaftPeer)peer, t, nextIndex, attendVote);
            this.heartbeatMetrics.addFollower(logAppender.getFollower().getPeer().getId().toString());
            return logAppender;
        }).collect(Collectors.toList());
        this.senders.addAll(newAppenders);
        return newAppenders;
    }

    void stopAndRemoveSenders(Predicate<LogAppender> predicate) {
        List<LogAppender> toStop = this.senders.stream().filter(predicate).collect(Collectors.toList());
        toStop.forEach(LogAppender::stopAppender);
        this.senders.removeAll(toStop);
    }

    void restartSender(LogAppender sender) {
        FollowerInfo follower = sender.getFollower();
        LOG.info("{}: Restarting {} for {}", new Object[]{this.server.getId(), sender.getClass().getSimpleName(), follower.getName()});
        this.senders.removeAll(Collections.singleton(sender));
        this.addAndStartSenders(Collections.singleton(follower.getPeer()));
    }

    private void updateSenders(RaftConfiguration conf) {
        Preconditions.assertTrue((conf.isStable() && !this.inStagingState() ? 1 : 0) != 0);
        this.stopAndRemoveSenders(s -> !conf.containsInConf(s.getFollower().getPeer().getId()));
    }

    void submitStepDownEvent() {
        this.submitStepDownEvent(this.getCurrentTerm());
    }

    void submitStepDownEvent(long term) {
        this.eventQueue.submit(new StateUpdateEvent(StateUpdateEvent.Type.STEP_DOWN, term, () -> this.stepDown(term)));
    }

    private void stepDown(long term) {
        block2: {
            try {
                this.server.changeToFollowerAndPersistMetadata(term, "stepDown");
            }
            catch (IOException e) {
                String s = this.server.getId() + ": Failed to persist metadata for term " + term;
                LOG.warn(s, (Throwable)e);
                if (!this.running) break block2;
                throw new IllegalStateException(s + " and running == true", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepare() {
        RaftServerImpl raftServerImpl = this.server;
        synchronized (raftServerImpl) {
            RaftConfiguration conf;
            if (this.running && (conf = this.server.getRaftConf()).isTransitional() && this.server.getState().isConfCommitted()) {
                this.replicateNewConf();
            }
        }
    }

    private BootStrapProgress checkProgress(FollowerInfo follower, long committed) {
        Preconditions.assertTrue((!follower.isAttendingVote() ? 1 : 0) != 0);
        Timestamp progressTime = Timestamp.currentTime().addTimeMs((long)(-this.server.getMaxTimeoutMs()));
        Timestamp timeoutTime = Timestamp.currentTime().addTimeMs((long)(-3 * this.server.getMaxTimeoutMs()));
        if (follower.getLastRpcResponseTime().compareTo(timeoutTime) < 0) {
            LOG.debug("{} detects a follower {} timeout for bootstrapping, timeoutTime: {}", new Object[]{this.server.getId(), follower, timeoutTime});
            return BootStrapProgress.NOPROGRESS;
        }
        if (follower.getMatchIndex() + (long)this.stagingCatchupGap > committed && follower.getLastRpcResponseTime().compareTo(progressTime) > 0) {
            return BootStrapProgress.CAUGHTUP;
        }
        return BootStrapProgress.PROGRESSING;
    }

    private Collection<BootStrapProgress> checkAllProgress(long committed) {
        Preconditions.assertTrue((boolean)this.inStagingState());
        return this.senders.stream().filter(sender -> !sender.getFollower().isAttendingVote()).map(sender -> this.checkProgress(sender.getFollower(), committed)).collect(Collectors.toCollection(ArrayList::new));
    }

    void submitCheckStagingEvent() {
        this.eventQueue.submit(this.CHECK_STAGING_EVENT);
    }

    private void checkStaging() {
        if (!this.inStagingState()) {
            this.UPDATE_COMMIT_EVENT.execute();
        } else {
            long committedIndex = this.server.getState().getLog().getLastCommittedIndex();
            Collection<BootStrapProgress> reports = this.checkAllProgress(committedIndex);
            if (reports.contains((Object)BootStrapProgress.NOPROGRESS)) {
                LOG.debug("{} fails the setConfiguration request", (Object)this.server.getId());
                this.stagingState.fail();
            } else if (!reports.contains((Object)BootStrapProgress.PROGRESSING)) {
                this.applyOldNewConf();
                this.senders.forEach(s -> s.getFollower().startAttendVote());
            }
        }
    }

    boolean isBootStrappingPeer(RaftPeerId peerId) {
        return Optional.ofNullable(this.stagingState).map(s -> s.contains(peerId)).orElse(false);
    }

    void submitUpdateCommitEvent() {
        this.eventQueue.submit(this.UPDATE_COMMIT_EVENT);
    }

    private void updateCommit() {
        this.getMajorityMin(FollowerInfo::getMatchIndex, this.raftLog::getFlushIndex).ifPresent(m -> this.updateCommit(((MinMajorityMax)m).majority, ((MinMajorityMax)m).min));
    }

    private Optional<MinMajorityMax> getMajorityMin(ToLongFunction<FollowerInfo> followerIndex, LongSupplier logIndex) {
        RaftPeerId selfId = this.server.getId();
        RaftConfiguration conf = this.server.getRaftConf();
        List<FollowerInfo> followers = this.voterLists.get(0);
        boolean includeSelf = conf.containsInConf(selfId);
        if (followers.isEmpty() && !includeSelf) {
            return Optional.empty();
        }
        long[] indicesInNewConf = LeaderState.getSorted(followers, includeSelf, followerIndex, logIndex);
        MinMajorityMax newConf = MinMajorityMax.valueOf(indicesInNewConf);
        if (!conf.isTransitional()) {
            return Optional.of(newConf);
        }
        List<FollowerInfo> oldFollowers = this.voterLists.get(1);
        boolean includeSelfInOldConf = conf.containsInOldConf(selfId);
        if (oldFollowers.isEmpty() && !includeSelfInOldConf) {
            return Optional.empty();
        }
        long[] indicesInOldConf = LeaderState.getSorted(oldFollowers, includeSelfInOldConf, followerIndex, logIndex);
        MinMajorityMax oldConf = MinMajorityMax.valueOf(indicesInOldConf);
        return Optional.of(newConf.combine(oldConf));
    }

    private void updateCommit(long majority, long min) {
        long oldLastCommitted = this.raftLog.getLastCommittedIndex();
        if (majority > oldLastCommitted) {
            TermIndex[] entriesToCommit = this.raftLog.getEntries(oldLastCommitted + 1L, majority + 1L);
            if (this.server.getState().updateStatemachine(majority, this.currentTerm)) {
                this.watchRequests.update(RaftProtos.ReplicationLevel.MAJORITY, majority);
                this.logMetadata(majority);
                this.commitIndexChanged();
            }
            this.checkAndUpdateConfiguration(entriesToCommit);
        }
        this.watchRequests.update(RaftProtos.ReplicationLevel.ALL, min);
    }

    private void logMetadata(long commitIndex) {
        this.raftLog.appendMetadata(this.currentTerm, commitIndex);
        this.notifySenders();
    }

    private boolean committedConf(TermIndex[] entries) {
        long currentCommitted = this.raftLog.getLastCommittedIndex();
        for (TermIndex entry : entries) {
            if (entry.getIndex() > currentCommitted || !this.raftLog.isConfigEntry(entry)) continue;
            return true;
        }
        return false;
    }

    private void checkAndUpdateConfiguration(TermIndex[] entriesToCheck) {
        RaftConfiguration conf = this.server.getRaftConf();
        if (this.committedConf(entriesToCheck)) {
            if (conf.isTransitional()) {
                this.replicateNewConf();
            } else {
                this.pendingRequests.replySetConfiguration(this.server::getCommitInfos);
                if (!conf.containsInConf(this.server.getId())) {
                    LOG.info("{} is not included in the new configuration {}. Step down.", (Object)this.server.getId(), (Object)conf);
                    try {
                        Thread.sleep(this.server.getMinTimeoutMs());
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.server.shutdown(false);
                }
            }
        }
    }

    private void replicateNewConf() {
        RaftConfiguration conf = this.server.getRaftConf();
        RaftConfiguration newConf = RaftConfiguration.newBuilder().setConf(conf).setLogEntryIndex(this.raftLog.getNextIndex()).build();
        this.updateSenders(newConf);
        long index = this.raftLog.append(this.server.getState().getCurrentTerm(), newConf);
        this.updateConfiguration(index, newConf);
        this.notifySenders();
    }

    private static long[] getSorted(List<FollowerInfo> followers, boolean includeSelf, ToLongFunction<FollowerInfo> getFollowerIndex, LongSupplier getLogIndex) {
        int length;
        int n = length = includeSelf ? followers.size() + 1 : followers.size();
        if (length == 0) {
            throw new IllegalArgumentException("followers.size() == " + followers.size() + " and includeSelf == " + includeSelf);
        }
        long[] indices = new long[length];
        for (int i = 0; i < followers.size(); ++i) {
            indices[i] = getFollowerIndex.applyAsLong(followers.get(i));
        }
        if (includeSelf) {
            indices[length - 1] = getLogIndex.getAsLong();
        }
        Arrays.sort(indices);
        return indices;
    }

    private List<List<FollowerInfo>> divideFollowers(RaftConfiguration conf) {
        ArrayList<List<FollowerInfo>> lists = new ArrayList<List<FollowerInfo>>(2);
        List listForNew = this.senders.stream().filter(sender -> conf.containsInConf(sender.getFollower().getPeer().getId())).map(LogAppender::getFollower).collect(Collectors.toList());
        lists.add(listForNew);
        if (conf.isTransitional()) {
            List listForOld = this.senders.stream().filter(sender -> conf.containsInOldConf(sender.getFollower().getPeer().getId())).map(LogAppender::getFollower).collect(Collectors.toList());
            lists.add(listForOld);
        }
        return lists;
    }

    void replyPendingRequest(long logIndex, RaftClientReply reply) {
        this.pendingRequests.replyPendingRequest(logIndex, reply);
    }

    TransactionContext getTransactionContext(long index) {
        return this.pendingRequests.getTransactionContext(index);
    }

    long[] getFollowerNextIndices() {
        return this.senders.stream().mapToLong(s -> s.getFollower().getNextIndex()).toArray();
    }

    List<RaftPeer> getFollowers() {
        return Collections.unmodifiableList(this.senders.stream().map(sender -> sender.getFollower().getPeer()).collect(Collectors.toList()));
    }

    Stream<LogAppender> getLogAppenders() {
        return this.senders.stream();
    }

    void recordFollowerHeartbeatElapsedTime(String followerId, long elapsedTime) {
        this.heartbeatMetrics.recordFollowerHeartbeatElapsedTime(followerId, elapsedTime);
    }

    private class ConfigurationStagingState {
        private final Map<RaftPeerId, RaftPeer> newPeers;
        private final PeerConfiguration newConf;

        ConfigurationStagingState(Collection<RaftPeer> newPeers, PeerConfiguration newConf) {
            HashMap<RaftPeerId, RaftPeer> map = new HashMap<RaftPeerId, RaftPeer>();
            for (RaftPeer peer : newPeers) {
                map.put(peer.getId(), peer);
            }
            this.newPeers = Collections.unmodifiableMap(map);
            this.newConf = newConf;
        }

        RaftConfiguration generateOldNewConf(RaftConfiguration current, long logIndex) {
            return RaftConfiguration.newBuilder().setConf(this.newConf).setOldConf(current).setLogEntryIndex(logIndex).build();
        }

        Collection<RaftPeer> getNewPeers() {
            return this.newPeers.values();
        }

        boolean contains(RaftPeerId peerId) {
            return this.newPeers.containsKey(peerId);
        }

        void fail() {
            LeaderState.this.stopAndRemoveSenders(s -> !s.getFollower().isAttendingVote());
            LeaderState.this.stagingState = null;
            LeaderState.this.pendingRequests.failSetConfiguration((RaftException)new ReconfigurationTimeoutException("Fail to set configuration " + this.newConf + ". Timeout when bootstrapping new peers."));
        }
    }

    static class MinMajorityMax {
        private final long min;
        private final long majority;
        private final long max;

        MinMajorityMax(long min, long majority, long max) {
            this.min = min;
            this.majority = majority;
            this.max = max;
        }

        MinMajorityMax combine(MinMajorityMax that) {
            return new MinMajorityMax(Math.min(this.min, that.min), Math.min(this.majority, that.majority), Math.min(this.max, that.max));
        }

        static MinMajorityMax valueOf(long[] sorted) {
            return new MinMajorityMax(sorted[0], MinMajorityMax.getMajority(sorted), MinMajorityMax.getMax(sorted));
        }

        static long getMajority(long[] sorted) {
            return sorted[(sorted.length - 1) / 2];
        }

        static long getMax(long[] sorted) {
            return sorted[sorted.length - 1];
        }
    }

    private class EventProcessor
    extends Daemon {
        private EventProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            LeaderState.this.prepare();
            while (LeaderState.this.running) {
                StateUpdateEvent event = LeaderState.this.eventQueue.poll();
                RaftServerImpl raftServerImpl = LeaderState.this.server;
                synchronized (raftServerImpl) {
                    if (LeaderState.this.running) {
                        if (event != null) {
                            event.execute();
                        } else if (LeaderState.this.inStagingState()) {
                            LeaderState.this.checkStaging();
                        }
                    }
                }
            }
        }
    }

    static class SenderList {
        private final List<LogAppender> senders = new CopyOnWriteArrayList<LogAppender>();

        SenderList() {
        }

        Stream<LogAppender> stream() {
            return this.senders.stream();
        }

        void forEach(Consumer<LogAppender> action) {
            this.senders.forEach(action);
        }

        void addAll(Collection<LogAppender> newSenders) {
            if (newSenders.isEmpty()) {
                return;
            }
            Preconditions.assertUnique((Iterable)CollectionUtils.as(this.senders, LogAppender::getFollowerId), (Iterable)CollectionUtils.as(newSenders, LogAppender::getFollowerId));
            boolean changed = this.senders.addAll(newSenders);
            Preconditions.assertTrue((boolean)changed);
        }

        boolean removeAll(Collection<LogAppender> c) {
            return this.senders.removeAll(c);
        }
    }

    private class EventQueue {
        private final BlockingQueue<StateUpdateEvent> queue = new ArrayBlockingQueue<StateUpdateEvent>(4096);

        private EventQueue() {
        }

        void submit(StateUpdateEvent event) {
            try {
                this.queue.put(event);
            }
            catch (InterruptedException e) {
                LOG.info("{}: Interrupted when submitting {} ", (Object)LeaderState.this.server.getId(), (Object)event);
            }
        }

        StateUpdateEvent poll() {
            StateUpdateEvent e;
            try {
                e = this.queue.poll(LeaderState.this.server.getMaxTimeoutMs(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ie) {
                String s = LeaderState.this.server.getId() + ": " + this.getClass().getSimpleName() + " thread is interrupted";
                if (!LeaderState.this.running) {
                    LOG.info(s + " gracefully");
                    return null;
                }
                throw new IllegalStateException(s + " UNEXPECTEDLY", ie);
            }
            if (e != null) {
                while (e.equals(this.queue.peek())) {
                    this.queue.poll();
                }
            }
            return e;
        }
    }

    static class StateUpdateEvent {
        final Type type;
        final long newTerm;
        final Runnable handler;

        StateUpdateEvent(Type type, long newTerm, Runnable handler) {
            this.type = type;
            this.newTerm = newTerm;
            this.handler = handler;
        }

        void execute() {
            this.handler.run();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof StateUpdateEvent)) {
                return false;
            }
            StateUpdateEvent that = (StateUpdateEvent)obj;
            return this.type == that.type && this.newTerm == that.newTerm;
        }

        public String toString() {
            return (Object)((Object)this.type) + (this.newTerm >= 0L ? ":" + this.newTerm : "");
        }

        private static enum Type {
            STEP_DOWN,
            UPDATE_COMMIT,
            CHECK_STAGING;

        }
    }

    private static enum BootStrapProgress {
        NOPROGRESS,
        PROGRESSING,
        CAUGHTUP;

    }
}

