/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.server.raftlog.RaftLogIndex;
import org.apache.ratis.util.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FollowerInfo {
    public static final Logger LOG = LoggerFactory.getLogger(FollowerInfo.class);
    private final String name;
    private final Consumer<Object> infoIndexChange;
    private final Consumer<Object> debugIndexChange;
    private final RaftPeer peer;
    private final AtomicReference<Timestamp> lastRpcResponseTime;
    private final AtomicReference<Timestamp> lastRpcSendTime;
    private final RaftLogIndex nextIndex;
    private final RaftLogIndex matchIndex = new RaftLogIndex("matchIndex", 0L);
    private final RaftLogIndex commitIndex = new RaftLogIndex("commitIndex", -1L);
    private volatile boolean attendVote;
    private final int rpcSlownessTimeoutMs;

    FollowerInfo(RaftGroupMemberId id, RaftPeer peer, Timestamp lastRpcTime, long nextIndex, boolean attendVote, int rpcSlownessTimeoutMs) {
        this.name = id + "->" + peer.getId();
        this.infoIndexChange = s -> LOG.info("{}: {}", (Object)this.name, s);
        this.debugIndexChange = s -> LOG.debug("{}: {}", (Object)this.name, s);
        this.peer = peer;
        this.lastRpcResponseTime = new AtomicReference<Timestamp>(lastRpcTime);
        this.lastRpcSendTime = new AtomicReference<Timestamp>(lastRpcTime);
        this.nextIndex = new RaftLogIndex("nextIndex", nextIndex);
        this.attendVote = attendVote;
        this.rpcSlownessTimeoutMs = rpcSlownessTimeoutMs;
    }

    public long getMatchIndex() {
        return this.matchIndex.get();
    }

    public boolean updateMatchIndex(long newMatchIndex) {
        return this.matchIndex.updateToMax(newMatchIndex, this.debugIndexChange);
    }

    long getCommitIndex() {
        return this.commitIndex.get();
    }

    boolean updateCommitIndex(long newCommitIndex) {
        return this.commitIndex.updateToMax(newCommitIndex, this.debugIndexChange);
    }

    public long getNextIndex() {
        return this.nextIndex.get();
    }

    public void increaseNextIndex(long newNextIndex) {
        this.nextIndex.updateIncreasingly(newNextIndex, this.debugIndexChange);
    }

    public void decreaseNextIndex(long newNextIndex) {
        this.nextIndex.updateUnconditionally(old -> old <= 0L ? old : Math.min(old - 1L, newNextIndex), this.infoIndexChange);
    }

    public void updateNextIndex(long newNextIndex) {
        this.nextIndex.updateUnconditionally(old -> newNextIndex >= 0L ? newNextIndex : old, this.infoIndexChange);
    }

    public void setSnapshotIndex(long snapshotIndex) {
        this.matchIndex.setUnconditionally(snapshotIndex, this.infoIndexChange);
        this.nextIndex.setUnconditionally(snapshotIndex + 1L, this.infoIndexChange);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name + "(c" + this.getCommitIndex() + ",m" + this.getMatchIndex() + ",n" + this.getNextIndex() + ", attendVote=" + this.attendVote + ", lastRpcSendTime=" + this.lastRpcSendTime.get().elapsedTimeMs() + ", lastRpcResponseTime=" + this.lastRpcResponseTime.get().elapsedTimeMs() + ")";
    }

    void startAttendVote() {
        this.attendVote = true;
    }

    boolean isAttendingVote() {
        return this.attendVote;
    }

    public RaftPeer getPeer() {
        return this.peer;
    }

    public void updateLastRpcResponseTime() {
        this.lastRpcResponseTime.set(Timestamp.currentTime());
    }

    Timestamp getLastRpcResponseTime() {
        return this.lastRpcResponseTime.get();
    }

    public void updateLastRpcSendTime() {
        this.lastRpcSendTime.set(Timestamp.currentTime());
    }

    Timestamp getLastRpcTime() {
        return Timestamp.latest((Timestamp)this.lastRpcResponseTime.get(), (Timestamp)this.lastRpcSendTime.get());
    }

    boolean isSlow() {
        return this.lastRpcResponseTime.get().elapsedTimeMs() > (long)this.rpcSlownessTimeoutMs;
    }
}

