/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.logservice.shell;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.ratis.logservice.shell.Command;
import org.apache.ratis.logservice.shell.commands.ArchiveLogCommand;
import org.apache.ratis.logservice.shell.commands.CreateLogCommand;
import org.apache.ratis.logservice.shell.commands.DeleteLogCommand;
import org.apache.ratis.logservice.shell.commands.ExitCommand;
import org.apache.ratis.logservice.shell.commands.ExportLogCommand;
import org.apache.ratis.logservice.shell.commands.HelpCommand;
import org.apache.ratis.logservice.shell.commands.ListLogsCommand;
import org.apache.ratis.logservice.shell.commands.PutToLogCommand;
import org.apache.ratis.logservice.shell.commands.ReadLogCommand;

public class CommandFactory {
    private static final Map<String, Command> KNOWN_COMMANDS = CommandFactory.cacheCommands();

    private static Map<String, Command> cacheCommands() {
        HashMap<String, Command> commands = new HashMap<String, Command>();
        ExitCommand exitCommand = new ExitCommand();
        commands.put("create", new CreateLogCommand());
        commands.put("put", new PutToLogCommand());
        commands.put("read", new ReadLogCommand());
        commands.put("delete", new DeleteLogCommand());
        commands.put("exit", exitCommand);
        commands.put("quit", exitCommand);
        commands.put("help", new HelpCommand());
        commands.put("list", new ListLogsCommand());
        commands.put("archive", new ArchiveLogCommand());
        commands.put("export", new ExportLogCommand());
        return Collections.unmodifiableMap(commands);
    }

    public static Map<String, Command> getCommands() {
        return KNOWN_COMMANDS;
    }

    private CommandFactory() {
    }

    public static Command create(String commandName) {
        return KNOWN_COMMANDS.get(Objects.requireNonNull(commandName).toLowerCase());
    }
}

