/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.logservice.server;

import com.codahale.metrics.Timer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.logservice.api.ArchiveLogWriter;
import org.apache.ratis.logservice.api.LogName;
import org.apache.ratis.logservice.api.LogStream;
import org.apache.ratis.logservice.impl.ArchiveHdfsLogReader;
import org.apache.ratis.logservice.impl.ArchiveHdfsLogWriter;
import org.apache.ratis.logservice.metrics.LogServiceMetricsRegistry;
import org.apache.ratis.logservice.proto.LogServiceProtos;
import org.apache.ratis.logservice.server.ArchivalInfo;
import org.apache.ratis.logservice.server.LogServiceRaftLogReader;
import org.apache.ratis.logservice.server.RaftLogReader;
import org.apache.ratis.logservice.util.LogServiceProtoUtil;
import org.apache.ratis.logservice.util.LogServiceUtils;
import org.apache.ratis.metrics.RatisMetricRegistry;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.impl.RaftServerProxy;
import org.apache.ratis.server.impl.ServerState;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.server.raftlog.RaftLog;
import org.apache.ratis.server.storage.RaftStorage;
import org.apache.ratis.statemachine.StateMachineStorage;
import org.apache.ratis.statemachine.TransactionContext;
import org.apache.ratis.statemachine.impl.BaseStateMachine;
import org.apache.ratis.statemachine.impl.SimpleStateMachineStorage;
import org.apache.ratis.statemachine.impl.SingleFileSnapshotInfo;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.thirdparty.com.google.protobuf.MessageOrBuilder;
import org.apache.ratis.thirdparty.com.google.protobuf.TextFormat;
import org.apache.ratis.util.AutoCloseableLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogStateMachine
extends BaseStateMachine {
    public static final Logger LOG = LoggerFactory.getLogger(LogStateMachine.class);
    public static final long DEFAULT_ARCHIVE_THRESHOLD_PER_FILE = 1000000L;
    private final RaftProperties properties;
    private RatisMetricRegistry metricRegistry;
    private Timer sizeRequestTimer;
    private Timer readNextQueryTimer;
    private Timer getStateTimer;
    private Timer lastIndexQueryTimer;
    private Timer lengthQueryTimer;
    private Timer startIndexTimer;
    private Timer appendRequestTimer;
    private Timer syncRequesTimer;
    private Timer archiveLogRequestTimer;
    private Timer getCloseLogTimer;
    private RaftClient client;
    private long length;
    private long dataRecordsSize;
    private LogStream.State state = LogStream.State.OPEN;
    private final SimpleStateMachineStorage storage = new SimpleStateMachineStorage();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
    private RaftLog log;
    private RaftServerProxy proxy;
    private ExecutorService executorService;
    private boolean isArchivalRequest;
    private ArchivalInfo archivalInfo;
    private Map<String, ArchivalInfo> exportMap = new HashMap<String, ArchivalInfo>();
    private Map<String, Future<Boolean>> archiveExportFutures = new HashMap<String, Future<Boolean>>();
    private Timer archiveLogTimer;

    public LogStateMachine(RaftProperties properties) {
        this.properties = properties;
    }

    private AutoCloseableLock readLock() {
        return AutoCloseableLock.acquire((Lock)this.lock.readLock());
    }

    private AutoCloseableLock writeLock() {
        return AutoCloseableLock.acquire((Lock)this.lock.writeLock());
    }

    void reset() {
        this.length = 0L;
        this.dataRecordsSize = 0L;
        this.setLastAppliedTermIndex(null);
    }

    public void initialize(RaftServer server, RaftGroupId groupId, RaftStorage raftStorage) throws IOException {
        super.initialize(server, groupId, raftStorage);
        this.storage.init(raftStorage);
        this.proxy = (RaftServerProxy)server;
        this.metricRegistry = LogServiceMetricsRegistry.createMetricRegistryForLogService(groupId.toString(), server.getId().toString());
        this.readNextQueryTimer = this.metricRegistry.timer("readNextQueryTime");
        this.startIndexTimer = this.metricRegistry.timer("startIndexTime");
        this.sizeRequestTimer = this.metricRegistry.timer("sizeRequestTime");
        this.getStateTimer = this.metricRegistry.timer("getStateTime");
        this.lastIndexQueryTimer = this.metricRegistry.timer("lastIndexQueryTime");
        this.lengthQueryTimer = this.metricRegistry.timer("lengthQueryTime");
        this.syncRequesTimer = this.metricRegistry.timer("syncRequesTime");
        this.appendRequestTimer = this.metricRegistry.timer("appendRequestTime");
        this.getCloseLogTimer = this.metricRegistry.timer("getCloseLogTime");
        this.archiveLogRequestTimer = this.metricRegistry.timer("archiveLogRequestTime");
        this.archiveLogTimer = this.metricRegistry.timer("archiveLogTime");
        this.loadSnapshot(this.storage.getLatestSnapshot());
        this.executorService = Executors.newSingleThreadExecutor();
        this.archivalInfo = new ArchivalInfo(this.properties.get("logservice.archival.location"));
    }

    private void checkInitialization() throws IOException {
        if (this.log == null) {
            ServerState state = this.proxy.getImpl(this.groupId).getState();
            this.log = state.getLog();
        }
    }

    public void reinitialize() throws IOException {
        this.close();
        this.loadSnapshot(this.storage.getLatestSnapshot());
    }

    public long takeSnapshot() {
        TermIndex last;
        try (AutoCloseableLock readLock = this.readLock();){
            last = this.getLastAppliedTermIndex();
        }
        File snapshotFile = this.storage.getSnapshotFile(last.getTerm(), last.getIndex());
        LOG.info("Taking a snapshot to file {}", (Object)snapshotFile);
        try (AutoCloseableLock readLock = this.readLock();
             ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(snapshotFile)));){
            out.writeLong(this.length);
            out.writeLong(this.dataRecordsSize);
            out.writeObject((Object)this.state);
        }
        catch (IOException ioe) {
            LOG.warn("Failed to write snapshot file \"" + snapshotFile + "\", last applied index=" + last);
        }
        return last.getIndex();
    }

    private long loadSnapshot(SingleFileSnapshotInfo snapshot) throws IOException {
        return this.load(snapshot, false);
    }

    private long load(SingleFileSnapshotInfo snapshot, boolean reload) throws IOException {
        if (snapshot == null) {
            LOG.warn("The snapshot info is null.");
            return -1L;
        }
        File snapshotFile = snapshot.getFile().getPath().toFile();
        if (!snapshotFile.exists()) {
            LOG.warn("The snapshot file {} does not exist for snapshot {}", (Object)snapshotFile, (Object)snapshot);
            return -1L;
        }
        TermIndex last = SimpleStateMachineStorage.getTermIndexFromSnapshotFile((File)snapshotFile);
        try (AutoCloseableLock writeLock = this.writeLock();
             ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(snapshotFile)));){
            if (reload) {
                this.reset();
            }
            this.setLastAppliedTermIndex(last);
            this.length = in.readLong();
            this.dataRecordsSize = in.readLong();
            this.state = (LogStream.State)((Object)in.readObject());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
        return last.getIndex();
    }

    public StateMachineStorage getStateMachineStorage() {
        return this.storage;
    }

    public CompletableFuture<Message> query(Message request) {
        try {
            this.checkInitialization();
            final LogServiceProtos.LogServiceRequestProto logServiceRequestProto = LogServiceProtos.LogServiceRequestProto.parseFrom(request.getContent());
            if (LOG.isTraceEnabled()) {
                LOG.trace("Processing LogService query: {}", (Object)TextFormat.shortDebugString((MessageOrBuilder)logServiceRequestProto));
            }
            switch (logServiceRequestProto.getRequestCase()) {
                case READNEXTQUERY: {
                    return this.recordTime(this.readNextQueryTimer, new BaseStateMachine.Task(){

                        public CompletableFuture<Message> run() {
                            return LogStateMachine.this.processReadRequest(logServiceRequestProto);
                        }
                    });
                }
                case SIZEREQUEST: {
                    return this.recordTime(this.sizeRequestTimer, new BaseStateMachine.Task(){

                        public CompletableFuture<Message> run() {
                            return LogStateMachine.this.processGetSizeRequest(logServiceRequestProto);
                        }
                    });
                }
                case STARTINDEXQUERY: {
                    return this.recordTime(this.startIndexTimer, new BaseStateMachine.Task(){

                        public CompletableFuture<Message> run() {
                            return LogStateMachine.this.processGetStartIndexRequest(logServiceRequestProto);
                        }
                    });
                }
                case GETSTATE: {
                    return this.recordTime(this.getStateTimer, new BaseStateMachine.Task(){

                        public CompletableFuture<Message> run() {
                            return LogStateMachine.this.processGetStateRequest(logServiceRequestProto);
                        }
                    });
                }
                case LASTINDEXQUERY: {
                    return this.recordTime(this.lastIndexQueryTimer, new BaseStateMachine.Task(){

                        public CompletableFuture<Message> run() {
                            return LogStateMachine.this.processGetLastCommittedIndexRequest(logServiceRequestProto);
                        }
                    });
                }
                case LENGTHQUERY: {
                    return this.recordTime(this.lengthQueryTimer, new BaseStateMachine.Task(){

                        public CompletableFuture<Message> run() {
                            return LogStateMachine.this.processGetLengthRequest(logServiceRequestProto);
                        }
                    });
                }
                case ARCHIVELOG: {
                    return this.recordTime(this.archiveLogRequestTimer, new BaseStateMachine.Task(){

                        public CompletableFuture<Message> run() {
                            return LogStateMachine.this.processArchiveLog(logServiceRequestProto);
                        }
                    });
                }
                case EXPORTINFO: {
                    return this.processExportInfo(logServiceRequestProto);
                }
            }
            throw new RuntimeException("Wrong message type for query: " + (Object)((Object)logServiceRequestProto.getRequestCase()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private CompletableFuture<Message> processExportInfo(LogServiceProtos.LogServiceRequestProto logServiceRequestProto) {
        LogServiceProtos.GetExportInfoRequestProto exportInfoRequestProto = logServiceRequestProto.getExportInfo();
        LogServiceProtos.GetExportInfoReplyProto.Builder exportBuilder = LogServiceProtos.GetExportInfoReplyProto.newBuilder();
        this.exportMap.values().stream().map(archivalInfo -> exportBuilder.addInfo(LogServiceProtoUtil.toExportInfoProto(archivalInfo))).collect(Collectors.toList());
        return CompletableFuture.completedFuture(Message.valueOf((ByteString)exportBuilder.build().toByteString()));
    }

    private CompletableFuture<Message> processGetStartIndexRequest(LogServiceProtos.LogServiceRequestProto proto) {
        Throwable t = this.verifyState(LogStream.State.OPEN);
        long startIndex = this.log.getStartIndex();
        return CompletableFuture.completedFuture(Message.valueOf((ByteString)LogServiceProtoUtil.toGetLogStartIndexReplyProto(startIndex, t).toByteString()));
    }

    private CompletableFuture<Message> processGetLastCommittedIndexRequest(LogServiceProtos.LogServiceRequestProto proto) {
        Throwable t = this.verifyState(LogStream.State.OPEN);
        long lastIndex = this.log.getLastCommittedIndex();
        return CompletableFuture.completedFuture(Message.valueOf((ByteString)LogServiceProtoUtil.toGetLogLastIndexReplyProto(lastIndex, t).toByteString()));
    }

    private CompletableFuture<Message> processGetSizeRequest(LogServiceProtos.LogServiceRequestProto proto) {
        LogServiceProtos.GetLogSizeRequestProto msgProto = proto.getSizeRequest();
        Throwable t = this.verifyState(LogStream.State.OPEN);
        LOG.trace("Size query: {}, Result: {}", (Object)msgProto, (Object)this.dataRecordsSize);
        return CompletableFuture.completedFuture(Message.valueOf((ByteString)LogServiceProtoUtil.toGetLogSizeReplyProto(this.dataRecordsSize, t).toByteString()));
    }

    private CompletableFuture<Message> processGetLengthRequest(LogServiceProtos.LogServiceRequestProto proto) {
        LogServiceProtos.GetLogLengthRequestProto msgProto = proto.getLengthQuery();
        Throwable t = this.verifyState(LogStream.State.OPEN);
        LOG.trace("Length query: {}, Result: {}", (Object)msgProto, (Object)this.length);
        return CompletableFuture.completedFuture(Message.valueOf((ByteString)LogServiceProtoUtil.toGetLogLengthReplyProto(this.length, t).toByteString()));
    }

    private CompletableFuture<Message> processReadRequest(LogServiceProtos.LogServiceRequestProto proto) {
        LogServiceProtos.ReadLogRequestProto msgProto = proto.getReadNextQuery();
        long startRecordId = msgProto.getStartRecordId();
        int numRecordsToRead = msgProto.getNumRecords();
        Throwable t = this.verifyState(LogStream.State.OPEN, LogStream.State.ARCHIVING, LogStream.State.CLOSED, LogStream.State.ARCHIVED);
        ArrayList<byte[]> list = null;
        if (t == null) {
            RaftLogReader reader = null;
            try {
                if (this.state == LogStream.State.OPEN || this.state == LogStream.State.CLOSED || this.state == LogStream.State.ARCHIVING) {
                    reader = new LogServiceRaftLogReader(this.log);
                } else if (this.state == LogStream.State.ARCHIVED) {
                    reader = new ArchiveHdfsLogReader(LogServiceUtils.getArchiveLocationForLog(this.archivalInfo.getArchiveLocation(), this.archivalInfo.getArchiveLogName()));
                } else {
                    t = this.verifyState(LogStream.State.OPEN, LogStream.State.ARCHIVED);
                }
                if (t == null && reader != null) {
                    list = new ArrayList<byte[]>();
                    reader.seek(startRecordId);
                    for (int i = 0; i < numRecordsToRead && reader.hasNext(); ++i) {
                        list.add(reader.next());
                    }
                }
            }
            catch (Exception e) {
                LOG.error("Failed to execute ReadNextQuery", (Throwable)e);
                t = e;
                list = null;
            }
        }
        return CompletableFuture.completedFuture(Message.valueOf((ByteString)LogServiceProtoUtil.toReadLogReplyProto(list, t).toByteString()));
    }

    private CompletableFuture<Message> processSyncRequest(TransactionContext trx, LogServiceProtos.LogServiceRequestProto logMessage) {
        long index = trx.getLogEntry().getIndex();
        return CompletableFuture.completedFuture(Message.valueOf((ByteString)LogServiceProtoUtil.toSyncLogReplyProto(index, null).toByteString()));
    }

    private CompletableFuture<Message> processAppendRequest(TransactionContext trx, LogServiceProtos.LogServiceRequestProto logProto) {
        RaftProtos.LogEntryProto entry = trx.getLogEntry();
        LogServiceProtos.AppendLogEntryRequestProto proto = logProto.getAppendRequest();
        long index = entry.getIndex();
        long newSize = 0L;
        Throwable t = this.verifyState(LogStream.State.OPEN);
        ArrayList<Long> ids = new ArrayList<Long>();
        if (t == null) {
            try (AutoCloseableLock writeLock = this.writeLock();){
                List<byte[]> entries = LogServiceProtoUtil.toListByteArray(proto.getDataList());
                for (byte[] bb : entries) {
                    ids.add(this.length);
                    newSize += (long)bb.length;
                    ++this.length;
                }
                this.dataRecordsSize += newSize;
                this.updateLastAppliedTermIndex(entry.getTerm(), index);
            }
        }
        CompletableFuture<Message> f = CompletableFuture.completedFuture(Message.valueOf((ByteString)LogServiceProtoUtil.toAppendLogReplyProto(ids, t).toByteString()));
        RaftProtos.RaftPeerRole role = trx.getServerRole();
        if (LOG.isTraceEnabled()) {
            LOG.trace("{}:{}-{}: {} new length {}", new Object[]{role, this.getId(), index, TextFormat.shortDebugString((MessageOrBuilder)proto), this.dataRecordsSize});
        }
        return f;
    }

    public void close() {
        this.reset();
    }

    public CompletableFuture<Message> applyTransaction(final TransactionContext trx) {
        try {
            this.checkInitialization();
            RaftProtos.LogEntryProto entry = trx.getLogEntry();
            final LogServiceProtos.LogServiceRequestProto logServiceRequestProto = LogServiceProtos.LogServiceRequestProto.parseFrom(entry.getStateMachineLogEntry().getLogData());
            switch (logServiceRequestProto.getRequestCase()) {
                case CHANGESTATE: {
                    return this.recordTime(this.getCloseLogTimer, new BaseStateMachine.Task(){

                        public CompletableFuture<Message> run() {
                            return LogStateMachine.this.processChangeState(logServiceRequestProto);
                        }
                    });
                }
                case APPENDREQUEST: {
                    return this.recordTime(this.appendRequestTimer, new BaseStateMachine.Task(){

                        public CompletableFuture<Message> run() {
                            return LogStateMachine.this.processAppendRequest(trx, logServiceRequestProto);
                        }
                    });
                }
                case SYNCREQUEST: {
                    return this.recordTime(this.syncRequesTimer, new BaseStateMachine.Task(){

                        public CompletableFuture<Message> run() {
                            return LogStateMachine.this.processSyncRequest(trx, logServiceRequestProto);
                        }
                    });
                }
                case ARCHIVELOG: {
                    return this.updateArchiveLogInfo(logServiceRequestProto);
                }
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private CompletableFuture<Message> processChangeState(LogServiceProtos.LogServiceRequestProto logServiceRequestProto) {
        LogServiceProtos.ChangeStateLogRequestProto changeState = logServiceRequestProto.getChangeState();
        LogStream.State targetState = LogStream.State.valueOf(changeState.getState().name());
        Throwable t = null;
        if (!changeState.getForce()) {
            switch (targetState) {
                case OPEN: {
                    if (this.state == null) break;
                    t = this.verifyState(LogStream.State.OPEN, LogStream.State.CLOSED);
                    break;
                }
                case CLOSED: {
                    t = this.verifyState(LogStream.State.OPEN);
                    break;
                }
                case ARCHIVED: {
                    t = this.verifyState(LogStream.State.ARCHIVING);
                    break;
                }
                case ARCHIVING: {
                    t = this.verifyState(LogStream.State.CLOSED);
                    break;
                }
                case DELETED: {
                    t = this.verifyState(LogStream.State.CLOSED);
                }
            }
        }
        if (t != null) {
            return CompletableFuture.completedFuture(Message.valueOf((ByteString)LogServiceProtos.ChangeStateReplyProto.newBuilder().setException(LogServiceProtoUtil.toLogException(t)).build().toByteString()));
        }
        this.state = targetState;
        return CompletableFuture.completedFuture(Message.valueOf((ByteString)LogServiceProtos.ChangeStateReplyProto.newBuilder().build().toByteString()));
    }

    private CompletableFuture<Message> processGetStateRequest(LogServiceProtos.LogServiceRequestProto logServiceRequestProto) {
        LogServiceProtos.GetStateRequestProto getState = logServiceRequestProto.getGetState();
        return CompletableFuture.completedFuture(Message.valueOf((ByteString)LogServiceProtoUtil.toGetStateReplyProto(this.state).toByteString()));
    }

    private Throwable verifyState(LogStream.State ... states) {
        for (LogStream.State state : states) {
            if (this.state != state) continue;
            return null;
        }
        return new IOException("Wrong state: " + (Object)((Object)this.state));
    }

    private CompletableFuture<Message> updateArchiveLogInfo(LogServiceProtos.LogServiceRequestProto logServiceRequestProto) {
        LogServiceProtos.ArchiveLogRequestProto archiveLog = logServiceRequestProto.getArchiveLog();
        this.isArchivalRequest = !archiveLog.getIsExport();
        Throwable t = null;
        if (this.isArchivalRequest) {
            this.archivalInfo.updateArchivalInfo(archiveLog);
            t = this.verifyState(LogStream.State.ARCHIVING);
        } else {
            t = this.verifyState(LogStream.State.OPEN, LogStream.State.CLOSED);
            ArchivalInfo info = this.exportMap.get(archiveLog.getLocation());
            if (info == null) {
                info = new ArchivalInfo(archiveLog.getLocation());
                this.exportMap.put(archiveLog.getLocation(), info);
            }
            info.updateArchivalInfo(archiveLog);
        }
        return CompletableFuture.completedFuture(Message.valueOf((ByteString)LogServiceProtoUtil.toArchiveLogReplyProto(t).toByteString()));
    }

    private CompletableFuture<Message> processArchiveLog(LogServiceProtos.LogServiceRequestProto logServiceRequestProto) {
        LogServiceProtos.ArchiveLogRequestProto archiveLog = logServiceRequestProto.getArchiveLog();
        LogName logName = LogServiceProtoUtil.toLogName(archiveLog.getLogName());
        Throwable t = null;
        try {
            String loc = null;
            boolean bl = this.isArchivalRequest = !archiveLog.getIsExport();
            if (this.isArchivalRequest) {
                loc = this.archivalInfo.getArchiveLocation();
                this.archivalInfo.updateArchivalInfo(archiveLog);
            } else {
                loc = archiveLog.getLocation();
                ArchivalInfo exportInfo = this.exportMap.putIfAbsent(loc, new ArchivalInfo(loc));
                if (exportInfo != null && exportInfo.getLastArchivedIndex() == archiveLog.getLastArchivedRaftIndex()) {
                    throw new IllegalStateException("Export of " + logName + "for the given location " + loc + "is already present and in " + (Object)((Object)exportInfo.getStatus()));
                }
                exportInfo.updateArchivalInfo(archiveLog);
            }
            if (loc == null) {
                throw new IllegalArgumentException(this.isArchivalRequest ? "Location for archive is not configured" : "Location for export provided is null");
            }
            String location = loc;
            long recordId = archiveLog.getLastArchivedRaftIndex();
            t = this.isArchivalRequest ? this.verifyState(LogStream.State.CLOSED) : this.verifyState(LogStream.State.OPEN, LogStream.State.CLOSED);
            if (t == null) {
                Callable<Boolean> callable = () -> {
                    Timer.Context timerContext = this.archiveLogTimer.time();
                    try {
                        this.startArchival(recordId, logName, location);
                        ArchiveHdfsLogWriter writer = new ArchiveHdfsLogWriter();
                        writer.init(location, logName);
                        LogServiceRaftLogReader reader = new LogServiceRaftLogReader(this.log);
                        reader.seek(recordId);
                        long records = 0L;
                        boolean isInterrupted = false;
                        while (reader.hasNext()) {
                            writer.write(ByteBuffer.wrap(reader.next()));
                            isInterrupted = Thread.currentThread().isInterrupted();
                            if (records >= 1000000L || isInterrupted) {
                                this.commit(writer, logName, location);
                                if (isInterrupted) break;
                                records = 0L;
                            }
                            ++records;
                        }
                        writer.close();
                        if (!isInterrupted) {
                            this.completeArchival(writer.getLastWrittenRecordId(), logName, location);
                        } else {
                            try {
                                Thread.sleep(10000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            this.sendArchiveLogrequestToNewLeader(writer.getLastWrittenRecordId(), logName, location);
                        }
                        Boolean bl = true;
                        return bl;
                    }
                    catch (Exception e) {
                        LOG.error("Archival failed for the log:" + logName, (Throwable)e);
                        this.failArchival(recordId, logName, location);
                    }
                    finally {
                        timerContext.stop();
                    }
                    return false;
                };
                this.archiveExportFutures.put(location, this.executorService.submit(callable));
            }
        }
        catch (Exception e) {
            LOG.warn("Exception while processing archival request for " + logName, (Throwable)e);
            t = e;
        }
        return CompletableFuture.completedFuture(Message.valueOf((ByteString)LogServiceProtoUtil.toArchiveLogReplyProto(t).toByteString()));
    }

    private void failArchival(long recordId, LogName logName, String location) throws IOException {
        this.updateArchivingInfo(recordId, logName, location, this.isArchivalRequest, ArchivalInfo.ArchivalStatus.FAILED);
        if (this.isArchivalRequest) {
            this.sendChangeStateRequest(LogStream.State.CLOSED, true);
        }
    }

    private void startArchival(long recordId, LogName logName, String location) throws IOException {
        if (this.isArchivalRequest) {
            this.sendChangeStateRequest(LogStream.State.ARCHIVING, false);
        }
        this.updateArchivingInfo(recordId, logName, location, this.isArchivalRequest, ArchivalInfo.ArchivalStatus.STARTED);
    }

    private void sendArchiveLogrequestToNewLeader(long recordId, LogName logName, String location) throws IOException {
        this.getClient().sendReadOnly(() -> LogServiceProtoUtil.toArchiveLogRequestProto(logName, location, recordId, this.isArchivalRequest, ArchivalInfo.ArchivalStatus.INTERRUPTED).toByteString());
    }

    public void completeArchival(long recordId, LogName logName, String location) throws IOException {
        if (this.isArchivalRequest) {
            this.sendChangeStateRequest(LogStream.State.ARCHIVED, false);
        }
        this.updateArchivingInfo(recordId, logName, location, this.isArchivalRequest, ArchivalInfo.ArchivalStatus.COMPLETED);
    }

    private void commit(ArchiveLogWriter writer, LogName logName, String location) throws IOException {
        writer.rollWriter();
        this.updateArchivingInfo(writer.getLastWrittenRecordId(), logName, location, this.isArchivalRequest, ArchivalInfo.ArchivalStatus.RUNNING);
    }

    private void updateArchivingInfo(long recordId, LogName logName, String location, boolean isArchival, ArchivalInfo.ArchivalStatus status) throws IOException {
        RaftClientReply archiveLogReply = this.getClient().send(() -> LogServiceProtoUtil.toArchiveLogRequestProto(logName, location, recordId, isArchival, status).toByteString());
        LogServiceProtos.ArchiveLogReplyProto message = LogServiceProtos.ArchiveLogReplyProto.parseFrom(archiveLogReply.getMessage().getContent());
        if (message.hasException()) {
            throw new IOException(message.getException().getErrorMsg());
        }
    }

    private void sendChangeStateRequest(LogStream.State state, boolean force) throws IOException {
        this.getClient().send(() -> LogServiceProtoUtil.toChangeStateRequestProto(LogName.of("Dummy"), state, force).toByteString());
    }

    private RaftClient getClient() throws IOException {
        if (this.client == null) {
            try {
                RaftServer raftServer = (RaftServer)this.server.get();
                this.client = RaftClient.newBuilder().setRaftGroup(this.getGroupFromGroupId(raftServer, this.groupId)).setClientId(ClientId.randomId()).setProperties(raftServer.getProperties()).build();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        return this.client;
    }

    private RaftGroup getGroupFromGroupId(RaftServer raftServer, RaftGroupId raftGroupId) throws IOException {
        List x = StreamSupport.stream(raftServer.getGroups().spliterator(), false).filter(group -> group.getGroupId().equals((Object)raftGroupId)).collect(Collectors.toList());
        if (x.size() == 1) {
            return (RaftGroup)x.get(0);
        }
        throw new IOException(x.size() + " are group found for group id:" + raftGroupId);
    }

    public void notifyNotLeader(Collection<TransactionContext> pendingEntries) throws IOException {
        for (Future<Boolean> archiveFuture : this.archiveExportFutures.values()) {
            if (archiveFuture == null || archiveFuture.isCancelled()) continue;
            archiveFuture.cancel(true);
        }
    }
}

