/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.logservice.server;

import com.beust.jcommander.JCommander;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.client.RaftClientConfigKeys;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.logservice.api.LogServiceConfiguration;
import org.apache.ratis.logservice.server.BaseServer;
import org.apache.ratis.logservice.server.LogStateMachine;
import org.apache.ratis.logservice.server.ManagementStateMachine;
import org.apache.ratis.logservice.server.ServerOpts;
import org.apache.ratis.logservice.util.LogServiceUtils;
import org.apache.ratis.logservice.util.MetaServiceProtoUtil;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.util.Daemon;
import org.apache.ratis.util.SizeInBytes;
import org.apache.ratis.util.TimeDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogServer
extends BaseServer {
    private static final Logger LOG = LoggerFactory.getLogger(LogServer.class);
    private RaftServer raftServer = null;
    private RaftClient metaClient = null;
    private Daemon daemon = null;
    private long heartbeatInterval = 3000L;

    public LogServer(ServerOpts opts) {
        super(opts);
        LOG.debug("Log Server options: {}", (Object)opts);
    }

    public RaftServer getServer() {
        return this.raftServer;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    void setRaftProperties(RaftProperties properties) {
        super.setRaftProperties(properties);
        long rpcTimeout = this.getConfig().getLong("logservice.raft.rpc.timeout", 100000L);
        RaftClientConfigKeys.Rpc.setRequestTimeout((RaftProperties)properties, (TimeDuration)TimeDuration.valueOf((long)rpcTimeout, (TimeUnit)TimeUnit.MILLISECONDS));
        long segmentSize = this.getConfig().getLong("ratis.raft.segment.size", 0x2000000L);
        SizeInBytes segmentSizeBytes = SizeInBytes.valueOf((long)segmentSize);
        String archiveLocation = this.getConfig().get("logservice.archival.location");
        if (archiveLocation != null) {
            properties.set("logservice.archival.location", archiveLocation);
        }
        this.heartbeatInterval = this.getConfig().getLong("logservice.heartbeat.interval", 3000L);
        if (this.heartbeatInterval <= 0L) {
            LOG.warn("Heartbeat interval configuration is invalid. Setting default value 3000");
            this.heartbeatInterval = 3000L;
        }
        RaftServerConfigKeys.Log.setSegmentSizeMax((RaftProperties)properties, (SizeInBytes)segmentSizeBytes);
        RaftServerConfigKeys.Log.setPreallocatedSize((RaftProperties)properties, (SizeInBytes)segmentSizeBytes);
    }

    public void start() throws IOException {
        ServerOpts opts = this.getServerOpts();
        Set<RaftPeer> peers = LogServiceUtils.getPeersFromQuorum(opts.getMetaQuorum());
        final RaftProperties properties = new RaftProperties();
        this.setRaftProperties(properties);
        InetSocketAddress addr = new InetSocketAddress(opts.getHost(), opts.getPort());
        if (opts.getWorkingDir() != null) {
            RaftServerConfigKeys.setStorageDirs((RaftProperties)properties, Collections.singletonList(new File(opts.getWorkingDir())));
        }
        String id = opts.getHost() + "_" + opts.getPort();
        RaftPeer peer = new RaftPeer(RaftPeerId.valueOf((String)id), addr);
        final RaftGroupId logServerGroupId = RaftGroupId.valueOf((UUID)opts.getLogServerGroupId());
        RaftGroup all = RaftGroup.valueOf((RaftGroupId)logServerGroupId, (RaftPeer[])new RaftPeer[]{peer});
        RaftGroup meta = RaftGroup.valueOf((RaftGroupId)RaftGroupId.valueOf((UUID)opts.getMetaGroupId()), peers);
        this.validateRaftProperties(properties);
        this.raftServer = RaftServer.newBuilder().setStateMachineRegistry(new StateMachine.Registry(){

            public StateMachine apply(RaftGroupId raftGroupId) {
                if (raftGroupId.equals((Object)logServerGroupId)) {
                    return new ManagementStateMachine();
                }
                return new LogStateMachine(properties);
            }
        }).setProperties(properties).setServerId(RaftPeerId.valueOf((String)id)).setGroup(all).build();
        this.raftServer.start();
        this.metaClient = RaftClient.newBuilder().setRaftGroup(meta).setClientId(ClientId.randomId()).setProperties(properties).build();
        this.metaClient.send(() -> MetaServiceProtoUtil.toPingRequestProto(peer).toByteString());
        this.daemon = new Daemon((Runnable)new HeartbeatSender(new RaftPeer(this.raftServer.getId())), "heartbeat-Sender" + this.raftServer.getId());
        this.daemon.start();
    }

    public static void main(String[] args) throws IOException {
        ServerOpts opts = new ServerOpts();
        JCommander.newBuilder().addObject((Object)opts).build().parse(args);
        LogServiceConfiguration config = LogServiceConfiguration.create();
        opts = config.addLogServerOpts(opts);
        try (LogServer worker = new LogServer(opts);){
            worker.start();
            try {
                while (true) {
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.raftServer.close();
        this.daemon.interrupt();
    }

    private class HeartbeatSender
    implements Runnable {
        RaftPeer peer;

        public HeartbeatSender(RaftPeer peer) {
            this.peer = peer;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        LogServer.this.metaClient.send(() -> MetaServiceProtoUtil.toHeartbeatRequestProto(this.peer).toByteString());
                        Thread.sleep(LogServer.this.heartbeatInterval);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
                catch (IOException e) {
                    LOG.warn("Heartbeat request failed with exception", (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }

    public static class Builder
    extends BaseServer.Builder<LogServer> {
        @Override
        public LogServer build() {
            this.validate();
            return new LogServer(this.getOpts());
        }
    }
}

