/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.logservice.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.logservice.api.LogName;
import org.apache.ratis.logservice.api.LogReader;
import org.apache.ratis.logservice.api.LogServiceConfiguration;
import org.apache.ratis.logservice.api.LogStream;
import org.apache.ratis.logservice.api.LogWriter;
import org.apache.ratis.logservice.api.RecordListener;
import org.apache.ratis.logservice.impl.LogReaderImpl;
import org.apache.ratis.logservice.impl.LogWriterImpl;
import org.apache.ratis.logservice.proto.LogServiceProtos;
import org.apache.ratis.logservice.util.LogServiceProtoUtil;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogStreamImpl
implements LogStream {
    public static final Logger LOG = LoggerFactory.getLogger(LogStreamImpl.class);
    List<RecordListener> listeners;
    LogName name;
    RaftClient raftClient;
    LogServiceConfiguration config;
    LogStream.State state;
    long length;

    public LogStreamImpl(LogName name, RaftClient raftClient) {
        this.raftClient = raftClient;
        this.name = name;
        this.config = LogServiceConfiguration.create();
        this.init();
    }

    public LogStreamImpl(LogName name, RaftClient raftClient, LogServiceConfiguration config) {
        this.raftClient = raftClient;
        this.name = name;
        this.config = config;
        this.init();
    }

    private void init() {
        this.state = LogStream.State.OPEN;
        this.listeners = Collections.synchronizedList(new ArrayList());
    }

    @Override
    public LogName getName() {
        return this.name;
    }

    @Override
    public LogStream.State getState() throws IOException {
        RaftClientReply reply = this.raftClient.sendReadOnly(Message.valueOf((ByteString)LogServiceProtoUtil.toGetStateRequestProto(this.name).toByteString()));
        LogServiceProtos.GetStateReplyProto proto = LogServiceProtos.GetStateReplyProto.parseFrom(reply.getMessage().getContent());
        return LogStream.State.valueOf(proto.getState().name());
    }

    @Override
    public long getSize() throws IOException {
        RaftClientReply reply = this.raftClient.sendReadOnly(Message.valueOf((ByteString)LogServiceProtoUtil.toGetSizeRequestProto(this.name).toByteString()));
        LogServiceProtos.GetLogSizeReplyProto proto = LogServiceProtos.GetLogSizeReplyProto.parseFrom(reply.getMessage().getContent());
        if (proto.hasException()) {
            LogServiceProtos.LogServiceException e = proto.getException();
            throw new IOException(e.getErrorMsg());
        }
        return proto.getSize();
    }

    @Override
    public long getLength() throws IOException {
        RaftClientReply reply = this.raftClient.sendReadOnly(Message.valueOf((ByteString)LogServiceProtoUtil.toGetLengthRequestProto(this.name).toByteString()));
        LogServiceProtos.GetLogLengthReplyProto proto = LogServiceProtos.GetLogLengthReplyProto.parseFrom(reply.getMessage().getContent());
        if (proto.hasException()) {
            LogServiceProtos.LogServiceException e = proto.getException();
            throw new IOException(e.getErrorMsg());
        }
        return proto.getLength();
    }

    @Override
    public LogReader createReader() throws IOException {
        return new LogReaderImpl(this);
    }

    @Override
    public LogWriter createWriter() {
        return new LogWriterImpl(this);
    }

    @Override
    public long getLastRecordId() throws IOException {
        try {
            RaftClientReply reply = this.raftClient.sendReadOnly(Message.valueOf((ByteString)LogServiceProtoUtil.toGetLastCommittedIndexRequestProto(this.name).toByteString()));
            LogServiceProtos.GetLogLastCommittedIndexReplyProto proto = LogServiceProtos.GetLogLastCommittedIndexReplyProto.parseFrom(reply.getMessage().getContent());
            if (proto.hasException()) {
                LogServiceProtos.LogServiceException e = proto.getException();
                throw new IOException(e.getErrorMsg());
            }
            return proto.getLastCommittedIndex();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public long getStartRecordId() throws IOException {
        try {
            RaftClientReply reply = this.raftClient.sendReadOnly(Message.valueOf((ByteString)LogServiceProtoUtil.toGetStartIndexProto(this.name).toByteString()));
            LogServiceProtos.GetLogStartIndexReplyProto proto = LogServiceProtos.GetLogStartIndexReplyProto.parseFrom(reply.getMessage().getContent());
            if (proto.hasException()) {
                LogServiceProtos.LogServiceException e = proto.getException();
                throw new IOException(e.getErrorMsg());
            }
            return proto.getStartIndex();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public Collection<RecordListener> getRecordListeners() {
        return this.listeners;
    }

    @Override
    public LogServiceConfiguration getConfiguration() {
        return this.config;
    }

    @Override
    public void close() throws Exception {
        this.state = LogStream.State.CLOSED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRecordListener(RecordListener listener) {
        List<RecordListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    @Override
    public boolean removeRecordListener(RecordListener listener) {
        return this.listeners.remove(listener);
    }

    @Override
    public RaftClient getRaftClient() {
        return this.raftClient;
    }
}

