/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.logservice.impl;

import java.io.IOException;
import java.util.Collection;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.logservice.api.ArchiveLogReader;
import org.apache.ratis.logservice.api.LogName;
import org.apache.ratis.logservice.api.LogServiceConfiguration;
import org.apache.ratis.logservice.api.LogStream;
import org.apache.ratis.logservice.api.LogWriter;
import org.apache.ratis.logservice.api.RecordListener;
import org.apache.ratis.logservice.impl.ArchiveHdfsLogReader;
import org.apache.ratis.logservice.util.LogServiceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchivedLogStreamImpl
implements LogStream {
    public static final Logger LOG = LoggerFactory.getLogger(ArchivedLogStreamImpl.class);
    private String location;
    LogName name;
    LogServiceConfiguration config;
    LogStream.State state;

    public ArchivedLogStreamImpl(LogName name, LogServiceConfiguration config) {
        this(name, config.get("logservice.archival.location"));
        if (config != null) {
            this.config = config;
        }
        this.init();
    }

    protected ArchivedLogStreamImpl(LogName name, String location) {
        this.name = name;
        this.location = location;
    }

    protected void init() {
        this.state = LogStream.State.ARCHIVED;
    }

    @Override
    public LogName getName() {
        return this.name;
    }

    @Override
    public LogStream.State getState() throws IOException {
        return this.state;
    }

    @Override
    public long getSize() throws IOException {
        throw new UnsupportedOperationException("getSize()");
    }

    @Override
    public long getLength() throws IOException {
        throw new UnsupportedOperationException("getLength()");
    }

    @Override
    public ArchiveLogReader createReader() throws IOException {
        return new ArchiveHdfsLogReader(LogServiceUtils.getArchiveLocationForLog(this.location, this.name));
    }

    @Override
    public LogWriter createWriter() {
        throw new UnsupportedOperationException("Archived log cannot be written");
    }

    @Override
    public long getLastRecordId() throws IOException {
        throw new UnsupportedOperationException("getLastRecordId()");
    }

    @Override
    public long getStartRecordId() throws IOException {
        throw new UnsupportedOperationException("getStartRecordId()");
    }

    @Override
    public Collection<RecordListener> getRecordListeners() {
        throw new UnsupportedOperationException("get record listeners");
    }

    @Override
    public LogServiceConfiguration getConfiguration() {
        return this.config;
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public void addRecordListener(RecordListener listener) {
        throw new UnsupportedOperationException("Add record listener");
    }

    @Override
    public boolean removeRecordListener(RecordListener listener) {
        throw new UnsupportedOperationException("remove record listener");
    }

    @Override
    public RaftClient getRaftClient() {
        throw new UnsupportedOperationException("getRaftClient()");
    }
}

