/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.client.impl;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.client.RaftClientRpc;
import org.apache.ratis.client.impl.OrderedAsync;
import org.apache.ratis.client.impl.UnorderedAsync;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.AlreadyClosedException;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.GroupInfoReply;
import org.apache.ratis.protocol.GroupInfoRequest;
import org.apache.ratis.protocol.GroupListReply;
import org.apache.ratis.protocol.GroupListRequest;
import org.apache.ratis.protocol.GroupManagementRequest;
import org.apache.ratis.protocol.GroupMismatchException;
import org.apache.ratis.protocol.LeaderNotReadyException;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.NotLeaderException;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftException;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.RaftRetryFailureException;
import org.apache.ratis.protocol.SetConfigurationRequest;
import org.apache.ratis.protocol.StateMachineException;
import org.apache.ratis.protocol.TimeoutIOException;
import org.apache.ratis.retry.RetryPolicy;
import org.apache.ratis.util.CollectionUtils;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.TimeoutScheduler;

final class RaftClientImpl
implements RaftClient {
    private static final AtomicLong CALL_ID_COUNTER = new AtomicLong();
    private final ClientId clientId;
    private final RaftClientRpc clientRpc;
    private final Collection<RaftPeer> peers;
    private final RaftGroupId groupId;
    private final RetryPolicy retryPolicy;
    private volatile RaftPeerId leaderId;
    private final TimeoutScheduler scheduler;
    private final Supplier<OrderedAsync> orderedAsync;

    static long nextCallId() {
        return CALL_ID_COUNTER.getAndIncrement() & Long.MAX_VALUE;
    }

    RaftClientImpl(ClientId clientId, RaftGroup group, RaftPeerId leaderId, RaftClientRpc clientRpc, RaftProperties properties, RetryPolicy retryPolicy) {
        this.clientId = clientId;
        this.clientRpc = clientRpc;
        this.peers = new ConcurrentLinkedQueue<RaftPeer>(group.getPeers());
        this.groupId = group.getGroupId();
        this.leaderId = leaderId != null ? leaderId : (!this.peers.isEmpty() ? this.peers.iterator().next().getId() : null);
        Preconditions.assertTrue((retryPolicy != null ? 1 : 0) != 0, (Object)"retry policy can't be null");
        this.retryPolicy = retryPolicy;
        this.scheduler = TimeoutScheduler.newInstance((int)0);
        clientRpc.addServers(this.peers);
        this.orderedAsync = JavaUtils.memoize(() -> new OrderedAsync(this, properties));
    }

    @Override
    public ClientId getId() {
        return this.clientId;
    }

    RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    TimeoutScheduler getScheduler() {
        return this.scheduler;
    }

    OrderedAsync getOrderedAsync() {
        return this.orderedAsync.get();
    }

    @Override
    public CompletableFuture<RaftClientReply> sendAsync(Message message) {
        return this.sendAsync(RaftClientRequest.writeRequestType(), message, null);
    }

    @Override
    public CompletableFuture<RaftClientReply> sendReadOnlyAsync(Message message) {
        return this.sendAsync(RaftClientRequest.readRequestType(), message, null);
    }

    @Override
    public CompletableFuture<RaftClientReply> sendStaleReadAsync(Message message, long minIndex, RaftPeerId server) {
        return this.sendAsync(RaftClientRequest.staleReadRequestType((long)minIndex), message, server);
    }

    @Override
    public CompletableFuture<RaftClientReply> sendWatchAsync(long index, RaftProtos.ReplicationLevel replication) {
        return UnorderedAsync.send(RaftClientRequest.watchRequestType((long)index, (RaftProtos.ReplicationLevel)replication), this);
    }

    private CompletableFuture<RaftClientReply> sendAsync(RaftClientRequest.Type type, Message message, RaftPeerId server) {
        return this.getOrderedAsync().send(type, message, server);
    }

    RaftClientRequest newRaftClientRequest(RaftPeerId server, long callId, Message message, RaftClientRequest.Type type, RaftProtos.SlidingWindowEntry slidingWindowEntry) {
        return new RaftClientRequest(this.clientId, server != null ? server : this.leaderId, this.groupId, callId, message, type, slidingWindowEntry);
    }

    @Override
    public RaftClientReply send(Message message) throws IOException {
        return this.send(RaftClientRequest.writeRequestType(), message, null);
    }

    @Override
    public RaftClientReply sendReadOnly(Message message) throws IOException {
        return this.send(RaftClientRequest.readRequestType(), message, null);
    }

    @Override
    public RaftClientReply sendStaleRead(Message message, long minIndex, RaftPeerId server) throws IOException {
        return this.send(RaftClientRequest.staleReadRequestType((long)minIndex), message, server);
    }

    @Override
    public RaftClientReply sendWatch(long index, RaftProtos.ReplicationLevel replication) throws IOException {
        return this.send(RaftClientRequest.watchRequestType((long)index, (RaftProtos.ReplicationLevel)replication), null, null);
    }

    private RaftClientReply send(RaftClientRequest.Type type, Message message, RaftPeerId server) throws IOException {
        if (!type.is(RaftProtos.RaftClientRequestProto.TypeCase.WATCH)) {
            Objects.requireNonNull(message, "message == null");
        }
        long callId = RaftClientImpl.nextCallId();
        return this.sendRequestWithRetry(() -> this.newRaftClientRequest(server, callId, message, type, null));
    }

    @Override
    public RaftClientReply setConfiguration(RaftPeer[] peersInNewConf) throws IOException {
        Objects.requireNonNull(peersInNewConf, "peersInNewConf == null");
        long callId = RaftClientImpl.nextCallId();
        this.addServers(Arrays.stream(peersInNewConf));
        return this.sendRequestWithRetry(() -> new SetConfigurationRequest(this.clientId, this.leaderId, this.groupId, callId, Arrays.asList(peersInNewConf)));
    }

    @Override
    public RaftClientReply groupAdd(RaftGroup newGroup, RaftPeerId server) throws IOException {
        Objects.requireNonNull(newGroup, "newGroup == null");
        Objects.requireNonNull(server, "server == null");
        long callId = RaftClientImpl.nextCallId();
        this.addServers(newGroup.getPeers().stream());
        return this.sendRequest((RaftClientRequest)GroupManagementRequest.newAdd((ClientId)this.clientId, (RaftPeerId)server, (long)callId, (RaftGroup)newGroup));
    }

    @Override
    public RaftClientReply groupRemove(RaftGroupId grpId, boolean deleteDirectory, RaftPeerId server) throws IOException {
        Objects.requireNonNull(this.groupId, "groupId == null");
        Objects.requireNonNull(server, "server == null");
        long callId = RaftClientImpl.nextCallId();
        return this.sendRequest((RaftClientRequest)GroupManagementRequest.newRemove((ClientId)this.clientId, (RaftPeerId)server, (long)callId, (RaftGroupId)grpId, (boolean)deleteDirectory));
    }

    @Override
    public GroupListReply getGroupList(RaftPeerId server) throws IOException {
        Objects.requireNonNull(server, "server == null");
        RaftClientReply reply = this.sendRequest((RaftClientRequest)new GroupListRequest(this.clientId, server, this.groupId, RaftClientImpl.nextCallId()));
        Preconditions.assertTrue((boolean)(reply instanceof GroupListReply), () -> "Unexpected reply: " + reply);
        return (GroupListReply)reply;
    }

    @Override
    public GroupInfoReply getGroupInfo(RaftGroupId raftGroupId, RaftPeerId server) throws IOException {
        Objects.requireNonNull(server, "server == null");
        RaftGroupId rgi = raftGroupId == null ? this.groupId : raftGroupId;
        RaftClientReply reply = this.sendRequest((RaftClientRequest)new GroupInfoRequest(this.clientId, server, rgi, RaftClientImpl.nextCallId()));
        Preconditions.assertTrue((boolean)(reply instanceof GroupInfoReply), () -> "Unexpected reply: " + reply);
        return (GroupInfoReply)reply;
    }

    private void addServers(Stream<RaftPeer> peersInNewConf) {
        this.clientRpc.addServers(peersInNewConf.filter(p -> !this.peers.contains(p))::iterator);
    }

    private RaftClientReply sendRequestWithRetry(Supplier<RaftClientRequest> supplier) throws IOException {
        int attemptCount = 1;
        while (true) {
            RaftClientRequest request = supplier.get();
            IOException ioe = null;
            try {
                RaftClientReply reply = this.sendRequest(request);
                if (reply != null) {
                    return reply;
                }
            }
            catch (GroupMismatchException | StateMachineException e) {
                throw e;
            }
            catch (IOException e) {
                ioe = e;
            }
            if (!this.retryPolicy.shouldRetry(attemptCount, request)) {
                throw (IOException)this.noMoreRetries(request, attemptCount, ioe);
            }
            try {
                this.retryPolicy.getSleepTime(attemptCount, request).sleep();
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException("retry policy=" + this.retryPolicy);
            }
            ++attemptCount;
        }
    }

    Throwable noMoreRetries(RaftClientRequest request, int attemptCount, Throwable throwable) {
        if (attemptCount == 1 && throwable != null) {
            return throwable;
        }
        return new RaftRetryFailureException(request, attemptCount, this.retryPolicy, throwable);
    }

    private RaftClientReply sendRequest(RaftClientRequest request) throws IOException {
        RaftClientReply reply;
        LOG.debug("{}: send {}", (Object)this.clientId, (Object)request);
        try {
            reply = this.clientRpc.sendRequest(request);
        }
        catch (GroupMismatchException gme) {
            throw gme;
        }
        catch (IOException ioe) {
            this.handleIOException(request, ioe);
            throw ioe;
        }
        LOG.debug("{}: receive {}", (Object)this.clientId, (Object)reply);
        reply = this.handleLeaderException(request, reply, null);
        reply = RaftClientImpl.handleRaftException(reply, Function.identity());
        return reply;
    }

    static <E extends Throwable> RaftClientReply handleRaftException(RaftClientReply reply, Function<RaftException, E> converter) throws E {
        RaftException e;
        if (reply != null && (e = reply.getException()) != null) {
            throw (Throwable)converter.apply(e);
        }
        return reply;
    }

    RaftClientReply handleLeaderException(RaftClientRequest request, RaftClientReply reply, Consumer<RaftClientRequest> handler) {
        if (reply == null || reply.getException() instanceof LeaderNotReadyException) {
            return null;
        }
        NotLeaderException nle = reply.getNotLeaderException();
        if (nle == null) {
            return reply;
        }
        return this.handleNotLeaderException(request, nle, handler);
    }

    RaftClientReply handleNotLeaderException(RaftClientRequest request, NotLeaderException nle, Consumer<RaftClientRequest> handler) {
        this.refreshPeers(nle.getPeers());
        RaftPeerId newLeader = nle.getSuggestedLeader() == null ? null : nle.getSuggestedLeader().getId();
        this.handleIOException(request, (IOException)nle, newLeader, handler);
        return null;
    }

    private void refreshPeers(Collection<RaftPeer> newPeers) {
        if (newPeers != null && newPeers.size() > 0) {
            this.peers.clear();
            this.peers.addAll(newPeers);
            this.clientRpc.addServers(newPeers);
        }
    }

    void handleIOException(RaftClientRequest request, IOException ioe) {
        this.handleIOException(request, ioe, null, null);
    }

    void handleIOException(RaftClientRequest request, IOException ioe, RaftPeerId newLeader, Consumer<RaftClientRequest> handler) {
        boolean reconnect;
        LOG.debug("{}: suggested new leader: {}. Failed {} with {}", new Object[]{this.clientId, newLeader, request, ioe});
        if (LOG.isTraceEnabled()) {
            LOG.trace("Stack trace", new Throwable("TRACE"));
        }
        Optional.ofNullable(handler).ifPresent(h -> h.accept(request));
        if (ioe instanceof LeaderNotReadyException) {
            return;
        }
        RaftPeerId oldLeader = request.getServerId();
        RaftPeerId curLeader = this.leaderId;
        boolean stillLeader = oldLeader.equals((Object)curLeader);
        if (newLeader == null && stillLeader) {
            newLeader = (RaftPeerId)CollectionUtils.random((Object)oldLeader, (Iterable)CollectionUtils.as(this.peers, RaftPeer::getId));
        }
        LOG.debug("{}: oldLeader={},  curLeader={}, newLeader={}", new Object[]{this.clientId, oldLeader, curLeader, newLeader});
        boolean changeLeader = !(ioe instanceof AlreadyClosedException) && !(ioe instanceof TimeoutIOException) && newLeader != null && stillLeader;
        boolean bl = reconnect = changeLeader || this.clientRpc.shouldReconnect(ioe);
        if (reconnect) {
            if (changeLeader && oldLeader.equals((Object)this.leaderId)) {
                LOG.debug("{} {}: client change Leader from {} to {} ex={}", new Object[]{this.groupId, this.clientId, oldLeader, newLeader, ioe.getClass().getName()});
                this.leaderId = newLeader;
            }
            this.clientRpc.handleException(oldLeader, ioe, reconnect);
        }
    }

    long getCallId() {
        return CALL_ID_COUNTER.get();
    }

    @Override
    public RaftClientRpc getClientRpc() {
        return this.clientRpc;
    }

    @Override
    public void close() throws IOException {
        this.scheduler.close();
        this.clientRpc.close();
    }

    static abstract class PendingClientRequest {
        private final CompletableFuture<RaftClientReply> replyFuture = new CompletableFuture();
        private final AtomicInteger attemptCount = new AtomicInteger();

        PendingClientRequest() {
        }

        abstract RaftClientRequest newRequestImpl();

        final RaftClientRequest newRequest() {
            this.attemptCount.incrementAndGet();
            return this.newRequestImpl();
        }

        CompletableFuture<RaftClientReply> getReplyFuture() {
            return this.replyFuture;
        }

        int getAttemptCount() {
            return this.attemptCount.get();
        }
    }
}

