/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.client.impl;

import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import java.util.function.Function;
import java.util.function.LongFunction;
import org.apache.ratis.client.RaftClientConfigKeys;
import org.apache.ratis.client.impl.RaftClientImpl;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.GroupMismatchException;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.NotLeaderException;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftException;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.retry.RetryPolicies;
import org.apache.ratis.retry.RetryPolicy;
import org.apache.ratis.util.IOUtils;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.ProtoUtils;
import org.apache.ratis.util.SlidingWindow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OrderedAsync {
    static final Logger LOG = LoggerFactory.getLogger(OrderedAsync.class);
    private final RaftClientImpl client;
    private final ConcurrentMap<String, SlidingWindow.Client<PendingOrderedRequest, RaftClientReply>> slidingWindows = new ConcurrentHashMap<String, SlidingWindow.Client<PendingOrderedRequest, RaftClientReply>>();
    private final Semaphore requestSemaphore;

    OrderedAsync(RaftClientImpl client, RaftProperties properties) {
        this.client = Objects.requireNonNull(client, "client == null");
        this.requestSemaphore = new Semaphore(RaftClientConfigKeys.Async.maxOutstandingRequests(properties));
    }

    private void resetSlidingWindow(RaftClientRequest request) {
        this.getSlidingWindow(request).resetFirstSeqNum();
    }

    private SlidingWindow.Client<PendingOrderedRequest, RaftClientReply> getSlidingWindow(RaftClientRequest request) {
        return this.getSlidingWindow(request.is(RaftProtos.RaftClientRequestProto.TypeCase.STALEREAD) ? request.getServerId() : null);
    }

    private SlidingWindow.Client<PendingOrderedRequest, RaftClientReply> getSlidingWindow(RaftPeerId target) {
        String id = target != null ? target.toString() : "RAFT";
        return this.slidingWindows.computeIfAbsent(id, key -> new SlidingWindow.Client((Object)(this.client.getId() + "->" + key)));
    }

    private void failAllAsyncRequests(RaftClientRequest request, Throwable t) {
        this.getSlidingWindow(request).fail(request.getSlidingWindowEntry().getSeqNum(), t);
    }

    private void handleAsyncRetryFailure(RaftClientRequest request, int attemptCount, Throwable throwable) {
        this.failAllAsyncRequests(request, this.client.noMoreRetries(request, attemptCount, throwable));
    }

    CompletableFuture<RaftClientReply> send(RaftClientRequest.Type type, Message message, RaftPeerId server) {
        if (!type.is(RaftProtos.RaftClientRequestProto.TypeCase.WATCH)) {
            Objects.requireNonNull(message, "message == null");
        }
        try {
            this.requestSemaphore.acquire();
        }
        catch (InterruptedException e2) {
            return JavaUtils.completeExceptionally((Throwable)IOUtils.toInterruptedIOException((String)("Interrupted when sending " + type + ", message=" + message), (InterruptedException)e2));
        }
        long callId = RaftClientImpl.nextCallId();
        LongFunction<PendingOrderedRequest> constructor = seqNum -> new PendingOrderedRequest(seqNum, slidingWindowEntry -> this.client.newRaftClientRequest(server, callId, message, type, (RaftProtos.SlidingWindowEntry)slidingWindowEntry));
        return ((CompletableFuture)((PendingOrderedRequest)this.getSlidingWindow(server).submitNewRequest(constructor, this::sendRequestWithRetry)).getReplyFuture().thenApply(reply -> RaftClientImpl.handleRaftException(reply, CompletionException::new))).whenComplete((r, e) -> this.requestSemaphore.release());
    }

    private void sendRequestWithRetry(PendingOrderedRequest pending) {
        RetryPolicy retryPolicy = this.client.getRetryPolicy();
        CompletableFuture<RaftClientReply> f = pending.getReplyFuture();
        if (f.isDone()) {
            return;
        }
        RaftClientRequest request = pending.newRequestImpl();
        ((CompletableFuture)this.sendRequest(pending).thenAccept(reply -> {
            if (f.isDone()) {
                return;
            }
            if (reply == null) {
                this.scheduleWithTimeout(pending, request, retryPolicy);
            } else {
                f.complete((RaftClientReply)reply);
            }
        })).exceptionally(e -> {
            if ((e = JavaUtils.unwrapCompletionException((Throwable)e)) instanceof NotLeaderException) {
                RetryPolicy noLeaderRetry = ((NotLeaderException)e).getSuggestedLeader() != null ? RetryPolicies.retryForeverNoSleep() : retryPolicy;
                this.scheduleWithTimeout(pending, request, noLeaderRetry);
                return null;
            }
            f.completeExceptionally((Throwable)e);
            return null;
        });
    }

    private void scheduleWithTimeout(PendingOrderedRequest pending, RaftClientRequest request, RetryPolicy retryPolicy) {
        int attempt = pending.getAttemptCount();
        LOG.debug("schedule* attempt #{} with policy {} for {}", new Object[]{attempt, retryPolicy, request});
        this.client.getScheduler().onTimeout(retryPolicy.getSleepTime(attempt, request), () -> this.getSlidingWindow(request).retry((SlidingWindow.ClientSideRequest)pending, this::sendRequestWithRetry), LOG, () -> "Failed* to retry " + request);
    }

    private CompletableFuture<RaftClientReply> sendRequest(PendingOrderedRequest pending) {
        RetryPolicy retryPolicy = this.client.getRetryPolicy();
        if (this.getSlidingWindow((RaftPeerId)null).isFirst(pending.getSeqNum())) {
            pending.setFirstRequest();
        }
        RaftClientRequest request = pending.newRequest();
        LOG.debug("{}: send* {}", (Object)this.client.getId(), (Object)request);
        CompletableFuture<RaftClientReply> f = this.client.getClientRpc().sendRequestAsync(request);
        int attemptCount = pending.getAttemptCount();
        return ((CompletableFuture)f.thenApply(reply -> {
            LOG.debug("{}: receive* {}", (Object)this.client.getId(), reply);
            RaftException replyException = reply != null ? reply.getException() : null;
            reply = this.client.handleLeaderException(request, (RaftClientReply)reply, this::resetSlidingWindow);
            if (reply != null) {
                this.getSlidingWindow(request).receiveReply(request.getSlidingWindowEntry().getSeqNum(), reply, this::sendRequestWithRetry);
            } else if (!retryPolicy.shouldRetry(attemptCount, request)) {
                this.handleAsyncRetryFailure(request, attemptCount, (Throwable)replyException);
            }
            return reply;
        })).exceptionally(e -> {
            if (LOG.isTraceEnabled()) {
                LOG.trace(this.client.getId() + ": Failed* " + request, e);
            } else {
                LOG.debug("{}: Failed* {} with {}", new Object[]{this.client.getId(), request, e});
            }
            e = JavaUtils.unwrapCompletionException((Throwable)e);
            if (e instanceof IOException && !(e instanceof GroupMismatchException)) {
                if (!retryPolicy.shouldRetry(attemptCount, request)) {
                    this.handleAsyncRetryFailure(request, attemptCount, (Throwable)e);
                } else if (e instanceof NotLeaderException) {
                    NotLeaderException nle = (NotLeaderException)e;
                    this.client.handleNotLeaderException(request, nle, this::resetSlidingWindow);
                } else {
                    this.client.handleIOException(request, (IOException)e, null, this::resetSlidingWindow);
                }
                if (e instanceof NotLeaderException) {
                    throw new CompletionException((Throwable)e);
                }
                return null;
            }
            this.failAllAsyncRequests(request, (Throwable)e);
            return null;
        });
    }

    void assertRequestSemaphore(int expectedAvailablePermits, int expectedQueueLength) {
        Preconditions.assertTrue((this.requestSemaphore.availablePermits() == expectedAvailablePermits ? 1 : 0) != 0);
        Preconditions.assertTrue((this.requestSemaphore.getQueueLength() == expectedQueueLength ? 1 : 0) != 0);
    }

    static class PendingOrderedRequest
    extends RaftClientImpl.PendingClientRequest
    implements SlidingWindow.ClientSideRequest<RaftClientReply> {
        private final Function<RaftProtos.SlidingWindowEntry, RaftClientRequest> requestConstructor;
        private final long seqNum;
        private volatile boolean isFirst = false;
        private volatile RaftClientRequest request;

        PendingOrderedRequest(long seqNum, Function<RaftProtos.SlidingWindowEntry, RaftClientRequest> requestConstructor) {
            this.seqNum = seqNum;
            this.requestConstructor = requestConstructor;
        }

        @Override
        RaftClientRequest newRequestImpl() {
            this.request = this.requestConstructor.apply(ProtoUtils.toSlidingWindowEntry((long)this.seqNum, (boolean)this.isFirst));
            return this.request;
        }

        RaftClientRequest getRequest() {
            return this.request;
        }

        public void setFirstRequest() {
            this.isFirst = true;
        }

        public long getSeqNum() {
            return this.seqNum;
        }

        public boolean hasReply() {
            return this.getReplyFuture().isDone();
        }

        public void setReply(RaftClientReply reply) {
            this.getReplyFuture().complete(reply);
        }

        public void fail(Throwable e) {
            this.getReplyFuture().completeExceptionally(e);
        }

        public String toString() {
            return "[seq=" + this.getSeqNum() + "]";
        }
    }
}

