/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.client;

import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.apache.ratis.conf.ConfUtils;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.util.TimeDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface RaftClientConfigKeys {
    public static final Logger LOG = LoggerFactory.getLogger(RaftClientConfigKeys.class);
    public static final String PREFIX = "raft.client";

    public static Consumer<String> getDefaultLog() {
        return arg_0 -> ((Logger)LOG).debug(arg_0);
    }

    public static void main(String[] args) {
        ConfUtils.printAll(RaftClientConfigKeys.class);
    }

    public static interface Async {
        public static final String PREFIX = "raft.client.async";
        public static final String MAX_OUTSTANDING_REQUESTS_KEY = "raft.client.async.outstanding-requests.max";
        public static final int MAX_OUTSTANDING_REQUESTS_DEFAULT = 100;

        public static int maxOutstandingRequests(RaftProperties properties) {
            return ConfUtils.getInt((arg_0, arg_1) -> ((RaftProperties)properties).getInt(arg_0, arg_1), (String)MAX_OUTSTANDING_REQUESTS_KEY, (int)100, RaftClientConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[]{ConfUtils.requireMin((int)2)});
        }

        public static void setMaxOutstandingRequests(RaftProperties properties, int outstandingRequests) {
            ConfUtils.setInt((arg_0, arg_1) -> ((RaftProperties)properties).setInt(arg_0, arg_1), (String)MAX_OUTSTANDING_REQUESTS_KEY, (int)outstandingRequests, (BiConsumer[])new BiConsumer[0]);
        }
    }

    public static interface Rpc {
        public static final String PREFIX = "raft.client.rpc";
        public static final String REQUEST_TIMEOUT_KEY = "raft.client.rpc.request.timeout";
        public static final TimeDuration REQUEST_TIMEOUT_DEFAULT = TimeDuration.valueOf((long)3000L, (TimeUnit)TimeUnit.MILLISECONDS);

        public static TimeDuration requestTimeout(RaftProperties properties) {
            return ConfUtils.getTimeDuration((BiFunction)properties.getTimeDuration(REQUEST_TIMEOUT_DEFAULT.getUnit()), (String)REQUEST_TIMEOUT_KEY, (TimeDuration)REQUEST_TIMEOUT_DEFAULT, RaftClientConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[0]);
        }

        public static void setRequestTimeout(RaftProperties properties, TimeDuration timeoutDuration) {
            ConfUtils.setTimeDuration((arg_0, arg_1) -> ((RaftProperties)properties).setTimeDuration(arg_0, arg_1), (String)REQUEST_TIMEOUT_KEY, (TimeDuration)timeoutDuration, (BiConsumer[])new BiConsumer[0]);
        }
    }
}

