/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.metrics.impl;

import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;

class RefCountingMap<K, V> {
    private ConcurrentHashMap<K, Payload<V>> map = new ConcurrentHashMap();

    RefCountingMap() {
    }

    V put(K k, Supplier<V> supplier) {
        return this.map.compute(k, (BiFunction<Object, Payload, Payload>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$put$0(java.util.function.Supplier java.lang.Object org.apache.ratis.metrics.impl.RefCountingMap$Payload ), (Ljava/lang/Object;Lorg/apache/ratis/metrics/impl/RefCountingMap$Payload;)Lorg/apache/ratis/metrics/impl/RefCountingMap$Payload;)(supplier)).v;
    }

    V get(K k) {
        Payload<V> p = this.map.get(k);
        return p == null ? null : (V)p.v;
    }

    V remove(K k) {
        Payload p = this.map.computeIfPresent(k, (k1, v) -> --v.refCount <= 0 ? null : v);
        return p == null ? null : (V)p.v;
    }

    void clear() {
        this.map.clear();
    }

    Set<K> keySet() {
        return this.map.keySet();
    }

    Collection<V> values() {
        return this.map.values().stream().map(v -> v.v).collect(Collectors.toList());
    }

    int size() {
        return this.map.size();
    }

    private static /* synthetic */ Payload lambda$put$0(Supplier supplier, Object k1, Payload oldValue) {
        if (oldValue != null) {
            ++oldValue.refCount;
            return oldValue;
        }
        return new Payload(supplier.get());
    }

    private static class Payload<V> {
        V v;
        int refCount;

        Payload(V v) {
            this.v = v;
            this.refCount = 1;
        }
    }
}

