/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.metrics.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.apache.ratis.metrics.MetricRegistries;
import org.apache.ratis.metrics.MetricRegistryFactory;
import org.apache.ratis.metrics.MetricRegistryInfo;
import org.apache.ratis.metrics.RatisMetricRegistry;
import org.apache.ratis.metrics.impl.MetricRegistryFactoryImpl;
import org.apache.ratis.metrics.impl.RefCountingMap;

public class MetricRegistriesImpl
extends MetricRegistries {
    private final MetricRegistryFactory factory;
    private final RefCountingMap<MetricRegistryInfo, RatisMetricRegistry> registries;

    public MetricRegistriesImpl() {
        this(new MetricRegistryFactoryImpl());
    }

    public MetricRegistriesImpl(MetricRegistryFactory factory) {
        this.factory = factory;
        this.registries = new RefCountingMap();
    }

    @Override
    public RatisMetricRegistry create(MetricRegistryInfo info) {
        return this.registries.put(info, () -> this.factory.create(info));
    }

    @Override
    public boolean remove(MetricRegistryInfo key) {
        return this.registries.remove(key) == null;
    }

    @Override
    public Optional<RatisMetricRegistry> get(MetricRegistryInfo info) {
        return Optional.ofNullable(this.registries.get(info));
    }

    @Override
    public Collection<RatisMetricRegistry> getMetricRegistries() {
        return Collections.unmodifiableCollection(this.registries.values());
    }

    @Override
    public void clear() {
        this.registries.clear();
    }

    @Override
    public Set<MetricRegistryInfo> getMetricRegistryInfos() {
        return Collections.unmodifiableSet(this.registries.keySet());
    }
}

