/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.metrics;

import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ganglia.GangliaReporter;
import com.github.joshelser.dropwizard.metrics.hadoop.HadoopMetrics2Reporter;
import info.ganglia.gmetric4j.gmetric.GMetric;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.ratis.metrics.MetricRegistryInfo;
import org.apache.ratis.metrics.RatisMetricRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsReporting {
    public static final Logger LOG = LoggerFactory.getLogger(MetricsReporting.class);
    private TimeUnit unit;
    private long period;
    private static RatisMetricRegistry jvmRegistry;
    private GMetric ganglia;

    public MetricsReporting(long period, TimeUnit unit) {
        this.period = period;
        this.unit = unit;
    }

    public void configureGanglia(String host, int port) throws IOException {
        this.ganglia = new GMetric(host, port, GMetric.UDPAddressingMode.MULTICAST, 1);
    }

    public boolean startMetricsReporter(RatisMetricRegistry registry, MetricReporterType ... reporting) {
        MetricRegistry dropWizardRegistry = registry.getDropWizardMetricRegistry();
        for (MetricReporterType reporter : reporting) {
            try {
                switch (reporter) {
                    case CONSOLE: {
                        ConsoleReporter.forRegistry((MetricRegistry)dropWizardRegistry).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build().start(this.period, this.unit);
                        break;
                    }
                    case JMX: {
                        JmxReporter.Builder builder = JmxReporter.forRegistry((MetricRegistry)dropWizardRegistry);
                        builder.inDomain(registry.getMetricRegistryInfo().getApplicationName());
                        builder.build().start();
                        break;
                    }
                    case HADOOP2: {
                        MetricRegistryInfo info = registry.getMetricRegistryInfo();
                        HadoopMetrics2Reporter.forRegistry((MetricRegistry)dropWizardRegistry).build(DefaultMetricsSystem.instance(), info.getName(), info.getMetricsDescription(), info.getMetricsComponentName()).start(this.period, this.unit);
                        break;
                    }
                    case GANGLIA: {
                        if (this.ganglia == null) {
                            throw new IllegalStateException("Ganglia is not configured!! please configure it first by using MetricReporting#configureGanglia..");
                        }
                        GangliaReporter.forRegistry((MetricRegistry)dropWizardRegistry).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build(this.ganglia);
                        break;
                    }
                    default: {
                        LOG.warn("Unhandled reporter, " + (Object)((Object)reporter) + " provided.");
                        return false;
                    }
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    static {
        DefaultMetricsSystem.initialize((String)"ratis");
    }

    public static enum MetricReporterType {
        JMX,
        HADOOP2,
        CONSOLE,
        GANGLIA;

    }
}

