/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.metrics;

import com.codahale.metrics.MetricSet;
import com.codahale.metrics.jvm.ClassLoadingGaugeSet;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.codahale.metrics.jvm.ThreadStatesGaugeSet;
import java.util.concurrent.TimeUnit;
import org.apache.ratis.metrics.MetricRegistries;
import org.apache.ratis.metrics.MetricRegistryInfo;
import org.apache.ratis.metrics.MetricsReporting;
import org.apache.ratis.metrics.RatisMetricRegistry;

public class JVMMetrics {
    static MetricRegistryInfo info = new MetricRegistryInfo("jvm", "ratis_jvm", "jvm", "jvm metrics");
    static RatisMetricRegistry registry = MetricRegistries.global().create(info);

    public static RatisMetricRegistry getRegistry() {
        return registry;
    }

    public static void startJVMReporting(long period, TimeUnit unit, MetricsReporting.MetricReporterType ... reporting) {
        MetricsReporting metricsReporting = new MetricsReporting(period, unit);
        metricsReporting.startMetricsReporter(JVMMetrics.getRegistry(), reporting);
    }

    static {
        registry.registerAll("gc", (MetricSet)new GarbageCollectorMetricSet());
        registry.registerAll("memory", (MetricSet)new MemoryUsageGaugeSet());
        registry.registerAll("threads", (MetricSet)new ThreadStatesGaugeSet());
        registry.registerAll("classLoading", (MetricSet)new ClassLoadingGaugeSet());
    }
}

