/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.io.Closeable;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.ratis.util.Daemon;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.LogUtils;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.TimeDuration;
import org.apache.ratis.util.function.CheckedRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TimeoutScheduler
implements Closeable {
    public static final Logger LOG = LoggerFactory.getLogger(TimeoutScheduler.class);
    static final TimeDuration DEFAULT_GRACE_PERIOD = TimeDuration.valueOf(1L, TimeUnit.MINUTES);
    private final AtomicReference<TimeDuration> gracePeriod = new AtomicReference<TimeDuration>(DEFAULT_GRACE_PERIOD);
    private int numTasks = 0;
    private int scheduleID = 0;
    private ShutdownTask shutdownTask = null;
    private final int numThreads;
    private volatile ScheduledThreadPoolExecutor scheduler = null;

    public static TimeoutScheduler newInstance(int numThreads) {
        return new TimeoutScheduler(numThreads);
    }

    private TimeoutScheduler(int numThreads) {
        this.numThreads = numThreads;
    }

    int getQueueSize() {
        return Optional.ofNullable(this.scheduler).map(ScheduledThreadPoolExecutor::getQueue).map(Collection::size).orElse(0);
    }

    TimeDuration getGracePeriod() {
        return this.gracePeriod.get();
    }

    void setGracePeriod(TimeDuration gracePeriod) {
        this.gracePeriod.set(gracePeriod);
    }

    synchronized boolean hasScheduler() {
        return this.scheduler != null;
    }

    public <THROWABLE extends Throwable> void onTimeout(TimeDuration timeout, CheckedRunnable<THROWABLE> task, Consumer<THROWABLE> errorHandler) {
        this.onTimeout(timeout, sid -> {
            LOG.debug("run a task: sid {}", sid);
            try {
                task.run();
            }
            catch (Throwable t) {
                errorHandler.accept(JavaUtils.cast(t));
            }
            finally {
                this.onTaskCompleted();
            }
        });
    }

    private synchronized void onTimeout(TimeDuration timeout, Consumer<Integer> toSchedule) {
        if (this.scheduler == null) {
            Preconditions.assertTrue(this.numTasks == 0);
            LOG.debug("Initialize scheduler");
            this.scheduler = new ScheduledThreadPoolExecutor(this.numThreads, Daemon::new);
            this.scheduler.setRemoveOnCancelPolicy(true);
        }
        ++this.numTasks;
        int sid = this.scheduleID++;
        LOG.debug("schedule a task: timeout {}, sid {}", (Object)timeout, (Object)sid);
        TimeoutScheduler.schedule(this.scheduler, () -> toSchedule.accept(sid), () -> "task #" + sid, timeout);
    }

    private synchronized void onTaskCompleted() {
        if (--this.numTasks > 0) {
            return;
        }
        int sid = this.scheduleID;
        if (this.shutdownTask != null) {
            if (this.shutdownTask.getSid() == sid) {
                return;
            }
            this.shutdownTask.cancel();
        }
        TimeDuration grace = this.getGracePeriod();
        LOG.debug("Schedule a shutdown task: grace {}, sid {}", (Object)grace, (Object)sid);
        ScheduledFuture<?> future = TimeoutScheduler.schedule(this.scheduler, () -> this.tryShutdownScheduler(sid), () -> "shutdown task #" + sid, grace);
        this.shutdownTask = new ShutdownTask(sid, future);
    }

    private static ScheduledFuture<?> schedule(ScheduledExecutorService service, Runnable task, Supplier<String> name, TimeDuration timeDuration) {
        return service.schedule(LogUtils.newRunnable(LOG, task, name), timeDuration.getDuration(), timeDuration.getUnit());
    }

    private synchronized void tryShutdownScheduler(int sid) {
        if (sid == this.scheduleID) {
            LOG.debug("shutdown scheduler: sid {}", (Object)sid);
            this.scheduler.shutdown();
            this.scheduler = null;
        } else {
            LOG.debug("shutdown cancelled: scheduleID has changed from {} to {}", (Object)sid, (Object)this.scheduleID);
        }
    }

    public void onTimeout(TimeDuration timeout, CheckedRunnable<?> task, Logger log, Supplier<String> errorMessage) {
        this.onTimeout(timeout, task, t -> log.error((String)errorMessage.get(), t));
    }

    @Override
    public synchronized void close() {
        if (this.scheduler != null) {
            LOG.debug("Closing ThreadPool");
            this.scheduler.shutdownNow();
            this.scheduler = null;
        }
    }

    class ShutdownTask
    implements Runnable {
        private final int sid;
        private final ScheduledFuture<?> future;

        ShutdownTask(int sid, ScheduledFuture<?> future) {
            this.sid = sid;
            this.future = future;
        }

        int getSid() {
            return this.sid;
        }

        @Override
        public void run() {
            TimeoutScheduler.this.tryShutdownScheduler(this.sid);
        }

        void cancel() {
            this.future.cancel(false);
        }
    }
}

