/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;

public class ResourceSemaphore
extends Semaphore {
    private final int elementLimit;
    private final AtomicBoolean isClosed = new AtomicBoolean();

    public ResourceSemaphore(int elementLimit) {
        super(elementLimit, true);
        this.elementLimit = elementLimit;
    }

    public void close() {
        if (this.isClosed.compareAndSet(false, true)) {
            this.reducePermits(this.elementLimit);
        }
    }

    public boolean isClosed() {
        return this.isClosed.get();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ":elementLimit=" + this.elementLimit + ",closed?" + this.isClosed;
    }
}

