/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.thirdparty.com.google.protobuf.ServiceException;
import org.apache.ratis.util.IOUtils;

public interface ProtoUtils {
    public static ByteString writeObject2ByteString(Object obj) {
        ByteString.Output byteOut = ByteString.newOutput();
        try (ObjectOutputStream objOut = new ObjectOutputStream((OutputStream)byteOut);){
            objOut.writeObject(obj);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected IOException when writing an object to a ByteString.", e);
        }
        return byteOut.toByteString();
    }

    public static Object toObject(ByteString bytes) {
        return IOUtils.readObject(bytes.newInput(), Object.class);
    }

    public static ByteString toByteString(String string) {
        return ByteString.copyFromUtf8((String)string);
    }

    public static ByteString toByteString(byte[] bytes) {
        return ProtoUtils.toByteString(bytes, 0, bytes.length);
    }

    public static ByteString toByteString(byte[] bytes, int offset, int size) {
        return bytes.length == 0 ? ByteString.EMPTY : ByteString.copyFrom((byte[])bytes, (int)offset, (int)size);
    }

    public static RaftPeer toRaftPeer(RaftProtos.RaftPeerProto p) {
        return new RaftPeer(RaftPeerId.valueOf(p.getId()), p.getAddress());
    }

    public static List<RaftPeer> toRaftPeers(List<RaftProtos.RaftPeerProto> protos) {
        return protos.stream().map(ProtoUtils::toRaftPeer).collect(Collectors.toList());
    }

    public static Iterable<RaftProtos.RaftPeerProto> toRaftPeerProtos(final Collection<RaftPeer> peers) {
        return () -> new Iterator<RaftProtos.RaftPeerProto>(){
            final Iterator i;
            {
                this.i = peers.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.i.hasNext();
            }

            @Override
            public RaftProtos.RaftPeerProto next() {
                return ((RaftPeer)this.i.next()).getRaftPeerProto();
            }
        };
    }

    public static RaftGroupId toRaftGroupId(RaftProtos.RaftGroupIdProto proto) {
        return RaftGroupId.valueOf(proto.getId());
    }

    public static RaftProtos.RaftGroupIdProto.Builder toRaftGroupIdProtoBuilder(RaftGroupId id) {
        return RaftProtos.RaftGroupIdProto.newBuilder().setId(id.toByteString());
    }

    public static RaftGroup toRaftGroup(RaftProtos.RaftGroupProto proto) {
        return RaftGroup.valueOf(ProtoUtils.toRaftGroupId(proto.getGroupId()), ProtoUtils.toRaftPeers(proto.getPeersList()));
    }

    public static RaftProtos.RaftGroupProto.Builder toRaftGroupProtoBuilder(RaftGroup group) {
        return RaftProtos.RaftGroupProto.newBuilder().setGroupId(ProtoUtils.toRaftGroupIdProtoBuilder(group.getGroupId())).addAllPeers(ProtoUtils.toRaftPeerProtos(group.getPeers()));
    }

    public static RaftGroupMemberId toRaftGroupMemberId(ByteString peerId, RaftProtos.RaftGroupIdProto groupId) {
        return RaftGroupMemberId.valueOf(RaftPeerId.valueOf(peerId), ProtoUtils.toRaftGroupId(groupId));
    }

    public static RaftGroupMemberId toRaftGroupMemberId(RaftProtos.RaftGroupMemberIdProto memberId) {
        return ProtoUtils.toRaftGroupMemberId(memberId.getPeerId(), memberId.getGroupId());
    }

    public static RaftProtos.RaftGroupMemberIdProto.Builder toRaftGroupMemberIdProtoBuilder(RaftGroupMemberId memberId) {
        return RaftProtos.RaftGroupMemberIdProto.newBuilder().setPeerId(memberId.getPeerId().toByteString()).setGroupId(ProtoUtils.toRaftGroupIdProtoBuilder(memberId.getGroupId()));
    }

    public static RaftProtos.CommitInfoProto toCommitInfoProto(RaftPeer peer, long commitIndex) {
        return RaftProtos.CommitInfoProto.newBuilder().setServer(peer.getRaftPeerProto()).setCommitIndex(commitIndex).build();
    }

    public static void addCommitInfos(Collection<RaftProtos.CommitInfoProto> commitInfos, Consumer<RaftProtos.CommitInfoProto> accumulator) {
        if (commitInfos != null && !commitInfos.isEmpty()) {
            commitInfos.forEach(accumulator);
        }
    }

    public static String toString(RaftProtos.CommitInfoProto proto) {
        return RaftPeerId.valueOf(proto.getServer().getId()) + ":c" + proto.getCommitIndex();
    }

    public static String toString(Collection<RaftProtos.CommitInfoProto> protos) {
        return protos.stream().map(ProtoUtils::toString).collect(Collectors.toList()).toString();
    }

    public static RaftProtos.SlidingWindowEntry toSlidingWindowEntry(long seqNum, boolean isFirst) {
        return RaftProtos.SlidingWindowEntry.newBuilder().setSeqNum(seqNum).setIsFirst(isFirst).build();
    }

    public static String toString(RaftProtos.SlidingWindowEntry proto) {
        return proto.getSeqNum() + (proto.getIsFirst() ? "*" : "");
    }

    public static IOException toIOException(ServiceException se) {
        Throwable t = se.getCause();
        if (t == null) {
            return new IOException((Throwable)se);
        }
        return t instanceof IOException ? (IOException)t : new IOException((Throwable)se);
    }

    public static String toString(RaftProtos.RaftRpcRequestProto proto) {
        return proto.getRequestorId().toStringUtf8() + "->" + proto.getReplyId().toStringUtf8() + "#" + proto.getCallId();
    }

    public static String toString(RaftProtos.RaftRpcReplyProto proto) {
        return proto.getRequestorId().toStringUtf8() + "<-" + proto.getReplyId().toStringUtf8() + "#" + proto.getCallId() + ":" + (proto.getSuccess() ? "OK" : "FAIL");
    }
}

