/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import org.apache.ratis.util.AutoCloseableLock;

public class AutoCloseableReadWriteLock {
    private final Object name;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
    private final AtomicInteger depth = new AtomicInteger();

    public AutoCloseableReadWriteLock(Object name) {
        this.name = name;
    }

    public AutoCloseableLock readLock(StackTraceElement caller, Consumer<String> log) {
        AutoCloseableLock readLock = AutoCloseableLock.acquire(this.lock.readLock(), () -> this.logLocking(this.name, caller, true, false, log));
        this.logLocking(this.name, caller, true, true, log);
        return readLock;
    }

    public AutoCloseableLock writeLock(StackTraceElement caller, Consumer<String> log) {
        AutoCloseableLock writeLock = AutoCloseableLock.acquire(this.lock.writeLock(), () -> this.logLocking(this.name, caller, false, false, log));
        this.logLocking(this.name, caller, false, true, log);
        return writeLock;
    }

    private void logLocking(Object name, StackTraceElement caller, boolean read, boolean acquire, Consumer<String> log) {
        if (caller != null && log != null) {
            int d = acquire ? this.depth.getAndIncrement() : this.depth.decrementAndGet();
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < d; ++i) {
                b.append("  ");
            }
            if (name != null) {
                b.append(name).append(": ");
            }
            b.append(read ? "readLock " : "writeLock ").append(acquire ? "ACQUIRED " : "RELEASED ").append(this.depth).append(" by ");
            String className = caller.getClassName();
            int i = className.lastIndexOf(46);
            b.append(i >= 0 ? className.substring(i + 1) : className).append(".").append(caller.getMethodName());
            log.accept(b.toString());
        }
    }
}

