/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.retry;

import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.retry.RetryPolicy;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.TimeDuration;

public interface RetryPolicies {
    public static RetryPolicy retryForeverNoSleep() {
        return Constants.RETRY_FOREVER_NO_SLEEP;
    }

    public static RetryPolicy noRetry() {
        return Constants.NO_RETRY;
    }

    public static RetryForeverWithSleep retryForeverWithSleep(TimeDuration sleepTime) {
        return new RetryForeverWithSleep(sleepTime);
    }

    public static RetryLimited retryUpToMaximumCountWithFixedSleep(int maxAttempts, TimeDuration sleepTime) {
        return new RetryLimited(maxAttempts, sleepTime);
    }

    public static class RequestTypeDependentRetry
    implements RetryPolicy {
        private final Map<RaftProtos.RaftClientRequestProto.TypeCase, RetryPolicy> map;

        public static Builder newBuilder() {
            return new Builder();
        }

        private RequestTypeDependentRetry(EnumMap<RaftProtos.RaftClientRequestProto.TypeCase, RetryPolicy> map) {
            this.map = Collections.unmodifiableMap(map);
        }

        @Override
        public boolean shouldRetry(int attemptCount, RaftClientRequest request) {
            return Optional.ofNullable(this.map.get(request.getType().getTypeCase())).orElse(RetryPolicies.retryForeverNoSleep()).shouldRetry(attemptCount, request);
        }

        @Override
        public TimeDuration getSleepTime(int attemptCount, RaftClientRequest request) {
            return Optional.ofNullable(this.map.get(request.getType().getTypeCase())).orElse(RetryPolicies.retryForeverNoSleep()).getSleepTime(attemptCount, request);
        }

        public String toString() {
            StringBuilder b = new StringBuilder(this.getClass().getSimpleName()).append("{");
            this.map.forEach((key, value) -> b.append(key).append("->").append(value).append(", "));
            b.setLength(b.length() - 2);
            return b.append("}").toString();
        }

        public static class Builder {
            private final EnumMap<RaftProtos.RaftClientRequestProto.TypeCase, RetryPolicy> map = new EnumMap(RaftProtos.RaftClientRequestProto.TypeCase.class);

            public Builder set(RaftProtos.RaftClientRequestProto.TypeCase type, RetryPolicy policy) {
                RetryPolicy previous = this.map.put(type, policy);
                Preconditions.assertNull((Object)previous, () -> "The type " + type + " is already set to " + previous);
                return this;
            }

            public RequestTypeDependentRetry build() {
                return new RequestTypeDependentRetry(this.map);
            }
        }
    }

    public static class RetryLimited
    implements RetryPolicy {
        private final int maxAttempts;
        private final TimeDuration sleepTime;
        private String myString;

        private RetryLimited(int maxAttempts, TimeDuration sleepTime) {
            if (maxAttempts < 0) {
                throw new IllegalArgumentException("maxAttempts = " + maxAttempts + " < 0");
            }
            if (sleepTime.isNegative()) {
                throw new IllegalArgumentException("sleepTime = " + sleepTime.getDuration() + " < 0");
            }
            this.maxAttempts = maxAttempts;
            this.sleepTime = sleepTime;
        }

        @Override
        public TimeDuration getSleepTime(int attemptCount, RaftClientRequest request) {
            return this.shouldRetry(attemptCount, request) ? this.sleepTime : ZERO_MILLIS;
        }

        public int getMaxAttempts() {
            return this.maxAttempts;
        }

        @Override
        public boolean shouldRetry(int attemptCount, RaftClientRequest request) {
            return attemptCount < this.maxAttempts;
        }

        public String toString() {
            if (this.myString == null) {
                this.myString = this.getClass().getSimpleName() + "(maxAttempts=" + this.maxAttempts + ", sleepTime=" + this.sleepTime + ")";
            }
            return this.myString;
        }
    }

    public static class RetryForeverWithSleep
    implements RetryPolicy {
        private final TimeDuration sleepTime;

        private RetryForeverWithSleep(TimeDuration sleepTime) {
            Preconditions.assertTrue(!sleepTime.isNegative(), () -> "sleepTime = " + sleepTime.getDuration() + " < 0");
            this.sleepTime = sleepTime;
        }

        @Override
        public TimeDuration getSleepTime(int attemptCount, RaftClientRequest request) {
            return this.sleepTime;
        }

        @Override
        public boolean shouldRetry(int attemptCount, RaftClientRequest request) {
            return true;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "(sleepTime = " + this.sleepTime + ")";
        }
    }

    public static class NoRetry
    implements RetryPolicy {
        private NoRetry() {
        }

        @Override
        public boolean shouldRetry(int attemptCount, RaftClientRequest request) {
            return false;
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    public static class RetryForeverNoSleep
    implements RetryPolicy {
        private RetryForeverNoSleep() {
        }

        @Override
        public boolean shouldRetry(int attemptCount, RaftClientRequest request) {
            return true;
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    public static class Constants {
        private static final RetryForeverNoSleep RETRY_FOREVER_NO_SLEEP = new RetryForeverNoSleep();
        private static final NoRetry NO_RETRY = new NoRetry();
    }
}

