/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.protocol;

import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeerId;

public class GroupManagementRequest
extends RaftClientRequest {
    private final Op op;

    public static GroupManagementRequest newAdd(ClientId clientId, RaftPeerId serverId, long callId, RaftGroup group) {
        return new GroupManagementRequest(clientId, serverId, callId, new Add(group));
    }

    public static GroupManagementRequest newRemove(ClientId clientId, RaftPeerId serverId, long callId, RaftGroupId groupId, boolean deleteDirectory) {
        return new GroupManagementRequest(clientId, serverId, callId, new Remove(groupId, deleteDirectory));
    }

    private GroupManagementRequest(ClientId clientId, RaftPeerId serverId, long callId, Op op) {
        super(clientId, serverId, op.getGroupId(), callId, GroupManagementRequest.writeRequestType());
        this.op = op;
    }

    public Add getAdd() {
        return this.op instanceof Add ? (Add)this.op : null;
    }

    public Remove getRemove() {
        return this.op instanceof Remove ? (Remove)this.op : null;
    }

    @Override
    public String toString() {
        return super.toString() + ", " + this.op;
    }

    public static class Remove
    extends Op {
        private final RaftGroupId groupId;
        private final boolean deleteDirectory;

        public Remove(RaftGroupId groupId, boolean deleteDirectory) {
            this.groupId = groupId;
            this.deleteDirectory = deleteDirectory;
        }

        @Override
        public RaftGroupId getGroupId() {
            return this.groupId;
        }

        public boolean isDeleteDirectory() {
            return this.deleteDirectory;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ":" + this.getGroupId() + ", " + (this.deleteDirectory ? "delete" : "retain") + "-dir";
        }
    }

    public static class Add
    extends Op {
        private final RaftGroup group;

        public Add(RaftGroup group) {
            this.group = group;
        }

        @Override
        public RaftGroupId getGroupId() {
            return this.getGroup().getGroupId();
        }

        public RaftGroup getGroup() {
            return this.group;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ":" + this.getGroup();
        }
    }

    public static abstract class Op {
        public abstract RaftGroupId getGroupId();
    }
}

