/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.logservice.util;

import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;

public class LogServiceUtils {
    public static Set<RaftPeer> getPeersFromIds(String identity) {
        return Stream.of(identity.split(",")).map(elem -> new RaftPeer(RaftPeerId.valueOf((String)elem), elem.replace('_', ':'))).collect(Collectors.toSet());
    }

    public static Set<RaftPeer> getPeersFromQuorum(String identity) {
        return Stream.of(identity.split(",")).map(elem -> new RaftPeer(RaftPeerId.valueOf((String)elem.replace(':', '_')), elem)).collect(Collectors.toSet());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getHostName() {
        try (DatagramSocket socket = new DatagramSocket();){
            socket.connect(InetAddress.getByName("8.8.8.8"), 10002);
            String string = socket.getLocalAddress().getHostName();
            return string;
        }
        catch (Exception e) {
            return "localhost";
        }
    }
}

