/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.logservice.tool;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.ratis.logservice.api.LogName;
import org.apache.ratis.logservice.api.LogReader;
import org.apache.ratis.logservice.api.LogStream;
import org.apache.ratis.logservice.api.LogWriter;
import org.apache.ratis.logservice.client.LogServiceClient;
import org.apache.ratis.logservice.server.LogStateMachine;
import org.jline.utils.Log;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerificationTool {
    public static final Logger LOG = LoggerFactory.getLogger(LogStateMachine.class);
    @Parameter(names={"-q", "--metaQuorum"}, description="Metadata Service Quorum")
    private String metaQuorum;
    public static String LOG_NAME_PREFIX = "testlog";
    public static String MESSAGE_PREFIX = "message";
    private int numLogs = 10;
    private int numRecords = 1000;

    public static void main(String[] args) {
        int i;
        VerificationTool tool = new VerificationTool();
        JCommander.newBuilder().addObject((Object)tool).build().parse(args);
        System.out.println(tool.metaQuorum);
        LogServiceClient client = new LogServiceClient(tool.metaQuorum);
        ExecutorService executor = Executors.newCachedThreadPool();
        ArrayList<Future<Object>> futures = new ArrayList(tool.numLogs);
        for (i = 0; i < tool.numLogs; ++i) {
            BulkWriter writer = new BulkWriter(LOG_NAME_PREFIX + i, client, tool.numRecords);
            futures.add(executor.submit(writer));
        }
        VerificationTool.waitForCompletion(futures);
        futures = new ArrayList(tool.numLogs);
        for (i = 0; i < tool.numLogs; ++i) {
            BulkReader reader = new BulkReader(LOG_NAME_PREFIX + i, client, tool.numRecords);
            futures.add(executor.submit(reader));
        }
        VerificationTool.waitForCompletion(futures);
        executor.shutdownNow();
    }

    private static void waitForCompletion(List<Future<?>> futures) {
        for (Future<?> future : futures) {
            try {
                Object object = future.get();
                if (object == null) continue;
                LOG.error("Operation failed with error ", object);
                System.exit(-1);
            }
            catch (Exception e) {
                LOG.error("Got exception ", (Throwable)e);
                System.exit(-1);
            }
        }
    }

    static class BulkReader
    implements Runnable {
        private String logName;
        private LogServiceClient logServiceClient;
        private int numRecords;

        BulkReader(String logName, LogServiceClient logServiceClient, int numRecords) {
            this.logName = logName;
            this.logServiceClient = logServiceClient;
            this.numRecords = numRecords;
        }

        @Override
        public void run() {
            try {
                LogStream logStream = this.logServiceClient.getLog(LogName.of(this.logName));
                LogReader reader = logStream.createReader();
                long size = logStream.getLength();
                if (size != (long)this.numRecords) {
                    Log.error((Object[])new Object[]{"There is mismatch is number of records. Expected Records: " + this.numRecords + ", Actual Records: " + size});
                    System.exit(-1);
                }
                int i = 0;
                while ((long)i < size) {
                    ByteBuffer buffer = reader.readNext();
                    String message = new String(buffer.array(), buffer.arrayOffset(), buffer.remaining(), StandardCharsets.UTF_8);
                    System.out.println(this.logName + " Read " + message);
                    if (!message.equals(MESSAGE_PREFIX + i)) {
                        Log.error((Object[])new Object[]{"Message is not correct. Expected: " + MESSAGE_PREFIX + i + ". Actual:" + message});
                        System.exit(-1);
                    }
                    ++i;
                }
                Log.info((Object[])new Object[]{"" + this.numRecords + " log entries read from log " + this.logName + " successfully."});
                reader.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static class BulkWriter
    implements Runnable {
        private String logName;
        private LogServiceClient logServiceClient;
        private int numRecords;

        BulkWriter(String logName, LogServiceClient logServiceClient, int numRecords) {
            this.logName = logName;
            this.logServiceClient = logServiceClient;
            this.numRecords = numRecords;
        }

        @Override
        public void run() {
            try {
                LogStream logStream = this.logServiceClient.createLog(LogName.of(this.logName));
                LogWriter writer = logStream.createWriter();
                for (int i = 0; i < this.numRecords; ++i) {
                    String message = MESSAGE_PREFIX + i;
                    System.out.println(this.logName + " Writing " + message);
                    writer.write(ByteBuffer.wrap(message.getBytes(StandardCharsets.UTF_8)));
                }
                writer.close();
                Log.info((Object[])new Object[]{"" + this.numRecords + "log entries written to log " + this.logName + " successfully."});
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

